/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.libusb;

import de.ailis.usb4java.libusb.ConfigDescriptor;
import de.ailis.usb4java.libusb.Context;
import de.ailis.usb4java.libusb.Device;
import de.ailis.usb4java.libusb.DeviceDescriptor;
import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.DeviceList;
import de.ailis.usb4java.libusb.Loader;
import de.ailis.usb4java.libusb.PollfdListener;
import de.ailis.usb4java.libusb.Transfer;
import de.ailis.usb4java.libusb.Version;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public final class LibUsb {
    public static final int LOG_LEVEL_NONE = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int SUCCESS = 0;
    public static final int ERROR_IO = -1;
    public static final int ERROR_INVALID_PARAM = -2;
    public static final int ERROR_ACCESS = -3;
    public static final int ERROR_NO_DEVICE = -4;
    public static final int ERROR_NOT_FOUND = -5;
    public static final int ERROR_BUSY = -6;
    public static final int ERROR_TIMEOUT = -7;
    public static final int ERROR_OVERFLOW = -8;
    public static final int ERROR_PIPE = -9;
    public static final int ERROR_INTERRUPTED = -10;
    public static final int ERROR_NO_MEM = -11;
    public static final int ERROR_NOT_SUPPORTED = -12;
    public static final int ERROR_OTHER = -99;
    public static final int SPEED_UNKNOWN = 0;
    public static final int SPEED_LOW = 1;
    public static final int SPEED_FULL = 2;
    public static final int SPEED_HIGH = 3;
    public static final int SPEED_SUPER = 4;
    public static final int REQUEST_GET_STATUS = 0;
    public static final int REQUEST_CLEAR_FEATURE = 1;
    public static final int REQUEST_SET_FEATURE = 3;
    public static final int REQUEST_SET_ADDRESS = 5;
    public static final int REQUEST_GET_DESCRIPTOR = 6;
    public static final int REQUEST_SET_DESCRIPTOR = 7;
    public static final int REQUEST_GET_CONFIGURATION = 8;
    public static final int REQUEST_SET_CONFIGURATION = 9;
    public static final int REQUEST_GET_INTERFACE = 10;
    public static final int REQUEST_SET_INTERFACE = 11;
    public static final int REQUEST_SYNCH_FRAME = 12;
    public static final int REQUEST_SET_SEL = 48;
    public static final int SET_ISOCH_DELAY = 49;
    public static final int REQUEST_TYPE_STANDARD = 0;
    public static final int REQUEST_TYPE_CLASS = 32;
    public static final int REQUEST_TYPE_VENDOR = 64;
    public static final int REQUEST_TYPE_RESERVED = 96;
    public static final int RECIPIENT_DEVICE = 0;
    public static final int RECIPIENT_INTERFACE = 1;
    public static final int RECIPIENT_ENDPOINT = 2;
    public static final int RECIPIENT_OTHER = 3;
    public static final int CAP_HAS_CAPABILITY = 0;
    public static final int CLASS_PER_INTERFACE = 0;
    public static final int CLASS_AUDIO = 1;
    public static final int CLASS_COMM = 2;
    public static final int CLASS_HID = 3;
    public static final int CLASS_PHYSICAL = 5;
    public static final int CLASS_PTP = 6;
    public static final int CLASS_IMAGE = 6;
    public static final int CLASS_PRINTER = 7;
    public static final int CLASS_MASS_STORAGE = 8;
    public static final int CLASS_HUB = 9;
    public static final int CLASS_DATA = 10;
    public static final int CLASS_SMART_CARD = 11;
    public static final int CLASS_CONTENT_SECURITY = 13;
    public static final int CLASS_VIDEO = 14;
    public static final int CLASS_PERSONAL_HEALTHCARE = 15;
    public static final int CLASS_DIAGNOSTIC_DEVICE = 220;
    public static final int CLASS_WIRELESS = 224;
    public static final int CLASS_APPLICATION = 254;
    public static final int CLASS_VENDOR_SPEC = 255;
    public static final int DT_DEVICE = 1;
    public static final int DT_CONFIG = 2;
    public static final int DT_STRING = 3;
    public static final int DT_INTERFACE = 4;
    public static final int DT_ENDPOINT = 5;
    public static final int DT_HID = 33;
    public static final int DT_REPORT = 34;
    public static final int DT_PHYSICAL = 35;
    public static final int DT_HUB = 41;
    public static final int DT_SUPERSPEED_HUB = 42;
    public static final int DT_DEVICE_SIZE = 18;
    public static final int DT_CONFIG_SIZE = 9;
    public static final int DT_INTERFACE_SIZE = 9;
    public static final int DT_ENDPOINT_SIZE = 7;
    public static final int DT_ENDPOINT_AUDIO_SIZE = 9;
    public static final int DT_HUB_NONVAR_SIZE = 7;
    public static final int ENDPOINT_IN = 128;
    public static final int ENDPOINT_OUT = 0;
    public static final int ENDPOINT_ADDRESS_MASK = 15;
    public static final int ENDPOINT_DIR_MASK = 128;
    public static final int TRANSFER_TYPE_MASK = 3;
    public static final int TRANSFER_TYPE_CONTROL = 0;
    public static final int TRANSFER_TYPE_ISOCHRONOUS = 1;
    public static final int TRANSFER_TYPE_BULK = 2;
    public static final int TRANSFER_TYPE_INTERRUPT = 3;
    public static final int ISO_SYNC_TYPE_NONE = 0;
    public static final int ISO_SYNC_TYPE_ASYNC = 1;
    public static final int ISO_SYNC_TYPE_ADAPTIVE = 2;
    public static final int ISO_SYNC_TYPE_SYNC = 3;
    public static final int ISO_USAGE_TYPE_DATA = 0;
    public static final int ISO_USAGE_TYPE_FEEDBACK = 1;
    public static final int ISO_USAGE_TYPE_IMPLICIT = 2;
    public static final int TRANSFER_SHORT_NOT_OK = 1;
    public static final int TRANSFER_FREE_BUFFER = 2;
    public static final int TRANSFER_FREE_TRANSFER = 4;
    public static final int TRANSFER_ADD_ZERO_PACKET = 8;
    public static final int TRANSFER_COMPLETED = 0;
    public static final int TRANSFER_ERROR = 1;
    public static final int TRANSFER_TIMED_OUT = 2;
    public static final int TRANSFER_CANCELLED = 3;
    public static final int TRANSFER_STALL = 4;
    public static final int TRANSFER_NO_DEVICE = 5;
    public static final int TRANSFER_OVERFLOW = 6;
    private static final int MAX_STRING_SIZE = 126;
    private static PollfdListener pollfdListener;
    private static Object pollfdListenerUserData;

    private LibUsb() {
    }

    public static native int init(Context var0);

    public static native void exit(Context var0);

    public static native void setDebug(Context var0, int var1);

    public static native Version getVersion();

    public static native int getDeviceList(Context var0, DeviceList var1);

    public static native void freeDeviceList(DeviceList var0, boolean var1);

    public static native int getBusNumber(Device var0);

    public static native int getPortNumber(Device var0);

    public static native int getPortPath(Context var0, Device var1, byte[] var2);

    public static native Device getParent(Device var0);

    public static native int getDeviceAddress(Device var0);

    public static native int getDeviceSpeed(Device var0);

    public static native int getMaxPacketSize(Device var0, int var1);

    public static native int getMaxIsoPacketSize(Device var0, int var1);

    public static native Device refDevice(Device var0);

    public static native void unrefDevice(Device var0);

    public static native int open(Device var0, DeviceHandle var1);

    public static native DeviceHandle openDeviceWithVidPid(Context var0, int var1, int var2);

    public static native void close(DeviceHandle var0);

    public static native Device getDevice(DeviceHandle var0);

    public static native int getConfiguration(DeviceHandle var0, IntBuffer var1);

    public static native int setConfiguration(DeviceHandle var0, int var1);

    public static native int claimInterface(DeviceHandle var0, int var1);

    public static native int releaseInterface(DeviceHandle var0, int var1);

    public static native int setInterfaceAltSetting(DeviceHandle var0, int var1, int var2);

    public static native int clearHalt(DeviceHandle var0, int var1);

    public static native int resetDevice(DeviceHandle var0);

    public static native int kernelDriverActive(DeviceHandle var0, int var1);

    public static native int detachKernelDriver(DeviceHandle var0, int var1);

    public static native int attachKernelDriver(DeviceHandle var0, int var1);

    public static native boolean hasCapability(int var0);

    public static native String errorName(int var0);

    public static native int le16ToCpu(int var0);

    public static native int cpuToLe16(int var0);

    public static native int getDeviceDescriptor(Device var0, DeviceDescriptor var1);

    public static native int getStringDescriptorAscii(DeviceHandle var0, int var1, StringBuffer var2, int var3);

    public static String getStringDescriptor(DeviceHandle handle, int index) {
        if (handle == null || index == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (LibUsb.getStringDescriptorAscii(handle, index, buffer, 126) >= 0) {
            return buffer.toString();
        }
        return null;
    }

    public static native int getActiveConfigDescriptor(Device var0, ConfigDescriptor var1);

    public static native int getConfigDescriptor(Device var0, int var1, ConfigDescriptor var2);

    public static native int getConfigDescriptorByValue(Device var0, int var1, ConfigDescriptor var2);

    public static native void freeConfigDescriptor(ConfigDescriptor var0);

    public static native int getDescriptor(DeviceHandle var0, int var1, int var2, ByteBuffer var3);

    public static native int getStringDescriptor(DeviceHandle var0, int var1, int var2, ByteBuffer var3);

    public static native int controlTransfer(DeviceHandle var0, int var1, int var2, int var3, int var4, ByteBuffer var5, int var6);

    public static native int bulkTransfer(DeviceHandle var0, int var1, ByteBuffer var2, IntBuffer var3, int var4);

    public static native int interruptTransfer(DeviceHandle var0, int var1, ByteBuffer var2, IntBuffer var3, int var4);

    public static native int tryLockEvents(Context var0);

    public static native void lockEvents(Context var0);

    public static native void unlockEvents(Context var0);

    public static native int eventHandlingOk(Context var0);

    public static native int eventHandlerActive(Context var0);

    public static native void lockEventWaiters(Context var0);

    public static native void unlockEventWaiters(Context var0);

    public static native int waitForEvent(Context var0, long var1);

    public static native int handleEventsTimeoutCompleted(Context var0, long var1, IntBuffer var3);

    public static native int handleEventsTimeout(Context var0, long var1);

    public static native int handleEvents(Context var0);

    public static native int handleEventsCompleted(Context var0, IntBuffer var1);

    public static native int handleEventsLocked(Context var0, long var1);

    public static native int pollfdsHandleTimeouts(Context var0);

    public static native int getNextTimeout(Context var0, IntBuffer var1);

    public static void setPollfdNotifiers(Context context, PollfdListener listener, Object userData) {
        pollfdListener = listener;
        pollfdListenerUserData = userData;
        if (listener == null) {
            LibUsb.unsetPollfdNotifiers(context);
        } else {
            LibUsb.setPollfdNotifiers(context);
        }
    }

    static void triggerPollfdAdded(FileDescriptor fd, int events) {
        if (pollfdListener != null) {
            pollfdListener.pollfdAdded(fd, events, pollfdListenerUserData);
        }
    }

    static void triggerPollfdRemoved(FileDescriptor fd) {
        if (pollfdListener != null) {
            pollfdListener.pollfdRemoved(fd, pollfdListenerUserData);
        }
    }

    static native void setPollfdNotifiers(Context var0);

    static native void unsetPollfdNotifiers(Context var0);

    public static native Transfer allocTransfer(int var0);

    public static native void freeTransfer(Transfer var0);

    static {
        Loader.load();
    }
}

