/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.utils;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbInterfaceDescriptor;

public final class DescriptorUtils {
    private static final Map<Integer, String> CLASS_NAMES = new HashMap<Integer, String>();

    private DescriptorUtils() {
    }

    public static String getUSBClassName(int usbClass) {
        String name = CLASS_NAMES.get(usbClass);
        if (name == null) {
            return "Unknown";
        }
        return name;
    }

    public static String decodeBCD(int bcd) {
        return String.format("%x.%02x", (bcd & 0xFF00) >> 8, bcd & 0xFF);
    }

    public static String dump(ByteBuffer bytes) {
        int columns = 16;
        bytes.rewind();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (bytes.hasRemaining()) {
            if (i % 16 != 0) {
                builder.append(' ');
            } else if (i >= 16) {
                builder.append(String.format("%n", new Object[0]));
            }
            builder.append(String.format("%02x", bytes.get()));
            ++i;
        }
        return builder.toString();
    }

    public static String dump(UsbDeviceDescriptor descriptor) {
        return DescriptorUtils.dump(descriptor, null, null, null);
    }

    public static String dump(UsbDeviceDescriptor descriptor, String manufacturer, String product, String serial) {
        return String.format("Device Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bcdUSB %19s%n  bDeviceClass %13d %s%n  bDeviceSubClass %10d%n  bDeviceProtocol %10d%n  bMaxPacketSize0 %10d%n  idVendor %17s%n  idProduct %16s%n  bcdDevice %16s%n  iManufacturer %12d%s%n  iProduct %17d%s%n  iSerial %18d%s%n  bNumConfigurations %7d", descriptor.bLength(), descriptor.bDescriptorType(), DescriptorUtils.decodeBCD(descriptor.bcdUSB()), descriptor.bDeviceClass() & 0xFF, DescriptorUtils.getUSBClassName(descriptor.bDeviceClass() & 0xFF), descriptor.bDeviceSubClass() & 0xFF, descriptor.bDeviceProtocol() & 0xFF, descriptor.bMaxPacketSize0() & 0xFF, String.format("0x%04x", descriptor.idVendor() & 0xFFFF), String.format("0x%04x", descriptor.idProduct() & 0xFFFF), DescriptorUtils.decodeBCD(descriptor.bcdDevice()), descriptor.iManufacturer() & 0xFF, manufacturer == null ? "" : " " + manufacturer, descriptor.iProduct() & 0xFF, product == null ? "" : " " + product, descriptor.iSerialNumber() & 0xFF, serial == null ? "" : " " + serial, descriptor.bNumConfigurations() & 0xFF);
    }

    public static String dump(UsbConfigurationDescriptor descriptor) {
        return String.format("Configuration Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  wTotalLength %13d%n  bNumInterfaces %11d%n  bConfigurationValue %6d%n  iConfiguration %11d%n  bmAttributes %13s%n    %s%n%s  bMaxPower %16smA", descriptor.bLength(), descriptor.bDescriptorType(), descriptor.wTotalLength() & 0xFFFF, descriptor.bNumInterfaces() & 0xFF, descriptor.bConfigurationValue() & 0xFF, descriptor.iConfiguration() & 0xFF, String.format("0x%02x", descriptor.bmAttributes() & 0xFF), (descriptor.bmAttributes() & 0x40) == 0 ? "(Bus Powered)" : "Self Powered", (descriptor.bmAttributes() & 0x20) == 0 ? "" : String.format("    Remote Wakeup%n", new Object[0]), (descriptor.bMaxPower() & 0xFF) * 2);
    }

    public static String dump(UsbInterfaceDescriptor descriptor) {
        return String.format("Interface Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bInterfaceNumber %9d%n  bAlternateSetting %8d%n  bNumEndpoints %12d%n  bInterfaceClass %10d %s%n  bInterfaceSubClass %7d%n  bInterfaceProtocol %7d%n  iInterface %15d", descriptor.bLength(), descriptor.bDescriptorType(), descriptor.bInterfaceNumber() & 0xFF, descriptor.bAlternateSetting() & 0xFF, descriptor.bNumEndpoints() & 0xFF, descriptor.bInterfaceClass() & 0xFF, DescriptorUtils.getUSBClassName(descriptor.bInterfaceClass() & 0xFF), descriptor.bInterfaceSubClass() & 0xFF, descriptor.bInterfaceProtocol() & 0xFF, descriptor.iInterface() & 0xFF);
    }

    public static String dump(UsbEndpointDescriptor descriptor) {
        return String.format("Endpoint Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bEndpointAddress %9s  EP %d %s%n  bmAttributes %13d%n    Transfer Type             %s%n    Synch Type                %s%n    Usage Type                %s%n  wMaxPacketSize %11d%n  bInterval %16d", descriptor.bLength(), descriptor.bDescriptorType(), String.format("0x%02x", descriptor.bEndpointAddress() & 0xFF), descriptor.bEndpointAddress() & 0xF, (descriptor.bEndpointAddress() & 0x80) == 0 ? "OUT" : "IN", descriptor.bmAttributes() & 0xFF, DescriptorUtils.getTransferTypeName(descriptor.bmAttributes() & 0xFF), DescriptorUtils.getSynchTypeName(descriptor.bmAttributes() & 0xFF), DescriptorUtils.getUsageTypeName(descriptor.bmAttributes() & 0xFF), descriptor.wMaxPacketSize() & 0xFFFF, descriptor.bInterval() & 0xFF);
    }

    public static String getTransferTypeName(int bmAttributes) {
        switch (bmAttributes & 3) {
            case 1: {
                return "Isochronous";
            }
            case 2: {
                return "Bulk";
            }
            case 3: {
                return "Interrupt";
            }
        }
        return "Control";
    }

    public static String getSynchTypeName(int bmAttributes) {
        switch (bmAttributes >> 2 & 3) {
            case 1: {
                return "Asynchronous";
            }
            case 2: {
                return "Adaptive";
            }
            case 3: {
                return "Synchronous";
            }
        }
        return "None";
    }

    public static String getUsageTypeName(int bmAttributes) {
        switch (bmAttributes >> 4 & 3) {
            case 1: {
                return "Feedback";
            }
            case 2: {
                return "Explicit Feedback Data";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Data";
    }

    public static String getSpeedName(int speed) {
        switch (speed) {
            case 4: {
                return "Super";
            }
            case 2: {
                return "Full";
            }
            case 3: {
                return "High";
            }
            case 1: {
                return "Low";
            }
        }
        return "Unknown";
    }

    static {
        CLASS_NAMES.put(0, "Per interface");
        CLASS_NAMES.put(1, "Audio");
        CLASS_NAMES.put(2, "Communications");
        CLASS_NAMES.put(3, "HID");
        CLASS_NAMES.put(6, "Imaging");
        CLASS_NAMES.put(7, "Printer");
        CLASS_NAMES.put(8, "Mass Storage");
        CLASS_NAMES.put(9, "Hub");
        CLASS_NAMES.put(10, "Data");
        CLASS_NAMES.put(11, "Smart Card");
        CLASS_NAMES.put(13, "Content Security");
        CLASS_NAMES.put(14, "Video");
        CLASS_NAMES.put(255, "Vendor-specific");
        CLASS_NAMES.put(254, "Application");
        CLASS_NAMES.put(15, "Personal Healthcare");
        CLASS_NAMES.put(220, "Diagnostic Device");
        CLASS_NAMES.put(224, "Wireless");
    }
}

