/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.socket;

import br.com.auttar.clientservices.handlers.socket.LocalClientSocketHandler;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.SocketHandler;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMessageSocketHandler
extends MessageSocketHandler {
    protected Log log = LogFactory.getLog(DefaultMessageSocketHandler.class);
    private LocalClientSocketHandler localClientHandler = (LocalClientSocketHandler)this.getClient();

    public DefaultMessageSocketHandler(SocketHandler socketHandler, byte[] message) {
        super(socketHandler, message);
    }

    @Override
    public void execute() {
        try {
            JsonObject jsonObject = new JsonParser().parse(new String(this.getMessage())).getAsJsonObject();
            String requestId = null;
            if (jsonObject.has("id")) {
                requestId = jsonObject.get("id").getAsString();
            } else if (jsonObject.has("request_id")) {
                requestId = jsonObject.get("request_id").getAsString();
            }
            if (requestId != null) {
                SessionMessage sessionMessage = this.localClientHandler.removeSessionMessage(requestId);
                if (sessionMessage != null) {
                    if (jsonObject.has("id")) {
                        jsonObject.remove("id");
                    }
                    if ((sessionMessage.getType() == SessionMessageType.get_tax_receipt || sessionMessage.getType() == SessionMessageType.post_payment) && jsonObject.has("data")) {
                        JsonObject newJsonObject = jsonObject.getAsJsonObject("data");
                        if (jsonObject.has("status")) {
                            newJsonObject.add("status", jsonObject.get("status"));
                        }
                        if (jsonObject.has("code")) {
                            newJsonObject.add("code", jsonObject.get("code"));
                        }
                        if (jsonObject.has("message")) {
                            newJsonObject.add("message", jsonObject.get("message"));
                        }
                        jsonObject = newJsonObject;
                    }
                    sessionMessage.send(jsonObject);
                } else {
                    this.log.warn((Object)("nao foi possivel identificar uma sessao valida para o id " + requestId));
                }
            } else {
                this.log.error((Object)"id ou request_id nao encontrado");
            }
        }
        catch (JsonParseException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void abort() {
    }
}

