/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import com.csi.ctfclient.apitef.ApitefDefault;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.Request;
import com.csi.ctfclient.apitef.Response;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;

public class ApitefJNI
extends ApitefDefault {
    private static ILogger logger = CTFClientLogger.getLogger("com.csi.ctfclient.apitef");

    private native Response solicitacaoTEF2(Request var1);

    private native Response confirmacaoTEF2(Request var1);

    private native Response desfazimentoTEF2(Request var1);

    private native int getCupomTEF2(Request var1);

    public ApitefJNI(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        super(versoesCTFClient, timeOutDefault, habilitaLog, diasLog, path);
    }

    @Override
    protected int getCupomTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC, SaidaApiTefC saidaApiTefC) {
        Class<?> entradaClazz = entradaApiTefC.getClass();
        Field[] fields = entradaClazz.getDeclaredFields();
        HashMap<String, Field> entradaMaps = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SubCampo.class)) continue;
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            field.setAccessible(true);
            entradaMaps.put(subCampo.codigo(), field);
        }
        Class<?> clazz = saidaApiTefC.getClass();
        fields = clazz.getDeclaredFields();
        HashMap<String, Field> saidaMaps = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SubCampo.class)) continue;
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            field.setAccessible(true);
            saidaMaps.put(subCampo.codigo(), field);
        }
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        StringBuilder builder = new StringBuilder();
        try {
            Field field = (Field)entradaMaps.get("0048");
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            String strSubCampo = this.formataSubCampo(subCampo, field, entradaApiTefC);
            if (strSubCampo != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)entradaMaps.get("0120")).getAnnotation(SubCampo.class), field, entradaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0083")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0084")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0157")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0162")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0164")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0165")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
        }
        catch (Exception e) {
            logger.error("erro ao formatar cupom", e);
        }
        byte[] array = new byte[builder.length() + 100];
        System.arraycopy(builder.toString().getBytes(), 0, array, 0, builder.length());
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(array) + "\u0000");
        this.preparaPath(identApiTefC, request);
        int ret = this.getCupomTEF2(request);
        return ret;
    }

    @Override
    protected SaidaApiTefC solicitacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.solicitacaoTEF2(request);
        String ret = ApitefJNI.completaString(response.getRet() + "", 2, '0', true);
        String erro = ApitefJNI.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), this.output);
        return saidaApiTefC;
    }

    @Override
    protected SaidaApiTefC confirmacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.confirmacaoTEF2(request);
        String ret = ApitefJNI.completaString(response.getRet() + "", 2, '0', true);
        String erro = ApitefJNI.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), response.getOutput().getBytes());
        return saidaApiTefC;
    }

    @Override
    protected SaidaApiTefC desfazimentoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.desfazimentoTEF2(request);
        String ret = ApitefJNI.completaString(response.getRet() + "", 2, '0', true);
        String erro = ApitefJNI.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), response.getOutput().getBytes());
        return saidaApiTefC;
    }

    private void preparaPath(IdentApiTefC identApiTefC, Request request) {
        if (this.getPath() != null) {
            int idxEmpresa = this.getVersaoPathTerminal() == 1 ? 0 : 1;
            String path = this.getPath() + identApiTefC.getNumeroEstabelecimento().substring(idxEmpresa) + identApiTefC.getNumeroLoja() + "." + identApiTefC.getNumeroPdv() + File.separator;
            request.setPath(path);
            File filePath = new File(path);
            if (!filePath.exists()) {
                filePath.mkdir();
            }
        }
    }

    static {
        System.loadLibrary("apiwebctf");
    }
}

