/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCTFClientCtrl;
import com.csi.ctfclient.config.ConfCTFClientHandler;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfContingenciaConexao;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ConfTimeoutPin;
import com.csi.ctfclient.config.ConfTraceApiwebctf;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.util.ReflectHelp;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import com.csi.ctfclient.tools.util.xml.Config;
import com.csi.ctfclient.tools.util.xml.MultipleNamesFoundException;
import com.csi.ctfclient.tools.util.xml.NoSuchParameterException;
import com.csi.ctfclient.tools.util.xml.Parameter;
import com.csi.ctfclient.tools.util.xml.ParameterSet;
import com.csi.ctfclient.tools.util.xml.ParseConfigException;
import com.csi.ctfclient.tools.util.xml.StructureConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class ConfCTFClientDefaultHandler
extends ConfCTFClientHandler {
    private static ILogger logger = CTFClientLogger.getConfigurator();
    private final String FILE_CONFIG = "configCTFClient.xml";
    private final String INVALID_PARAMETER = "valor de parametro invalido";
    private static String CTFCLIENT_HOME_VALUE = null;

    @Override
    public String getDiretorioTrabalho() {
        if (CTFCLIENT_HOME_VALUE == null) {
            String ctfclient_home = "";
            BigDecimal versao = new BigDecimal(System.getProperty("java.version").substring(0, 3));
            if (versao.compareTo(new BigDecimal("1.5")) > -1) {
                ctfclient_home = System.getenv("CTFCLIENT_HOME");
            }
            if (ctfclient_home != null) {
                ctfclient_home = ctfclient_home.trim();
                if (!(ctfclient_home = ctfclient_home + File.separator + "bin").endsWith("\\") && !ctfclient_home.endsWith("/")) {
                    ctfclient_home = ctfclient_home + File.separator;
                }
                CTFCLIENT_HOME_VALUE = ctfclient_home;
            }
        }
        return CTFCLIENT_HOME_VALUE;
    }

    @Override
    public void reader() throws ExcecaoApiAc {
        boolean novoParametro = false;
        ConfCTFClient confCTFClient = new ConfCTFClient();
        try {
            LinkedHashSet<ServicoCTF> ips;
            ParameterSet ipsParameter;
            ParameterSet creditoDigital;
            ParameterSet timeOut;
            ParameterSet root;
            Config config;
            String value;
            block222: {
                block221: {
                    block220: {
                        value = null;
                        config = ControladorConfCTFClient.getDiretorioTrabalho() != null ? Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCTFClient.xml") : Config.getConfig("configCTFClient.xml");
                        root = config.getParameterSet("configCTFClient");
                        try {
                            Parameter intTranslatorParameter = root.getParameter("integracaoTranslator");
                            intTranslatorParameter.detach();
                            logger.warn("parametro integracaoTranslator removido com sucesso.");
                        }
                        catch (Exception intTranslatorParameter) {
                            // empty catch block
                        }
                        try {
                            Parameter tipoIntegracaoParameter = root.getParameter("tipointegracao");
                            value = tipoIntegracaoParameter.getContent();
                            if (value == null || value.equals("")) {
                                confCTFClient.setTipoIntegracao("standalone");
                                logger.info("parametro tipointegracao = INTEGRACAO_STANDALONE");
                            } else {
                                confCTFClient.setTipoIntegracao(value);
                                logger.info("parametro tipointegracao = " + value);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("parametro 'tipointegracao' n\u00e3o encontrado. valor default aplicado.");
                            boolean multiTerminal = false;
                            Parameter multiTerminalParameter = root.getParameter("multiterminal");
                            if (multiTerminalParameter != null) {
                                multiTerminal = Boolean.valueOf(multiTerminalParameter.getContent());
                                multiTerminalParameter.detach();
                                logger.info("parametro multiterminal removido.");
                            }
                            Parameter translatorParameter = new Parameter("tipointegracao");
                            if (multiTerminal) {
                                translatorParameter.setContent("web");
                                confCTFClient.setTipoIntegracao("web");
                                logger.info("parametro tipointegracao = web");
                            } else {
                                translatorParameter.setContent("standalone");
                                confCTFClient.setTipoIntegracao("standalone");
                                logger.info("parametro tipointegracao = standalone");
                            }
                            root.attachParameter(translatorParameter);
                            logger.info("parametro tipointegracao criado com sucesso");
                            novoParametro = true;
                        }
                        try {
                            Parameter suporteHttpsParameter = root.getParameter("suporteHttps");
                            confCTFClient.setSuporteHttps(Boolean.valueOf(suporteHttpsParameter.getContent()));
                            logger.info("parametro suporteHttps = '" + suporteHttpsParameter.getContent() + "'");
                        }
                        catch (Exception e) {
                            logger.info("parametro suporteHttps = 'false'");
                            confCTFClient.setSuporteHttps(false);
                        }
                        try {
                            Parameter homologacaoParameter = root.getParameter("homologacao");
                            confCTFClient.setHomologacao(Boolean.valueOf(homologacaoParameter.getContent()));
                            logger.info("-------------------------------------------------------------------");
                            logger.info("parametro homologacao = '" + homologacaoParameter.getContent() + "'");
                            logger.info("-------------------------------------------------------------------");
                        }
                        catch (Exception e) {
                            confCTFClient.setHomologacao(false);
                        }
                        try {
                            Parameter pathTerminalParameter = root.getParameter("versaoPathTerminal");
                            confCTFClient.setVersaoPathTerminal(Integer.parseInt(pathTerminalParameter.getContent()));
                            logger.info("parametro versaoPathTerminal = '" + pathTerminalParameter.getContent() + "'");
                        }
                        catch (Exception e) {
                            logger.info("parametro versaoPathTerminal = '0'");
                            confCTFClient.setVersaoPathTerminal(0);
                            if (!confCTFClient.isIntegracaoWeb() || confCTFClient.getVersaoPathTerminal() != 0) break block220;
                            confCTFClient.setVersaoPathTerminal(1);
                            logger.warn("parametro versaoPathTerminal configurado para valor = '1'. integracao web identificada.");
                        }
                    }
                    try {
                        Parameter cnpjParameter = root.getParameter("cnpj");
                        String cnpj = cnpjParameter.getContent();
                        confCTFClient.setCnpj(cnpj.trim());
                    }
                    catch (Exception e) {
                        logger.warn("cnpj do estabelecimento nao informado");
                    }
                    value = root.getParameter("estabelecimento").getContent();
                    if (!this.validaEstabelecimento(value)) {
                        logger.log("WARN", "valor de parametro nao definido ==> estabelecimento");
                    } else {
                        confCTFClient.setEstabelecimento(value);
                        logger.log("INFO", "parametro estabelecimento = '" + value + "'");
                    }
                    value = root.getParameter("loja").getContent();
                    if (!this.validaLoja(value)) {
                        logger.log("WARN", "valor de parametro nao definido ==> loja");
                    } else {
                        confCTFClient.setLoja(value);
                        logger.log("INFO", "parametro loja = '" + value + "'");
                    }
                    value = root.getParameter("terminal").getContent();
                    if ((value == null || value.equals("")) && !confCTFClient.isIntegracaoWeb()) {
                        logger.log("WARN", "valor de parametro nao definido ==> terminal");
                    } else {
                        confCTFClient.setTerminal(value);
                        logger.log("INFO", "parametro terminal = '" + value + "'");
                    }
                    try {
                        Parameter confirmarDesfazimentoParameter = root.getParameter("confirmardesfazimento");
                        value = confirmarDesfazimentoParameter.getContent();
                        confCTFClient.setConfirmarDesfazimento(Boolean.valueOf(value));
                        logger.info("parametro confirmardesfazimento = " + value);
                    }
                    catch (Exception e) {
                        logger.warn("parametro 'confirmardesfazimento' n\u00e3o encontrado. valor default aplicado.");
                        logger.warn("parametro confirmardesfazimento = false");
                        confCTFClient.setConfirmarDesfazimento(false);
                    }
                    value = root.getParameter("permitePagarSaldoVoucher").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> permitePagarSaldoVoucher");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setPermitePagarSaldoVoucher(Boolean.valueOf(value));
                    logger.log("INFO", "parametro permitePagarSaldoVoucher = " + value);
                    value = root.getParameter("rotearPrivateLabel").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> rotearPrivateLabel");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setRotearPrivateLabel(Boolean.valueOf(value));
                    logger.log("INFO", "parametro rotearPrivateLabel = " + value);
                    value = root.getParameter("codigoTabela").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> codigoTabela");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setCodigoTabela(Integer.valueOf(value));
                    logger.log("INFO", "parametro codigoTabela = '" + value + "'");
                    value = root.getParameter("numeroSite").getContent();
                    try {
                        if (value != null || value != null && !value.equals("")) {
                            Integer sites = new Integer(value);
                            if (!this.validaNumeroSites(sites)) {
                                new Exception();
                            }
                            confCTFClient.setNumeroSites(sites);
                            logger.log("INFO", "parametro numeroSite = '" + value + "'");
                        }
                    }
                    catch (Exception e) {
                        logger.log("ERROR", "valor de parametro invalido ==> numeroSite");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    value = root.getParameter("quantidadeVias").getContent();
                    try {
                        if (value != null || value != null && !value.equals("")) {
                            Integer vias = new Integer(value);
                            if (!this.validaQuantidadeVias(vias)) {
                                new Exception();
                            }
                            confCTFClient.setQuantidadeVias(vias);
                            logger.log("INFO", "parametro quantidadeVias = '" + value + "'");
                        }
                    }
                    catch (Exception e) {
                        logger.log("ERROR", "valor de parametro invalido ==> quantidadeVias");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    value = root.getParameter("versaoAC").getContent();
                    try {
                        if (value != null || value != null && !value.equals("")) {
                            if (!this.validaVersaoAC(value)) {
                                new Exception();
                            }
                            confCTFClient.setVersaoAC(value);
                            logger.log("INFO", "parametro versaoAC = '" + value + "'");
                        }
                    }
                    catch (Exception e) {
                        logger.log("ERROR", "valor de parametro invalido ==> versaoAC");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    if (confCTFClient.getTipoIntegracao().equalsIgnoreCase("websocket")) {
                        confCTFClient.setHandler("com.csi.ctfclient.integracao.websocket.WebSocketHandler");
                    } else {
                        confCTFClient.setHandler("com.csi.ctfclient.integracao.SocketHandler");
                    }
                    logger.log("INFO", "parametro handler = " + confCTFClient.getHandler());
                    value = root.getParameter("hostclient").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> hostclient");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setHostClient(value);
                    logger.log("INFO", "parametro hostclient = '" + value + "'");
                    value = root.getParameter("portclient").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> portclient");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setPortClient(value);
                    logger.log("INFO", "parametro portclient = '" + value + "'");
                    value = root.getParameter("standalone").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> standalone");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setStandAlone(Boolean.valueOf(value));
                    logger.log("INFO", "parametro standalone = " + value);
                    value = root.getParameter("integracaoCriptografada").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> integracaoCriptografada");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setIntegracaoCriptografada(Boolean.valueOf(value));
                    logger.log("INFO", "parametro integracaoCriptografada = " + value);
                    value = root.getParameter("capturacmc7").getContent();
                    if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        logger.log("ERROR", "valor de parametro invalido ==> capturacmc7");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setCapturaCmc7(Boolean.valueOf(value));
                    logger.log("INFO", "parametro capturacmc7 = " + value);
                    value = root.getParameter("creditoCelularHabilitado").getContent();
                    if (value == null || value.equals("")) {
                        logger.log("ERROR", "valor de parametro invalido ==> creditoCelularHabilitado");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setCreditoCelularHabilitado(Boolean.valueOf(value));
                    logger.log("INFO", "parametro creditoCelularHabilitado = " + value);
                    try {
                        value = root.getParameter("usaComunicacaoSeguraPinpad").getContent();
                    }
                    catch (NoSuchParameterException e) {
                        value = null;
                    }
                    if (value == null || value.equals("")) {
                        confCTFClient.setComunicacaoSeguraPinpad(true);
                    } else {
                        confCTFClient.setComunicacaoSeguraPinpad(Boolean.valueOf(value));
                        logger.log("INFO", "parametro 'CSP' = '" + value + "'");
                    }
                    try {
                        value = root.getParameter("acSuportaPlataformaPromocional").getContent();
                    }
                    catch (NoSuchParameterException e) {
                        Parameter plataformaPromocional = new Parameter("acSuportaPlataformaPromocional");
                        root.attachParameter(plataformaPromocional);
                        novoParametro = true;
                        value = null;
                    }
                    if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        logger.log("WARN", "valor de parametro invalido ==> acSuportaPlataformaPromocional, utilizando default: false");
                        confCTFClient.setAcSuportaPlataformaPromocional(false);
                    } else {
                        confCTFClient.setAcSuportaPlataformaPromocional(Boolean.valueOf(value));
                        logger.log("INFO", "parametro acSuportaPlataformaPromocional = " + value);
                    }
                    try {
                        value = root.getParameter("acSuportaPlataformaPromocional").getContent();
                    }
                    catch (NoSuchParameterException e) {
                        value = null;
                    }
                    if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        logger.log("ERROR", "valor de parametro invalido ==> acSuportaPlataformaPromocional, utilizando default: false");
                        confCTFClient.setAcSuportaPlataformaPromocional(false);
                    } else {
                        confCTFClient.setAcSuportaPlataformaPromocional(Boolean.valueOf(value));
                        logger.log("INFO", "parametro acSuportaPlataformaPromocional = " + value);
                    }
                    try {
                        Parameter pingUdpParameter = root.getParameter("pingUDP");
                        value = pingUdpParameter.getContent();
                        if (value == null || value.equals("")) {
                            confCTFClient.setPingUDP(false);
                            logger.info("parametro pingUDP = false");
                        } else {
                            confCTFClient.setPingUDP(Boolean.valueOf(value));
                            logger.info("parametro pingUDP = " + value);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("parametro 'pingUDP' n\u00e3o encontrado. valor default aplicado.");
                        Parameter pingUdpParameter = new Parameter("pingUDP");
                        pingUdpParameter.setContent("false");
                        root.attachParameter(pingUdpParameter);
                        logger.info("parametro pingUDP criado com sucesso");
                        confCTFClient.setPingUDP(false);
                        logger.info("parametro pingUDP = false");
                        novoParametro = true;
                    }
                    ParameterSet multiec = null;
                    try {
                        multiec = root.getParameterSet("multiec");
                    }
                    catch (Exception e) {
                        logger.warn("parameterSet multiec inexistente.");
                    }
                    if (multiec != null) {
                        try {
                            Parameter multiECParameter = multiec.getParameter("habilitado");
                            confCTFClient.setMultiEC(Boolean.valueOf(multiECParameter.getContent()));
                            logger.info("parametro multiec.habilitado = '" + multiECParameter.getContent() + "'");
                        }
                        catch (Exception e) {
                            logger.info("parametro multiec = 'false'");
                            confCTFClient.setMultiEC(false);
                        }
                        try {
                            Parameter codigoGrupoParameter = multiec.getParameter("codigoGrupo");
                            Integer codigoGrupo = Integer.valueOf(codigoGrupoParameter.getContent().trim());
                            confCTFClient.setCodigoGrupoMultiEC(codigoGrupo);
                            logger.info("parametro multiec.codigoGrupo = '" + codigoGrupo + "'");
                        }
                        catch (Exception e) {
                            if (confCTFClient.isMultiEC()) {
                                logger.error("Multi-EC habilitado e codigoGrupo nulo");
                                throw new ExcecaoApiAc("valor de parametro invalido");
                            }
                            logger.info("parametro multiec.codigoGrupo = null");
                            confCTFClient.setCodigoGrupoMultiEC(null);
                        }
                    } else {
                        logger.info("parametro multiec = 'false'");
                        confCTFClient.setMultiEC(false);
                        logger.info("parametro multiec.codigoGrupo = null");
                        confCTFClient.setCodigoGrupoMultiEC(null);
                    }
                    try {
                        ParameterSet traceApiwebctf = root.getParameterSet("traceApiwebctf");
                        if (traceApiwebctf != null) {
                            ConfTraceApiwebctf confTraceApiwebctf = new ConfTraceApiwebctf();
                            Parameter habilidato = traceApiwebctf.getParameter("habilitado");
                            if (habilidato != null && !habilidato.getContent().trim().equals("")) {
                                confTraceApiwebctf.setHabilitado(Boolean.valueOf(habilidato.getContent()));
                                logger.log("INFO", "parametro traceApiwebctf:habilitado = " + habilidato.getContent());
                            } else {
                                confTraceApiwebctf.setHabilitado(false);
                                logger.log("WARN", "valor default aplicado para parametro de ativacao do traceApiwebctf. valor default ==> false");
                            }
                            Parameter qtdDias = traceApiwebctf.getParameter("qtdDias");
                            if (qtdDias != null && !qtdDias.getContent().trim().equals("")) {
                                confTraceApiwebctf.setQtdDias(Integer.parseInt(qtdDias.getContent()));
                                logger.log("INFO", "parametro traceApiwebctf:qtdDias = '" + qtdDias.getContent() + "'");
                            } else {
                                confTraceApiwebctf.setQtdDias(0);
                                logger.log("WARN", "valor default aplicado para parametro qtdDias do traceApiwebctf. valor default ==> 0");
                            }
                            confCTFClient.setConfTraceApiwebctf(confTraceApiwebctf);
                        }
                    }
                    catch (Exception e) {
                        logger.log("WARN", "parametro 'traceApiwebctf' n\u00e3o encontrado. valor default aplicado.");
                        ParameterSet traceApiwebctfSet = new ParameterSet("traceApiwebctf");
                        ConfTraceApiwebctf confTraceApiwebctf = new ConfTraceApiwebctf();
                        confTraceApiwebctf.setHabilitado(false);
                        confTraceApiwebctf.setQtdDias(0);
                        confCTFClient.setConfTraceApiwebctf(confTraceApiwebctf);
                        root.attachParameterSet(traceApiwebctfSet);
                        Parameter habilitadoParameter = new Parameter("habilitado");
                        habilitadoParameter.setContent("false");
                        traceApiwebctfSet.attachParameter(habilitadoParameter);
                        Parameter qtdDiasParameter = new Parameter("qtdDias");
                        qtdDiasParameter.setContent("0");
                        traceApiwebctfSet.attachParameter(qtdDiasParameter);
                        logger.info("parametro traceApiwebctf criado com sucesso");
                        logger.log("INFO", "parametro traceApiwebctf:habilitado = false");
                        logger.log("INFO", "parametro traceApiwebctf:qtdDias = '0'");
                        novoParametro = true;
                    }
                    ParameterSet timeoutPin = root.getParameterSet("timeoutPin");
                    if (timeoutPin == null) {
                        logger.log("ERROR", "timeout do pin invalido ==> timeoutPin");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    ConfTimeoutPin confTimeoutPin = new ConfTimeoutPin();
                    value = timeoutPin.getParameter("default").getContent();
                    if (value == null || value.trim().equals("")) {
                        confTimeoutPin.setTimeoutDefault(0);
                        logger.log("INFO", "parametro timeoutPin:default = 0");
                    } else {
                        confTimeoutPin.setTimeoutDefault(Integer.parseInt(value));
                        logger.log("INFO", "parametro timeoutPin:default = '" + value + "'");
                    }
                    value = timeoutPin.getParameter("blocking").getContent();
                    if (value == null || value.trim().equals("")) {
                        confTimeoutPin.setTimeoutBlocking(0);
                        logger.log("INFO", "parametro timeoutPin:blocking = '0'");
                    } else {
                        confTimeoutPin.setTimeoutBlocking(Integer.parseInt(value));
                        logger.log("INFO", "parametro timeoutPin:blocking = '" + value + "'");
                    }
                    value = timeoutPin.getParameter("noblocking").getContent();
                    if (value == null || value.trim().equals("")) {
                        confTimeoutPin.setTimeoutNoblocking(0);
                        logger.log("INFO", "parametro timeoutPin:noblocking = '0'");
                    } else {
                        confTimeoutPin.setTimeoutNoblocking(Integer.parseInt(value));
                        logger.log("INFO", "parametro timeoutPin:noblocking = '" + value + "'");
                    }
                    confCTFClient.setTimeoutPin(confTimeoutPin);
                    try {
                        String ip;
                        ParameterSet fusion = root.getParameterSet("fusion");
                        if (fusion == null) {
                            logger.log("ERROR", "configura\u00e7\u00e3o do fusion invalida ==> fusion");
                            break block221;
                        }
                        value = fusion.getParameter("ip").getContent();
                        if (value == null || value.trim().equals("")) {
                            ip = "";
                            logger.log("INFO", "parametro fusion:ip = ''");
                        } else {
                            ip = value;
                            logger.log("INFO", "parametro fusion:ip = '" + value + "'");
                        }
                        confCTFClient.setIpFusion(ip);
                        int porta = 0;
                        value = fusion.getParameter("porta").getContent();
                        if (value == null || value.trim().equals("")) {
                            porta = 0;
                            logger.log("INFO", "parametro fusion:porta = ''");
                        } else {
                            try {
                                porta = Integer.parseInt(value.trim());
                            }
                            catch (NumberFormatException e) {
                                logger.log("INFO", "parametro fusion:porta = '" + value + "'");
                            }
                            logger.log("INFO", "parametro fusion:ip = '" + value + "'");
                        }
                        confCTFClient.setPortaFusion(porta);
                    }
                    catch (Exception e) {
                        logger.log("INFO", "parametro 'fusion' nao configurado.");
                    }
                }
                try {
                    ParameterSet postef = root.getParameterSet("postef");
                    if (postef == null) {
                        logger.log("WARN", "parametro postef nao configurado");
                        break block222;
                    }
                    ConfPOSTef confPOSTef = new ConfPOSTef();
                    value = postef.getParameter("habilitado").getContent();
                    if (value == null || value.trim().equals("")) {
                        logger.log("INFO", "parametro postef:habilitado = 'false'");
                    } else {
                        confPOSTef.setHabilitado(Boolean.valueOf(value));
                        logger.log("INFO", "parametro postef:habilitado = '" + value + "'");
                    }
                    int porta = 0;
                    value = postef.getParameter("porta").getContent();
                    if (value == null || value.trim().equals("")) {
                        porta = 0;
                        logger.log("INFO", "parametro postef:porta = ''");
                    } else {
                        try {
                            porta = Integer.parseInt(value.trim());
                        }
                        catch (NumberFormatException e) {
                            logger.log("INFO", "parametro postef:porta = '" + value + "'");
                        }
                        logger.log("INFO", "parametro postef:porta = '" + value + "'");
                        confPOSTef.setPorta(porta);
                    }
                    value = postef.getParameter("posMovel").getContent();
                    if (value == null || value.trim().equals("")) {
                        logger.log("INFO", "parametro postef:posMovel = 'null'");
                    } else {
                        confPOSTef.setTerminalPosMovel(value);
                        logger.log("INFO", "parametro postef:posMovel = '" + value + "'");
                    }
                    confCTFClient.setConfPOSTef(confPOSTef);
                }
                catch (Exception e) {
                    logger.log("WARN", "parametro 'postef' nao configurado.");
                    ParameterSet posTefSet = new ParameterSet("postef");
                    Parameter habilitado = new Parameter("habilitado");
                    habilitado.setContent("false");
                    posTefSet.attachParameter(habilitado);
                    Parameter posMovel = new Parameter("posMovel");
                    posMovel.setContent("");
                    posTefSet.attachParameter(posMovel);
                    Parameter porta = new Parameter("porta");
                    porta.setContent("");
                    posTefSet.attachParameter(porta);
                    root.attachParameterSet(posTefSet);
                    novoParametro = true;
                    logger.log("INFO", "parametro 'postef' inicializado com valores defautl.");
                }
            }
            try {
                ParameterSet clienteServico = root.getParameterSet("clienteServico");
                if (clienteServico == null) {
                    logger.log("WARN", "parametro clienteServico nao configurado");
                } else {
                    ConfClienteServico confClientServico = new ConfClienteServico();
                    value = clienteServico.getParameter("habilitado").getContent();
                    if (value == null || value.trim().equals("")) {
                        logger.log("INFO", "parametro clienteServico:habilitado = 'false'");
                    } else {
                        confClientServico.setHabilitado(Boolean.valueOf(value));
                        logger.log("INFO", "parametro clienteServico:habilitado = '" + value + "'");
                    }
                    if (this.isConfigurado(clienteServico, "host")) {
                        value = clienteServico.getParameter("host").getContent();
                        if (value == null || value.trim().equals("")) {
                            logger.log("INFO", "parametro clienteServico:host = 'null'");
                        } else {
                            confClientServico.setHost(value);
                            logger.log("INFO", "parametro clienteServico:host = '" + value + "'");
                        }
                    }
                    if ((value = clienteServico.getParameter("codigoPdv").getContent()) == null || value.trim().equals("")) {
                        logger.log("INFO", "parametro clienteServico:codigoPdv = 'null'");
                    } else {
                        confClientServico.setCodigoPdv(value);
                        logger.log("INFO", "parametro clienteServico:codigoPdv = '" + value + "'");
                    }
                    confCTFClient.setConfClienteServico(confClientServico);
                }
            }
            catch (Exception e) {
                logger.log("INFO", "parametro 'clienteServico' nao configurado.");
                ParameterSet clienteServicoSet = new ParameterSet("clienteServico");
                Parameter habilitado = new Parameter("habilitado");
                habilitado.setContent("false");
                clienteServicoSet.attachParameter(habilitado);
                Parameter codigoPdv = new Parameter("codigoPdv");
                codigoPdv.setContent("");
                clienteServicoSet.attachParameter(codigoPdv);
                root.attachParameterSet(clienteServicoSet);
                novoParametro = true;
                logger.log("INFO", "parametro 'clienteServico' inicializado com valores defautl.");
            }
            value = root.getParameter("capturaApenasLinhaDigitavel").getContent();
            if (value == null || value.equals("")) {
                logger.log("ERROR", "valor de parametro invalido ==> capturaApenasLinhaDigitavel");
                throw new ExcecaoApiAc("valor de parametro invalido");
            }
            confCTFClient.setCapturaApenasLinhaDigitavel(Boolean.valueOf(value));
            logger.log("INFO", "parametro capturaApenasLinhaDigitavel = " + value);
            try {
                value = root.getParameter("capturaEncargosCCB").getContent();
                if (value == null || value.equals("")) {
                    logger.log("WARN", "valor de parametro invalido ==> capturaEncargosCCB. default = false");
                    confCTFClient.setCapturaEncargosCCB(false);
                } else {
                    confCTFClient.setCapturaEncargosCCB(Boolean.valueOf(value));
                }
            }
            catch (NoSuchParameterException e) {
                logger.log("WARN", "parametro nao encontrado ==> capturaEncargosCCB. default = false");
                confCTFClient.setCapturaEncargosCCB(false);
            }
            ParameterSet web = root.getParameterSet("web");
            if (web != null) {
                value = web.getParameter("multitransacao").getContent();
                if (value == null || value.equals("")) {
                    logger.log("ERROR", "valor de parametro invalido ==> multitransacao");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                confCTFClient.setMultitransacaoWeb(Boolean.valueOf(value));
                logger.log("INFO", "parametro web:multitransacao = " + value);
                value = web.getParameter("controleTerminais").getContent();
                if (value == null || value.equals("")) {
                    logger.log("ERROR", "valor de parametro invalido ==> controleTerminais");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                confCTFClient.setControleTerminais(Boolean.valueOf(value));
                logger.log("INFO", "parametro web:controleTerminais = " + value);
                value = web.getParameter("filaTerminais").getContent();
                if (value == null || value.equals("")) {
                    logger.log("WARN", "parametro de filaTerminais nao encontrado. valor default = 0:0");
                    confCTFClient.setFilaTerminais("0:0");
                } else {
                    confCTFClient.setFilaTerminais(value);
                    logger.log("INFO", "parametro web:filaTerminais = '" + value + "'");
                }
            }
            if ((timeOut = root.getParameterSet("timeout")) != null) {
                value = timeOut.getParameter("intertef").getContent();
                if (value == null || value.equals("") || Integer.parseInt(value) == 0) {
                    logger.log("ERROR", "valor do timeout intertef inv\u00e1lido ==> timeout intertef");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                confCTFClient.setTimeOutDefault(Integer.parseInt(value));
                logger.log("INFO", "parametro timeout:intertef = '" + value + "'");
                try {
                    value = timeOut.getParameter("confirmacaoMultiTerminal").getContent();
                    if (value == null || value.equals("") || Integer.parseInt(value) == 0) {
                        logger.log("ERROR", "valor do timeout confirmacaoMultiTerminal inv\u00e1lido.");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    confCTFClient.setTimeOutConfirmacao(Integer.parseInt(value));
                    logger.log("INFO", "parametro timeout:confirmacaoMultiTerminal = '" + value + "'");
                }
                catch (Exception e) {
                    logger.warn("parametro confirmacaoMultiTerminal n\u00e3o encontrado.");
                }
            }
            if ((creditoDigital = root.getParameterSet("creditodigital")) != null) {
                try {
                    value = creditoDigital.getParameter("capturaTelefonePinpad").getContent();
                }
                catch (NoSuchParameterException e) {
                    value = null;
                }
                if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    logger.log("ERROR", "valor de parametro invalido ==> capturaTelefonePinpad, utilizando default: true");
                    confCTFClient.setCapturaTelefonePinpad(true);
                } else {
                    confCTFClient.setCapturaTelefonePinpad(Boolean.valueOf(value));
                    logger.log("INFO", "parametro creditodigital:capturaTelefonePinpad = " + value);
                }
                value = creditoDigital.getParameter("capturaTelefoneDoisDisplay").getContent();
                if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    logger.log("ERROR", "valor de parametro invalido ==> capturaTelefoneDoisDisplay");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                confCTFClient.setCapturaTelefoneDoisDisplay(Boolean.valueOf(value));
                logger.log("INFO", "parametro creditodigital:capturaTelefoneDoisDisplay = " + value);
                value = null;
                try {
                    value = creditoDigital.getParameter("capturaTelefoneDuplaCaptura").getContent();
                }
                catch (Exception e) {
                    logger.log("INFO", "parametro 'capturaTelefoneDuplaCaptura' nao configurado.");
                }
                if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    logger.log("WARN", "valor de parametro invalido ==> capturaTelefoneDuplaCaptura, utilizando default: true");
                    confCTFClient.setCapturaTelefoneDuplaCaptura(true);
                } else {
                    confCTFClient.setCapturaTelefoneDuplaCaptura(Boolean.valueOf(value));
                    logger.log("INFO", "parametro creditodigital:capturaTelefoneDuplaCaptura = " + value);
                }
                value = creditoDigital.getParameter("confirmaDddTelefone").getContent();
                if (value == null || value.equals("") || !value.equals("true") && !value.equals("false")) {
                    logger.log("ERROR", "valor de parametro invalido ==> confirmaDddTelefone");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                confCTFClient.setConfirmaDddTelefone(Boolean.valueOf(value));
                logger.log("INFO", "parametro creditodigital:confirmaDddTelefone = " + value);
                try {
                    value = creditoDigital.getParameter("versaolayout").getContent();
                    confCTFClient.setVersaoLayoutCD(Integer.parseInt(value));
                    logger.log("INFO", "parametro creditodigital:versaolayout = " + value);
                }
                catch (Exception e) {
                    confCTFClient.setVersaoLayoutCD(1);
                }
                try {
                    value = creditoDigital.getParameter("permiteValoresVariaveis").getContent();
                }
                catch (NoSuchParameterException e) {
                    value = null;
                }
                if (value == null || value.equals("") || !value.equals("true") && !value.equals("false")) {
                    logger.log("WARN", "valor de parametro invalido ==> creditodigital:permiteValoresVariaveis, utilizando default: true");
                    confCTFClient.setPermiteValoresVariaveis(true);
                } else {
                    confCTFClient.setPermiteValoresVariaveis(Boolean.valueOf(value));
                    logger.log("INFO", "parametro creditodigital:permiteValoresVariaveis = " + value);
                }
            }
            if ((ipsParameter = root.getParameterSet("ips")) != null && ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                ips = new LinkedHashSet<ServicoCTF>();
                List listaIp = ipsParameter.getAllParameterSets();
                for (ParameterSet ip : listaIp) {
                    ServicoCTF servico;
                    String hostValue = ip.getParameter("host").getContent();
                    logger.log("INFO", "parametro ips:ip:host = '" + hostValue + "'");
                    if (hostValue == null || hostValue.trim().length() == 0) {
                        logger.warn("host invalido.");
                        continue;
                    }
                    String identificador = ip.getParameter("port").getContent();
                    logger.log("INFO", "parametro ips:ip:port = '" + identificador + "'");
                    if (identificador == null || identificador.equals("")) {
                        logger.log("WARN", "valor de parametro n\u00e3o definido ==> ips = port");
                    }
                    String protocolo = ip.getParameter("protocolo").getContent();
                    logger.log("INFO", "parametro ips:ip:protocolo = '" + protocolo + "'");
                    if (protocolo == null || protocolo.equals("")) {
                        logger.log("WARN", "valor de parametro nao definido ==> ips = protocolo");
                    }
                    Host host = new Host(hostValue);
                    try {
                        servico = new ServicoCTF(host, identificador, protocolo);
                    }
                    catch (ExcecaoParametroInvalido e) {
                        logger.log("ERROR", "valor de parametro invalido ==> ips = protocolo, usar TCP, UDP ou UDP2");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    ips.add(servico);
                }
            } else {
                logger.log("ERROR", "lista de ips n\u00e3o configurada ==> ips");
                throw new ExcecaoApiAc("valor de parametro invalido");
            }
            confCTFClient.setIps(ips);
            try {
                ParameterSet contingenciaConexao = root.getParameterSet("contingenciaConexao");
                ConfContingenciaConexao confContingenciaConexao = new ConfContingenciaConexao();
                boolean configurar = false;
                if (this.isConfigurado(contingenciaConexao, "maximoConexao")) {
                    Parameter maximoConexao = contingenciaConexao.getParameter("maximoConexao");
                    confContingenciaConexao.setMaximoConexao(Integer.parseInt(maximoConexao.getContent()));
                    logger.log("INFO", "parametro contingenciaConexao:maximoConexao = " + confContingenciaConexao.getMaximoConexao());
                    configurar = true;
                }
                if (this.isConfigurado(contingenciaConexao, "tempoConexao")) {
                    Parameter tempoConexao = contingenciaConexao.getParameter("tempoConexao");
                    confContingenciaConexao.setTempoMaximoConexao(Integer.parseInt(tempoConexao.getContent()));
                    logger.log("INFO", "parametro contingenciaConexao:tempoConexao = " + confContingenciaConexao.getTempoMaximoConexao());
                    configurar = true;
                }
                if (this.isConfigurado(contingenciaConexao, "resetConexao")) {
                    Parameter resetConexao = contingenciaConexao.getParameter("resetConexao");
                    confContingenciaConexao.setResetConexao(Integer.parseInt(resetConexao.getContent()));
                    logger.log("INFO", "parametro contingenciaConexao:resetConexao = " + confContingenciaConexao.getResetConexao());
                    configurar = true;
                }
                if (configurar) {
                    confCTFClient.setConfContingenciaConexao(confContingenciaConexao);
                }
            }
            catch (Exception e) {
                logger.warn("parametro contingenciaConexao nao configurado. utilizar default");
                confCTFClient.setConfContingenciaConexao(null);
            }
            ParameterSet perifericos = root.getParameterSet("perifericos");
            if (perifericos != null) {
                block223: {
                    try {
                        Parameter mapaTeclado = perifericos.getParameter("mapaTeclado");
                        if (mapaTeclado.getContent() != null && !mapaTeclado.getContent().equals("")) {
                            confCTFClient.setMapaTeclado(mapaTeclado.getContent());
                            logger.log("INFO", "parametro perifericos:mapaTeclado = " + mapaTeclado.getContent());
                        } else {
                            confCTFClient.setMapaTeclado(null);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("parametro mapaTeclado n\u00e3o encontrado");
                        confCTFClient.setMapaTeclado(null);
                    }
                    ParameterSet perifericoTeclado = perifericos.getParameterSet("DRIVER_TECLADO");
                    ConfPeriferico teclado = null;
                    value = perifericoTeclado.getParameter("tipo").getContent();
                    logger.log("INFO", "parametro perifericos:DRIVER_TECLADO = " + value);
                    if ("TECLADO_PC".equalsIgnoreCase(value)) {
                        teclado = new ConfPeriferico("TECLADO_PC");
                        teclado.setNomeClasse("com.csi.ctfclient.tools.devices.generic.TecladoPC");
                    } else if ("TECLADO_JAVAPOS".equalsIgnoreCase(value)) {
                        teclado = new ConfPeriferico("TECLADO_JAVAPOS");
                        teclado.setNomeClasse("com.csi.ctfclient.tools.devices.javapos.TecladoJavaPOS");
                    } else if ("TECLADO_TOUCH_LINX".equalsIgnoreCase(value)) {
                        teclado = new ConfPeriferico("TECLADO_TOUCH_LINX");
                        teclado.setNomeClasse("br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouchLinx");
                    } else if ("TECLADO_TOUCH".equalsIgnoreCase(value)) {
                        teclado = new ConfPeriferico("TECLADO_TOUCH");
                        teclado.setNomeClasse("br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouch");
                    } else {
                        logger.log("ERROR", "valor de parametro invalido ==> periferico - teclado");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    value = perifericoTeclado.getParameter("params").getContent();
                    logger.log("INFO", "parametro perifericos:DRIVER_TECLADO:params = '" + value + "'");
                    if (value != null && value.trim().length() > 0) {
                        teclado.setParametros(value.split(","));
                    }
                    confCTFClient.setTeclado(teclado);
                    ParameterSet perifericoDisplayOperador = perifericos.getParameterSet("DRIVER_DISPLAY_OPERADOR");
                    value = perifericoDisplayOperador.getParameter("tipo").getContent();
                    ConfPeriferico displayOperador = null;
                    if ("DISPLAY_OPERADOR".equalsIgnoreCase(value)) {
                        displayOperador = new ConfPeriferico("DISPLAY_OPERADOR");
                        displayOperador.setNomeClasse("com.csi.ctfclient.tools.devices.generic.JPanelDisplay");
                    } else if ("DISPLAY_AUTTAR".equalsIgnoreCase(value)) {
                        displayOperador = new ConfPeriferico("DISPLAY_AUTTAR");
                        displayOperador.setNomeClasse("com.csi.ctfclient.tools.devices.generic.DisplayFisicoAuttar");
                    }
                    if (value != null && !value.trim().equals("")) {
                        displayOperador.setNomeClasse(displayOperador.getNomeClasse());
                        value = perifericoDisplayOperador.getParameter("params").getContent();
                        if (value != null && value.length() > 0) {
                            displayOperador.setParametros(value.split(","));
                        }
                        confCTFClient.setDisplayOperador(displayOperador);
                    } else {
                        confCTFClient.setDisplayOperador(null);
                    }
                    ParameterSet perifericoScanner = perifericos.getParameterSet("DRIVER_SCANNER");
                    value = perifericoScanner.getParameter("tipo").getContent();
                    logger.log("INFO", "parametro perifericos:DRIVER_SCANNER = " + value);
                    ConfPeriferico scanner = null;
                    if ("SCANNER_SERIAL".equalsIgnoreCase(value)) {
                        scanner = new ConfPeriferico("SCANNER_SERIAL");
                        scanner.setNomeClasse("com.csi.ctfclient.tools.devices.generic.ScannerSerial");
                    } else if ("SCANNER_JAVAPOS".equalsIgnoreCase(value)) {
                        scanner = new ConfPeriferico("SCANNER_JAVAPOS");
                        scanner.setNomeClasse("com.csi.ctfclient.tools.devices.javapos.ScannerJavaPOS");
                    }
                    if (value != null && !value.trim().equals("")) {
                        value = perifericoScanner.getParameter("params").getContent();
                        logger.log("INFO", "parametro perifericos:DRIVER_SCANNER:params = '" + value + "'");
                        if (value != null && value.length() > 0) {
                            scanner.setParametros(value.split(","));
                        }
                        confCTFClient.setScanner(scanner);
                    } else {
                        confCTFClient.setScanner(null);
                    }
                    ParameterSet perifericoLeitorDocumento = perifericos.getParameterSet("DRIVER_LEITOR_DOCUMENTO");
                    value = perifericoLeitorDocumento.getParameter("tipo").getContent();
                    logger.log("INFO", "parametro perifericos:DRIVER_LEITOR_DOCUMENTO = " + value);
                    ConfPeriferico leitorDocumento = null;
                    if ("LEITOR_DOCUMENTO_CHRONOS".equalsIgnoreCase(value)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_CHRONOS");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.chronos.LeitorDocumentoChronos");
                    } else if ("LEITOR_DOCUMENTO_LOGGER2".equalsIgnoreCase(value)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_CHRONOS");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.urano.LeitorDocumentoUranoLogger2");
                    } else if ("LEITOR_DOCUMENTO_TECPOINTTL840".equalsIgnoreCase(value)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_TECPOINTTL840");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.tecpoint.LeitorDocumentoTecpointTL840");
                    }
                    if (value != null && !value.trim().equals("")) {
                        value = perifericoLeitorDocumento.getParameter("params").getContent();
                        logger.log("INFO", "parametro perifericos:DRIVER_LEITOR_DOCUMENTO:params = '" + value + "'");
                        if (value != null && value.length() > 0) {
                            confCTFClient.setPrefixoLeitorDocumento(value.trim());
                            leitorDocumento.setParametros(value.split(","));
                        }
                        confCTFClient.setLeitorDocumento(leitorDocumento);
                    } else {
                        confCTFClient.setLeitorDocumento(null);
                    }
                    boolean carregaPinpad = false;
                    try {
                        ParameterSet configPinpad = perifericos.getParameterSet("CONFIG_PINPAD");
                        Parameter portaSerialParameter = configPinpad.getParameter("portaSerial");
                        carregaPinpad = !portaSerialParameter.getContent().trim().equals("");
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:portaSerial = '" + portaSerialParameter.getContent() + "'");
                        if (!carregaPinpad) break block223;
                        HashMap<String, String> parametrosPinpad = new HashMap<String, String>();
                        parametrosPinpad.put("portaSerial", portaSerialParameter.getContent());
                        parametrosPinpad.put("msgPrompt", configPinpad.getParameter("msgPrompt").getContent());
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgPrompt = '" + configPinpad.getParameter("msgPrompt").getContent() + "'");
                        parametrosPinpad.put("msgCartao", configPinpad.getParameter("msgCartao").getContent());
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgCartao = '" + configPinpad.getParameter("msgCartao").getContent() + "'");
                        parametrosPinpad.put("msgSenha", configPinpad.getParameter("msgSenha").getContent());
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgSenha = '" + configPinpad.getParameter("msgSenha").getContent() + "'");
                        parametrosPinpad.put("msgAguardo", configPinpad.getParameter("msgAguardo").getContent());
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgAguardo = '" + configPinpad.getParameter("msgAguardo").getContent() + "'");
                        try {
                            Parameter tentativaPinpd = configPinpad.getParameter("tentativasConexao");
                            if (tentativaPinpd.getContent() != null && !tentativaPinpd.getContent().equals("")) {
                                confCTFClient.setTentativasConexaoPinpad(Integer.parseInt(tentativaPinpd.getContent()));
                                logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:tentativasConexao = '" + confCTFClient.getTentativasConexaoPinpad() + "'");
                            }
                        }
                        catch (Exception e) {
                            confCTFClient.setTentativasConexaoPinpad(3);
                            Parameter tentativaPinpd = new Parameter("tentativasConexao");
                            tentativaPinpd.setContent(confCTFClient.getTentativasConexaoPinpad() + "");
                            configPinpad.attachParameter(tentativaPinpd);
                            novoParametro = true;
                            logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:tentativasConexao = '" + confCTFClient.getTentativasConexaoPinpad() + "'");
                        }
                        ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
                        String[] listaParametrosCartao = new String[]{(String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgCartao"), (String)parametrosPinpad.get("msgPrompt")};
                        configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
                        configLeitorCartao.setParametros(listaParametrosCartao);
                        confCTFClient.setLeitorCartao(configLeitorCartao);
                        ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
                        String[] listaParametrosPin = new String[]{(String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgPrompt"), (String)parametrosPinpad.get("msgSenha"), (String)parametrosPinpad.get("msgAguardo")};
                        configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
                        configPinPad.setParametros(listaParametrosPin);
                        confCTFClient.setPin(configPinPad);
                    }
                    catch (Exception e) {
                        logger.warn("parametro 'CONFIG_PINPAD' n\u00e3o encontrado.");
                        ParameterSet leitorCartaoParameter = perifericos.getParameterSet("PARAMS_LEITOR_CARTAO");
                        HashMap<String, String> parametrosPinpad = new HashMap<String, String>();
                        parametrosPinpad.put("portaSerial", leitorCartaoParameter.getParameter("portaSerial").getContent());
                        parametrosPinpad.put("msgCartao", leitorCartaoParameter.getParameter("msgCartao").getContent());
                        ParameterSet pinPadParameter = perifericos.getParameterSet("PARAMS_PINPAD");
                        parametrosPinpad.put("msgPrompt", pinPadParameter.getParameter("msgPrompt").getContent());
                        parametrosPinpad.put("msgSenha", pinPadParameter.getParameter("msgSenha").getContent());
                        parametrosPinpad.put("msgAguardo", pinPadParameter.getParameter("msgAguardo").getContent());
                        ParameterSet configPinpad = new ParameterSet("CONFIG_PINPAD");
                        Parameter portaSerialParameter = new Parameter("portaSerial");
                        portaSerialParameter.setContent((String)parametrosPinpad.get("portaSerial"));
                        configPinpad.attachParameter(portaSerialParameter);
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:portaSerial = '" + parametrosPinpad.get("portaSerial") + "'");
                        Parameter msgPromptParameter = new Parameter("msgPrompt");
                        msgPromptParameter.setContent((String)parametrosPinpad.get("msgPrompt"));
                        configPinpad.attachParameter(msgPromptParameter);
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgPrompt = " + parametrosPinpad.get("msgPrompt") + "'");
                        Parameter msgCartaoParameter = new Parameter("msgCartao");
                        msgCartaoParameter.setContent((String)parametrosPinpad.get("msgCartao"));
                        configPinpad.attachParameter(msgCartaoParameter);
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgCartao = " + parametrosPinpad.get("msgCartao") + "'");
                        Parameter msgSenhaParameter = new Parameter("msgSenha");
                        msgSenhaParameter.setContent((String)parametrosPinpad.get("msgSenha"));
                        configPinpad.attachParameter(msgSenhaParameter);
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgSenha = " + parametrosPinpad.get("msgSenha") + "'");
                        Parameter msgAguardoParameter = new Parameter("msgAguardo");
                        msgAguardoParameter.setContent((String)parametrosPinpad.get("msgAguardo"));
                        configPinpad.attachParameter(msgAguardoParameter);
                        logger.log("INFO", "parametro perifericos:CONFIG_PINPAD:msgAguardo = " + parametrosPinpad.get("msgAguardo") + "'");
                        perifericos.attachParameterSet(configPinpad);
                        logger.info("parametro 'CONFIG_PINPAD' criado com sucesso.");
                        leitorCartaoParameter.detach();
                        logger.info("parametro 'PARAMS_LEITOR_CARTAO' removido.");
                        pinPadParameter.detach();
                        logger.info("parametro 'PARAMS_PINPAD' removido.");
                        ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
                        String[] listaParametrosCartao = new String[]{(String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgCartao"), (String)parametrosPinpad.get("msgPrompt")};
                        configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
                        configLeitorCartao.setParametros(listaParametrosCartao);
                        confCTFClient.setLeitorCartao(configLeitorCartao);
                        ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
                        String[] listaParametrosPin = new String[]{(String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgPrompt"), (String)parametrosPinpad.get("msgSenha"), (String)parametrosPinpad.get("msgAguardo")};
                        configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
                        configPinPad.setParametros(listaParametrosPin);
                        confCTFClient.setPin(configPinPad);
                        novoParametro = true;
                    }
                }
                try {
                    value = root.getParameter("confirmadadoscancelamento").getContent();
                    if (value == null || value.equals("")) {
                        confCTFClient.setConfirmaCancelamento(true);
                    } else {
                        confCTFClient.setConfirmaCancelamento(Boolean.valueOf(value));
                        logger.log("INFO", "parametro 'confirmadadoscancelamento' = '" + value + "'");
                    }
                }
                catch (NoSuchParameterException e) {
                    confCTFClient.setConfirmaCancelamento(true);
                }
                try {
                    value = root.getParameter("envioCupomIntegracao").getContent();
                }
                catch (NoSuchParameterException e) {
                    Parameter envioCupomIntegracao = new Parameter("envioCupomIntegracao");
                    root.attachParameter(envioCupomIntegracao);
                    envioCupomIntegracao.setContent("false");
                    novoParametro = true;
                    value = null;
                }
                if (value == null || value.equals("") || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    logger.log("WARN", "valor de parametro invalido ==> envioCupomIntegracao, utilizando default: false");
                    confCTFClient.setEnvioCupomIntegracao(false);
                } else {
                    confCTFClient.setEnvioCupomIntegracao(Boolean.valueOf(value));
                    logger.log("INFO", "parametro envioCupomIntegracao = " + value);
                }
            }
            if (novoParametro) {
                config.save();
            }
            logger.log("INFO", "parametros do CTFClient inicializado com sucesso");
        }
        catch (SecurityException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc("error Parameter: " + e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (IOException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc("Erro ao ler o arquivo confCTFClient.xml");
        }
        this.setConfCTFClient(confCTFClient);
    }

    @Override
    public void resetDadosAutenticacao() {
        try {
            ParameterSet clienteServico;
            Config config = ControladorConfCTFClient.getDiretorioTrabalho() != null ? Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCTFClient.xml") : Config.getConfig("configCTFClient.xml");
            ParameterSet root = config.getParameterSet("configCTFClient");
            root.getParameter("estabelecimento").setContent(null);
            root.getParameter("loja").setContent(null);
            root.getParameter("terminal").setContent(null);
            if (this.isConfigurado(root, "clienteServico") && (clienteServico = root.getParameterSet("clienteServico")) != null) {
                clienteServico.getParameter("habilitado").setContent("false");
            }
            if (this.isConfigurado(root, "ips")) {
                ParameterSet ipsParameter = root.getParameterSet("ips");
                if (ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                    List listaIpParameter = ipsParameter.getAllParameterSets();
                    Iterator iter = listaIpParameter.iterator();
                    while (iter.hasNext()) {
                        ((ParameterSet)iter.next()).detach();
                    }
                }
                ParameterSet ipParameter = new ParameterSet("ip");
                Parameter hostParameter = new Parameter("host");
                hostParameter.setContent("");
                ipParameter.attachParameter(hostParameter);
                Parameter portParameter = new Parameter("port");
                portParameter.setContent("");
                ipParameter.attachParameter(portParameter);
                Parameter protocoloParameter = new Parameter("protocolo");
                protocoloParameter.setContent("");
                ipParameter.attachParameter(protocoloParameter);
                ipsParameter.attachParameterSet(ipParameter);
            }
            config.save();
            this.reader();
        }
        catch (Exception e) {
            logger.error("nao foi possivel resetar as configuracoes. " + e.getMessage(), e);
        }
    }

    @Override
    public void save(ConfCTFClient confCTFClient) throws ExcecaoApiAc {
        this.save(confCTFClient, !this.getConfCTFClient().isSuporteHttps());
    }

    @Override
    public void save(ConfCTFClient confCTFClient, boolean ignoreSuporteHttps) throws ExcecaoApiAc {
        try {
            ParameterSet perifericos;
            ParameterSet timeOut;
            Config config = ControladorConfCTFClient.getDiretorioTrabalho() != null ? Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCTFClient.xml") : Config.getConfig("configCTFClient.xml");
            ConfCTFClientCtrl confCTFClientCtrl = new ConfCTFClientCtrl();
            try {
                ReflectHelp.populate(confCTFClientCtrl, confCTFClient);
            }
            catch (IllegalAccessException e) {
                logger.log("INFO", "Erro ao carregar as configura\u00e7\u00f5es para estrutura interna...");
                throw new ExcecaoApiAc("Erro ao carregar as configura\u00e7\u00f5es para estrutura interna...");
            }
            ParameterSet root = config.getParameterSet("configCTFClient");
            if (confCTFClientCtrl.isEstabelecimentoCtrl() && confCTFClientCtrl.getEstabelecimento() != null && ignoreSuporteHttps) {
                if (this.validaEstabelecimento(confCTFClientCtrl.getEstabelecimento())) {
                    root.getParameter("estabelecimento").setContent(confCTFClientCtrl.getEstabelecimento());
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> estabelecimento");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isLojaCtrl() && confCTFClientCtrl.getLoja() != null && ignoreSuporteHttps) {
                if (this.validaLoja(confCTFClientCtrl.getLoja())) {
                    root.getParameter("loja").setContent(confCTFClientCtrl.getLoja());
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> loja");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isCnpjCtrl() && confCTFClientCtrl.getCnpj() != null) {
                Parameter cnpjParameter = null;
                try {
                    cnpjParameter = root.getParameter("cnpj");
                }
                catch (Exception e) {
                    cnpjParameter = new Parameter("cnpj");
                    root.attachParameter(cnpjParameter);
                }
                cnpjParameter.setContent(confCTFClientCtrl.getCnpj());
            }
            if (confCTFClientCtrl.isTerminalCtrl() && confCTFClientCtrl.getTerminal() != null && !confCTFClientCtrl.getTerminal().equals("") && ignoreSuporteHttps) {
                root.getParameter("terminal").setContent(confCTFClientCtrl.getTerminal());
            }
            if (confCTFClientCtrl.isNumeroSitesCtrl() && confCTFClientCtrl.getNumeroSites() != null) {
                if (this.validaNumeroSites(confCTFClientCtrl.getNumeroSites())) {
                    root.getParameter("numeroSite").setContent(String.valueOf(confCTFClientCtrl.getNumeroSites()));
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> numeroSites");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isQuantidadeViasCtrl() && confCTFClientCtrl.getQuantidadeVias() != null) {
                if (this.validaQuantidadeVias(confCTFClientCtrl.getQuantidadeVias())) {
                    root.getParameter("quantidadeVias").setContent(String.valueOf(confCTFClientCtrl.getQuantidadeVias()));
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> quantidadeVias");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isVersaoACCtrl() && confCTFClientCtrl.getVersaoAC() != null) {
                if (this.validaVersaoAC(confCTFClientCtrl.getVersaoAC())) {
                    root.getParameter("versaoAC").setContent(confCTFClientCtrl.getVersaoAC());
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> versaoAC");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isHostClientCtrl() && confCTFClientCtrl.getHostClient() != null) {
                root.getParameter("hostclient").setContent(confCTFClientCtrl.getHostClient());
            }
            if (confCTFClientCtrl.isPortClientCtrl() && confCTFClientCtrl.getPortClient() != null) {
                if (this.validaPort(confCTFClientCtrl.getPortClient())) {
                    root.getParameter("portclient").setContent(confCTFClientCtrl.getPortClient());
                } else {
                    logger.log("ERROR", "valor de parametro invalido ==> portclient");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isStandAloneCtrl()) {
                root.getParameter("standalone").setContent(String.valueOf(confCTFClientCtrl.isStandAlone()));
            }
            if (confCTFClientCtrl.isTipoIntegracaoCtrl()) {
                root.getParameter("tipointegracao").setContent(String.valueOf(confCTFClientCtrl.getTipoIntegracao()));
            }
            if (confCTFClientCtrl.isPermitePagarSaldoVoucherCtrl()) {
                root.getParameter("permitePagarSaldoVoucher").setContent(String.valueOf(confCTFClientCtrl.isPermitePagarSaldoVoucher()));
            }
            if (confCTFClientCtrl.isRotearPrivateLabelCtrl()) {
                root.getParameter("rotearPrivateLabel").setContent(String.valueOf(confCTFClientCtrl.isRotearPrivateLabel()));
            }
            if (confCTFClientCtrl.isCodigoTabelaCtrl()) {
                root.getParameter("codigoTabela").setContent(String.valueOf(confCTFClientCtrl.getCodigoTabela()));
            }
            if (confCTFClientCtrl.isIntegracaoCriptografadaCtrl()) {
                root.getParameter("integracaoCriptografada").setContent(String.valueOf(confCTFClientCtrl.isIntegracaoCriptografada()));
            }
            if (confCTFClientCtrl.isCapturaCmc7Ctrl()) {
                root.getParameter("capturacmc7").setContent(String.valueOf(confCTFClientCtrl.isCapturaCmc7()));
            }
            if (confCTFClientCtrl.isCreditoCelularHabilitadoCtrl()) {
                root.getParameter("creditoCelularHabilitado").setContent(String.valueOf(confCTFClientCtrl.isCreditoCelularHabilitado()));
            }
            if (confCTFClientCtrl.isPingUDPCtrl()) {
                root.getParameter("pingUDP").setContent(String.valueOf(confCTFClientCtrl.isPingUDP()));
            }
            if (confCTFClientCtrl.isTimeOutDefaultCtrl()) {
                timeOut = root.getParameterSet("timeout");
                if (confCTFClientCtrl.getTimeOutDefault() == 0) {
                    logger.log("ERROR", "valor do timeout intertef inv\u00e1lido");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                timeOut.getParameter("intertef").setContent(String.valueOf(confCTFClientCtrl.getTimeOutDefault()));
            }
            if (confCTFClientCtrl.isTimeOutConfirmacaoCtrl()) {
                timeOut = root.getParameterSet("timeout");
                if (confCTFClientCtrl.getTimeOutConfirmacao() == 0) {
                    logger.log("ERROR", "valor do timeout confirmacaoMultiTerminal inv\u00e1lido");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
                try {
                    timeOut.getParameter("confirmacaoMultiTerminal").setContent(String.valueOf(confCTFClientCtrl.getTimeOutConfirmacao()));
                }
                catch (Exception e) {
                    logger.warn("n\u00e3o foi poss\u00edvel atualizar o timeout confirmacaoMultiTerminal.");
                }
            }
            if (confCTFClientCtrl.isAcSuportaPlataformaPromocionalCtrl()) {
                root.getParameter("acSuportaPlataformaPromocional").setContent(String.valueOf(confCTFClientCtrl.isAcSuportaPlataformaPromocional()));
            }
            if (confCTFClientCtrl.isVersaoPathTerminalCtrl()) {
                Parameter versaoPathTerminalParameter = null;
                try {
                    versaoPathTerminalParameter = root.getParameter("versaoPathTerminal");
                }
                catch (Exception e) {
                    versaoPathTerminalParameter = new Parameter("versaoPathTerminal");
                    root.attachParameter(versaoPathTerminalParameter);
                }
                versaoPathTerminalParameter.setContent(confCTFClientCtrl.getVersaoPathTerminal() + "");
            }
            try {
                if (confCTFClientCtrl.isConfPOSTefCtrl()) {
                    ConfPOSTef confPOSTef = confCTFClientCtrl.getConfPOSTef();
                    ParameterSet postef = root.getParameterSet("postef");
                    if (postef != null) {
                        postef.getParameter("habilitado").setContent(String.valueOf(confPOSTef.isHabilitado()));
                        postef.getParameter("posMovel").setContent(confPOSTef.getTerminalPosMovel());
                    }
                }
            }
            catch (Exception e) {
                logger.log("ERROR", "parametro 'postef' nao configurado.");
            }
            try {
                if (confCTFClientCtrl.isConfClienteServicoCtrl()) {
                    ConfClienteServico confClienteServico = confCTFClientCtrl.getConfClienteServico();
                    ParameterSet clienteServico = root.getParameterSet("clienteServico");
                    if (clienteServico != null) {
                        clienteServico.getParameter("habilitado").setContent(String.valueOf(confClienteServico.isHabilitado()));
                        clienteServico.getParameter("codigoPdv").setContent(confClienteServico.getCodigoPdv());
                    }
                }
            }
            catch (Exception e) {
                logger.log("ERROR", "parametro 'clienteServico' nao configurado.");
            }
            if (confCTFClientCtrl.isIpsCtrl() && ignoreSuporteHttps) {
                if (confCTFClientCtrl.getIps() != null && confCTFClientCtrl.getIps().size() > 0) {
                    ParameterSet ipsParameter = root.getParameterSet("ips");
                    if (ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                        List listaIpParameter = ipsParameter.getAllParameterSets();
                        Iterator iter = listaIpParameter.iterator();
                        while (iter.hasNext()) {
                            ((ParameterSet)iter.next()).detach();
                        }
                    }
                    LinkedHashSet<ServicoCTF> ipsServicoCTF = new LinkedHashSet<ServicoCTF>();
                    for (Servico endTemp : confCTFClientCtrl.getIps()) {
                        ServicoCTF endereco = endTemp instanceof ServicoCTF ? (ServicoCTF)endTemp : new ServicoCTF(endTemp);
                        ipsServicoCTF.add(endereco);
                    }
                    confCTFClientCtrl.setIps(ipsServicoCTF);
                    for (ServicoCTF servico : confCTFClientCtrl.getIps()) {
                        ParameterSet ipParameter = new ParameterSet("ip");
                        if (servico.getHost() == null || servico.getHost().equals("")) {
                            logger.log("ERROR", "valor de parametro invalido ==> ips = host");
                            throw new ExcecaoApiAc("valor de parametro invalido");
                        }
                        Parameter hostParameter = new Parameter("host");
                        hostParameter.setContent(servico.getHost().getEndereco());
                        ipParameter.attachParameter(hostParameter);
                        if (servico.getIdentificadorServico() == null || servico.getIdentificadorServico().equals("")) {
                            logger.log("ERROR", "valor de parametro invalido ==> ips = port");
                            throw new ExcecaoApiAc("valor de parametro invalido");
                        }
                        Parameter portParameter = new Parameter("port");
                        portParameter.setContent(servico.getIdentificadorServico());
                        ipParameter.attachParameter(portParameter);
                        if (servico.getProtocolo() == null || servico.getProtocolo().equals("")) {
                            logger.log("ERROR", "valor de parametro invalido ==> ips = protocolo");
                            throw new ExcecaoApiAc("valor de parametro invalido");
                        }
                        Parameter protocoloParameter = new Parameter("protocolo");
                        protocoloParameter.setContent(servico.getProtocolo());
                        ipParameter.attachParameter(protocoloParameter);
                        ipsParameter.attachParameterSet(ipParameter);
                    }
                } else {
                    logger.log("ERROR", "lista de ips n\u00e3o configurada ==> ips");
                    throw new ExcecaoApiAc("valor de parametro invalido");
                }
            }
            if (confCTFClientCtrl.isConfContingenciaConexaoCtrl()) {
                ConfContingenciaConexao confContingenciaConexao = confCTFClientCtrl.getConfContingenciaConexao();
                ParameterSet contingenciaConexao = null;
                Parameter maximoConexao = null;
                Parameter tempoConexao = null;
                Parameter resetConexao = null;
                int valorVazio = -1;
                if (this.isConfigurado(root, "contingenciaConexao")) {
                    contingenciaConexao = root.getParameterSet("contingenciaConexao");
                } else {
                    contingenciaConexao = new ParameterSet("contingenciaConexao");
                    root.attachParameterSet(contingenciaConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "maximoConexao")) {
                    maximoConexao = contingenciaConexao.getParameter("maximoConexao");
                } else {
                    maximoConexao = new Parameter("maximoConexao");
                    maximoConexao.setContent("1");
                    contingenciaConexao.attachParameter(maximoConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "tempoConexao")) {
                    tempoConexao = contingenciaConexao.getParameter("tempoConexao");
                } else {
                    tempoConexao = new Parameter("tempoConexao");
                    tempoConexao.setContent("0");
                    contingenciaConexao.attachParameter(tempoConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "resetConexao")) {
                    resetConexao = contingenciaConexao.getParameter("resetConexao");
                } else {
                    resetConexao = new Parameter("resetConexao");
                    resetConexao.setContent("0");
                    contingenciaConexao.attachParameter(resetConexao);
                }
                if (confContingenciaConexao != null) {
                    if (confContingenciaConexao.getMaximoConexao() != valorVazio) {
                        maximoConexao.setContent(confContingenciaConexao.getMaximoConexao() + "");
                    }
                    if (confContingenciaConexao.getTempoMaximoConexao() != valorVazio) {
                        tempoConexao.setContent(confContingenciaConexao.getTempoMaximoConexao() + "");
                    }
                    if (confContingenciaConexao.getResetConexao() != valorVazio) {
                        resetConexao.setContent(confContingenciaConexao.getResetConexao() + "");
                    }
                } else {
                    maximoConexao.setContent("1");
                    tempoConexao.setContent("0");
                    resetConexao.setContent("0");
                }
            }
            if ((perifericos = root.getParameterSet("perifericos")) != null) {
                if (confCTFClientCtrl.isMapaTecladoCtrl()) {
                    Parameter mapaTeclado = null;
                    try {
                        mapaTeclado = perifericos.getParameter("mapaTeclado");
                    }
                    catch (Exception e) {
                        mapaTeclado = new Parameter("mapaTeclado");
                        perifericos.attachParameter(mapaTeclado);
                    }
                    mapaTeclado.setContent(confCTFClientCtrl.getMapaTeclado());
                }
                if (confCTFClientCtrl.isTecladoCtrl() && confCTFClientCtrl.getTeclado() != null) {
                    ParameterSet perifericoTeclado = perifericos.getParameterSet("DRIVER_TECLADO");
                    ConfPeriferico teclado = confCTFClientCtrl.getTeclado();
                    if ("TECLADO_PC".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_PC");
                    } else if ("TECLADO_JAVAPOS".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_JAVAPOS");
                    } else if ("TECLADO_TOUCH_LINX".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_TOUCH_LINX");
                    } else if ("TECLADO_TOUCH".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_TOUCH");
                    } else {
                        logger.log("ERROR", "valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    if (teclado.getParametros() != null && teclado.getParametros().length > 0) {
                        perifericoTeclado.getParameter("params").setContent(StringUtil.toString(teclado.getParametros()));
                    } else {
                        perifericoTeclado.getParameter("params").setContent(null);
                    }
                }
                if (confCTFClientCtrl.isDisplayOperadorCtrl() && confCTFClientCtrl.getDisplayOperador() != null) {
                    ParameterSet perifericoDisplayOperador = perifericos.getParameterSet("DRIVER_DISPLAY_OPERADOR");
                    ConfPeriferico displayOperador = confCTFClientCtrl.getDisplayOperador();
                    if (!("DISPLAY_CTFCLIENT".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_JAVAPOS".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_AUTTAR".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_CSI".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_OPERADOR".equalsIgnoreCase(displayOperador.getNomeLogico()))) {
                        logger.log("ERROR", "valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    perifericoDisplayOperador.getParameter("tipo").setContent(displayOperador.getNomeLogico());
                    if (displayOperador.getParametros() != null && displayOperador.getParametros().length > 0) {
                        perifericoDisplayOperador.getParameter("params").setContent(StringUtil.toString(displayOperador.getParametros()));
                    } else {
                        perifericoDisplayOperador.getParameter("params").setContent(null);
                    }
                }
                if (confCTFClientCtrl.isScannerCtrl() && confCTFClientCtrl.getScanner() != null) {
                    ParameterSet perifericoScanner = perifericos.getParameterSet("DRIVER_SCANNER");
                    ConfPeriferico scanner = confCTFClientCtrl.getScanner();
                    if (!"SCANNER_SERIAL".equalsIgnoreCase(scanner.getNomeLogico()) && !"SCANNER_JAVAPOS".equalsIgnoreCase(scanner.getNomeLogico())) {
                        logger.log("ERROR", "valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    perifericoScanner.getParameter("tipo").setContent(scanner.getNomeLogico());
                    if (scanner.getParametros() != null && scanner.getParametros().length > 0) {
                        perifericoScanner.getParameter("params").setContent(StringUtil.toString(scanner.getParametros()));
                    } else {
                        perifericoScanner.getParameter("params").setContent(null);
                    }
                }
                if (confCTFClientCtrl.isLeitorDocumentoCtrl() && confCTFClientCtrl.getLeitorDocumento() != null) {
                    ParameterSet perifericoLeitorDocumento = perifericos.getParameterSet("DRIVER_LEITOR_DOCUMENTO");
                    ConfPeriferico leitorDocumento = confCTFClientCtrl.getLeitorDocumento();
                    if (!("LEITOR_DOCUMENTO_CHRONOS".equalsIgnoreCase(leitorDocumento.getNomeLogico()) || "LEITOR_DOCUMENTO_LOGGER2".equalsIgnoreCase(leitorDocumento.getNomeLogico()) || "LEITOR_DOCUMENTO_TECPOINTTL840".equalsIgnoreCase(leitorDocumento.getNomeLogico()))) {
                        logger.log("ERROR", "valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    perifericoLeitorDocumento.getParameter("tipo").setContent(leitorDocumento.getNomeLogico());
                    if (leitorDocumento.getParametros() != null && leitorDocumento.getParametros().length > 0) {
                        perifericoLeitorDocumento.getParameter("params").setContent(StringUtil.toString(leitorDocumento.getParametros()));
                    } else {
                        perifericoLeitorDocumento.getParameter("params").setContent(null);
                    }
                }
                if ((confCTFClientCtrl.isLeitorCartaoCtrl() || confCTFClientCtrl.isPinCtrl()) && confCTFClientCtrl.getLeitorCartao() != null && confCTFClientCtrl.getPin() != null) {
                    ConfPeriferico configLeitorCartao = confCTFClientCtrl.getLeitorCartao();
                    ConfPeriferico configPinPad = confCTFClientCtrl.getPin();
                    if (configLeitorCartao.getParametros() != null && configLeitorCartao.getParametros().length > 0 && configPinPad.getParametros() != null && configPinPad.getParametros().length > 0) {
                        ParameterSet configPinpadParameter = perifericos.getParameterSet("CONFIG_PINPAD");
                        configPinpadParameter.getParameter("portaSerial").setContent(configLeitorCartao.getParametros()[0]);
                        configPinpadParameter.getParameter("msgPrompt").setContent(configLeitorCartao.getParametros()[2]);
                        configPinpadParameter.getParameter("msgCartao").setContent(configLeitorCartao.getParametros()[1]);
                        configPinpadParameter.getParameter("msgSenha").setContent(configPinPad.getParametros()[2]);
                        configPinpadParameter.getParameter("msgAguardo").setContent(configPinPad.getParametros()[3]);
                    }
                }
                if (confCTFClientCtrl.isTentativasConexaoPinpadCtrl()) {
                    ParameterSet configPinpadParameter = perifericos.getParameterSet("CONFIG_PINPAD");
                    configPinpadParameter.getParameter("tentativasConexao").setContent(confCTFClientCtrl.getTentativasConexaoPinpad() + "");
                }
                if (confCTFClientCtrl.isTimeoutPinCtrl()) {
                    ParameterSet timeoutPin = root.getParameterSet("timeoutPin");
                    if (timeoutPin == null) {
                        logger.log("ERROR", "parametro n\u00e3o encontrado ==> timeoutPin");
                    } else {
                        ConfTimeoutPin confTimeoutPin = confCTFClientCtrl.getTimeoutPin();
                        timeoutPin.getParameter("default").setContent(String.valueOf(confTimeoutPin.getTimeoutDefault()));
                        timeoutPin.getParameter("blocking").setContent(String.valueOf(confTimeoutPin.getTimeoutBlocking()));
                        timeoutPin.getParameter("noblocking").setContent(String.valueOf(confTimeoutPin.getTimeoutNoblocking()));
                    }
                }
                if (confCTFClientCtrl.isIntegracaoCriptografadaCtrl()) {
                    if (confCTFClientCtrl.isIntegracaoCriptografada()) {
                        root.getParameter("integracaoCriptografada").setContent("true");
                    } else {
                        root.getParameter("integracaoCriptografada").setContent("false");
                    }
                }
            }
            if (confCTFClientCtrl.isEnvioCupomIntegracaoCtrl()) {
                root.getParameter("envioCupomIntegracao").setContent(String.valueOf(confCTFClientCtrl.isEnvioCupomIntegracaoCtrl()));
            }
            config.save();
            this.reader();
            logger.log("INFO", "Finalizando atualiza\u00e7\u00e3o do arquivo de configura\u00e7\u00f5es...");
        }
        catch (SecurityException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc("error Parameter: " + e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (IOException e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
    }

    private boolean isConfigurado(ParameterSet parametro, String nome) {
        try {
            parametro.getParameter(nome);
            return true;
        }
        catch (Exception exception) {
            try {
                parametro.getParameters(nome);
                return true;
            }
            catch (Exception exception2) {
                try {
                    parametro.getParameterSet(nome);
                    return true;
                }
                catch (Exception exception3) {
                    try {
                        parametro.getParameterSets(nome);
                        return true;
                    }
                    catch (Exception exception4) {
                        return false;
                    }
                }
            }
        }
    }
}

