/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.info.tiposgerais;

import com.csi.ctfclient.excecoes.ExcecaoObjetoInexistente;
import com.csi.ctfclient.excecoes.ExcecaoObjetoJaExistente;
import com.csi.ctfclient.info.tiposgerais.CSIHashMap;
import com.csi.ctfclient.info.tiposgerais.Chave;
import com.csi.ctfclient.info.tiposgerais.ChaveString;
import com.csi.ctfclient.info.tiposgerais.Conjunto;
import com.csi.ctfclient.info.tiposgerais.EmptyEnumeration;
import com.csi.ctfclient.info.tiposgerais.Persistente;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class Colecao
implements Conjunto {
    private CSIHashMap mapeamento;
    private static final long serialVersionUID = -8815470105788251200L;

    @Override
    public Object busca(Chave chave) throws ExcecaoObjetoInexistente {
        if (this.mapeamento == null) {
            throw new ExcecaoObjetoInexistente();
        }
        Object result = this.getMapemanento().get(chave.toString());
        if (result == null) {
            throw new ExcecaoObjetoInexistente();
        }
        return result;
    }

    public Enumeration chaves() {
        if (this.mapeamento == null) {
            return new EmptyEnumeration();
        }
        Enumeration enumeration = new Enumeration(){
            Enumeration aux;
            {
                this.aux = Colecao.this.getMapemanento().keys();
            }

            @Override
            public boolean hasMoreElements() {
                return this.aux.hasMoreElements();
            }

            public Object nextElement() {
                return new ChaveString((String)this.aux.nextElement());
            }
        };
        return enumeration;
    }

    @Override
    public Collection collection() {
        if (this.mapeamento == null) {
            return new Vector();
        }
        return this.getMapemanento().values();
    }

    @Override
    public boolean consulta(Chave chave) {
        if (this.mapeamento == null) {
            return false;
        }
        return this.getMapemanento().containsKey(chave.toString());
    }

    @Override
    public void deleta(Chave chave) throws ExcecaoObjetoInexistente {
        if (!this.consulta(chave)) {
            throw new ExcecaoObjetoInexistente();
        }
        this.getMapemanento().remove(chave.toString());
    }

    @Override
    public Enumeration elementos() {
        if (this.mapeamento == null) {
            return new EmptyEnumeration();
        }
        return this.getMapemanento().elements();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Colecao) {
            Colecao temp = (Colecao)obj;
            if (this.mapeamento == null) {
                return temp.mapeamento == null;
            }
            if (temp.mapeamento == null) {
                return false;
            }
            if (this.getMapemanento().size() != temp.collection().size()) {
                return false;
            }
            Enumeration enumeration = this.chaves();
            Enumeration enumIt = temp.chaves();
            boolean sair = false;
            while (enumeration.hasMoreElements() && !sair) {
                Chave chave = (Chave)enumeration.nextElement();
                if (enumIt.hasMoreElements()) {
                    Chave chaveIt = (Chave)enumIt.nextElement();
                    if (chave.equals(chaveIt)) continue;
                    sair = true;
                    continue;
                }
                sair = true;
            }
            result = !sair;
        }
        return result;
    }

    @Override
    public void inclui(Persistente elemento) throws ExcecaoObjetoJaExistente {
        if (this.consulta(elemento.getChave())) {
            throw new ExcecaoObjetoJaExistente();
        }
        this.getMapemanento().put(elemento.getChaveString(), elemento);
    }

    @Override
    public void limpa() {
        this.mapeamento = null;
    }

    @Override
    public int tamanho() {
        if (this.mapeamento == null) {
            return 0;
        }
        return this.getMapemanento().size();
    }

    @Override
    public boolean vazio() {
        if (this.mapeamento == null) {
            return true;
        }
        return this.getMapemanento().isEmpty();
    }

    private CSIHashMap getMapemanento() {
        if (this.mapeamento == null) {
            this.mapeamento = new CSIHashMap();
        }
        return this.mapeamento;
    }
}

