/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.ConfiguracaoException;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.HandlerManager;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class StartupCTFClient {
    ILogger logger = CTFClientLogger.getIntegrador();
    private Handler handler;

    public void start() {
        try {
            this.logger.info("Abrindo servidor CTFClient...");
            try {
                this.logger.info("inicializando instancia do CTFClient...");
                CTFClient.getInstancia();
                this.logger.info("instancia do CTFClient inicializada.");
                ConfiguracaoIntegrador configuracao = ConfiguracaoIntegrador.newInstanceBuild();
                this.handler = configuracao.getHandlerStream();
                this.handler.addHandlerListener(new HandlerManager(configuracao));
                this.handler.start();
            }
            catch (ExcecaoApiAc e) {
                this.logger.error("Erro ao inicializar CTFClient.");
                this.handler = null;
            }
        }
        catch (ConfiguracaoException e) {
            this.logger.error("Erro no arquivo de configuracao do Integrador");
            this.handler = null;
        }
    }

    public void stop() {
        if (this.handler != null) {
            this.handler.stop();
            this.logger.info("CTFClient finalizado.");
            this.handler = null;
        }
    }

    public boolean isAtivo() {
        return this.handler != null;
    }
}

