/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.CnpjUtil;
import com.csi.ctfclient.tools.util.CpfUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public abstract class MicAbstractCapturaCpfCnpj {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String INVALID_CPF_CNPJ = "INVALID_CPF_CNPJ";
    public static final String USER_CANCEL = "USER_CANCEL";

    protected abstract boolean isCapturaCpfCnpj();

    protected abstract String getTituloDisplay();

    protected abstract String getCpfCnpj();

    protected abstract void setCpfCnpj(String var1);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        EventoTeclado eventoTeclado;
        ILogger logger = CTFClientLogger.getCTFClient();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (this.getCpfCnpj() != null) {
            return FILLED;
        }
        if (!this.isCapturaCpfCnpj()) {
            return NOT_REQUIRED;
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        do {
            if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(this.getTituloDisplay()), ConstantesApiAc.CAP_CPF_CNPJ)).getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        } while (caracteresDigitados != 11 && caracteresDigitados != 14 && this.isCapturaObrigatoria());
        if (caracteresDigitados == 11) {
            if (CpfUtil.validaCpf(valor)) {
                this.setCpfCnpj(valor);
                return SUCCESS;
            }
            displayModel = new LayoutDisplay(inter.getMessage("CAPABSCPFCNP_INVALID_CPF"));
            eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
            if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                return INVALID_CPF_CNPJ;
            }
            return USER_CANCEL;
        }
        if (caracteresDigitados == 14) {
            if (CnpjUtil.validaCnpj(valor)) {
                this.setCpfCnpj(valor);
                return SUCCESS;
            }
            displayModel = new LayoutDisplay(inter.getMessage("CAPABSCPFCNP_INVALID_CNPJ"));
            eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
            if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                return INVALID_CPF_CNPJ;
            }
            return USER_CANCEL;
        }
        if (this.isCapturaObrigatoria()) {
            throw new IllegalArgumentException("Tamanho capturado n\u00e3o esperado: " + caracteresDigitados);
        }
        return SUCCESS;
    }

    protected boolean isCapturaObrigatoria() {
        return true;
    }
}

