/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoSeguro;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.HexaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public abstract class MicAbstractEnvio1F {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANSGENERICA = "ERRO_TRANSGENERICA";
    public static final String ERRO_AC = "ERRO_AC";
    public static final String LEITURA_AUTTAR_EMV = "LEITURA_AUTTAR_EMV";
    public static final String REFAZER_LEITURA_CARTAO = "REFAZER_LEITURA_CARTAO";
    public static final String SOLICITA_CARGA_TABELA = "SOLICITA_CARGA_TABELA";
    private boolean multiTerminal = false;
    private ILogger logger = CTFClientLogger.getCTFClient();
    private final char DELIMITADOR_TRILHA1 = (char)94;
    private final char DELIMITADOR_TRILHA2 = (char)61;
    private String codigoTransacaoRetorno;
    private ConfCTFClient confCTFClient;
    private static final String MSG_SEM_PINPAD = "999 - ERRO CONECTE PINPAD";

    protected abstract String getCodigoTransacao(Process var1) throws IllegalStateException;

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        this.confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        boolean connectedPin = false;
        ContextoCTFClient contextoCTFClient = Contexto.getContexto();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ControladorPerifericos periferico = dados.getPerifericos();
        if (contextoCTFClient.getEntradaIntegracao() != null) {
            this.multiTerminal = entradaIntegracao.isMultiTerminal();
        }
        if (entradaIntegracao != null && entradaIntegracao.isCodigoOrigemTransacaoCtrl()) {
            entrada.setIdentificacaoTransacao(entradaIntegracao.getCodigoOrigemTransacao());
        } else if (this.confCTFClient.isIntegracaoWeb()) {
            entrada.setIdentificacaoTransacao(2);
        }
        if (this.multiTerminal) {
            entrada.setTipoPin("**");
            entrada.setIdentificacaoTransacao(2);
            if (entradaIntegracao != null) {
                entrada.setCodigoAdquirenteWeb(entradaIntegracao.getRedeAdquirente());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
            periferico.imprimeDisplay(displayModel);
            connectedPin = periferico.getPin() != null;
            try {
                if (connectedPin) {
                    if (periferico.getPin().isBibliotecaEMV()) {
                        entrada.setTipoPin("16");
                        entrada.setTipoBibliotecaPinpad(ProtocoloBibliotecaCompartilhada.getTipoBibliotecaPinpad());
                        if (!KeyFactory.isChaveLocal()) {
                            if (entrada.getCartaoSeguro() == null) {
                                CartaoSeguro cartaoSeguro = new CartaoSeguro();
                                entrada.setCartaoSeguro(cartaoSeguro);
                            }
                            entrada.getCartaoSeguro().setWkPAN(ProtocoloBibliotecaCompartilhada.wkpan);
                        }
                        GetInfo dadosGetInfo = new GetInfo();
                        DadosGetInfoRedeEMV dadosGetInfoRedeEMV = periferico.getPin().getInfoRedeEMV(4);
                        if (dadosGetInfoRedeEMV != null) {
                            entrada.setDadosGetInfoRede4(dadosGetInfoRedeEMV.getRespostaDLL());
                            entrada.setVersaoBibliotecaRedeEMV(dadosGetInfoRedeEMV.getVersaoAplicacao());
                            entrada.setVersaoEspecificacaoRedeEMV(dadosGetInfoRedeEMV.getInformacoesProprietarias());
                            dadosGetInfo.setVersaoBibRede4(dadosGetInfoRedeEMV.getVersaoAplicacao());
                        }
                        SaidaGetInfoEMV getInfoEMV = periferico.getPin().getInfo();
                        entrada.setNumeroSeriePin(getInfoEMV.getNumSeriePinpad());
                        entrada.setRetornoGetInfo(getInfoEMV.getRetorno());
                        entrada.setFabricantePinpad(getInfoEMV.getFabricante());
                        entrada.setModeloHardware(getInfoEMV.getModeloHardware());
                        entrada.setRetornoGetInfo(getInfoEMV.getRetorno());
                        entrada.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificacao());
                        entrada.setVersaoFirmwarePinpad(getInfoEMV.getVersaoFirmware());
                        entrada.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplBasica());
                        dadosGetInfo.setCodigoRetorno(getInfoEMV.getRetorno());
                        dadosGetInfo.setFabricante(getInfoEMV.getFabricante());
                        dadosGetInfo.setModeloHardware(getInfoEMV.getModeloHardware());
                        dadosGetInfo.setNumeroSerie(getInfoEMV.getNumSeriePinpad());
                        dadosGetInfo.setVersaoEspecificao(getInfoEMV.getVersaoEspecificacao());
                        dadosGetInfo.setVersaoAplicacao(getInfoEMV.getVersaoAplBasica());
                        dadosGetInfo.setVersaoFirmware(getInfoEMV.getVersaoFirmware());
                        dadosGetInfo.setSuportaContactless(getInfoEMV.isSuportaContactless());
                        entrada.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificacao());
                        entrada.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplBasica());
                        Contexto.getContexto().setDadosGetInfo(dadosGetInfo);
                    } else {
                        entrada.setTipoPin("14");
                    }
                } else {
                    entrada.setTipoPin("**");
                }
            }
            catch (ExcecaoPerifericos e) {
                this.logger.log("ERROR", "Erro ao habilitar o leitor cart\u00e3o", e);
                periferico.liberarRecursosPinCartao();
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5327, MSG_SEM_PINPAD));
                return ERRO_AC;
            }
            ControladorBaixaTecnica baixaTecnica = ControladorBaixaTecnica.getInstance();
            if (connectedPin && baixaTecnica.verificaNecessidadeBaixaTecnica(dados)) {
                entrada.setFlagBaixaTecnicaVisanet('2');
            }
        }
        entrada.setTimeoutCtf(this.getTimeout1F());
        entrada.setOperacao("1F");
        entrada.setOperacaoConsultada(this.getCodigoTransacao(dados));
        if (this.confCTFClient.isMultiEC()) {
            entrada.setMultiEC(this.confCTFClient.isMultiEC());
            entrada.setCodigoGrupoMultiEC(this.confCTFClient.getCodigoGrupoMultiEC());
        }
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        entrada.setFlagBaixaTecnicaVisanet('0');
        if (saidaApiTefC.getRetorno() == 0 && (saidaApiTefC.getFlagBaixaTecnica() == '1' || saidaApiTefC.getFlagBaixaTecnica() == '2')) {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(true);
        } else {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(false);
        }
        if (connectedPin) {
            if (!(saidaApiTefC.getRedeChip() <= 0 || saidaApiTefC.getTipoBibliotecaPinpad() != 2 && !saidaApiTefC.isRefazerLeituraCartao() || Contexto.getContexto().getCartao() != Cartao.CHIP && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV || periferico.getLeitorCartao() == null)) {
                periferico.getLeitorCartao().setRedeAdquirente(saidaApiTefC.getRedeChip());
                if (saidaApiTefC.getTipoBibliotecaPinpad() == 1 && saidaApiTefC.getIndiceAID() != null) {
                    periferico.getLeitorCartao().setIndiceAID(saidaApiTefC.getIndiceAID());
                }
            }
            if (saidaApiTefC.getFlagCargaTabela() == '1' && (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV)) {
                try {
                    this.logger.info("NECESSITA REALIZAR CARGA DE TABELA");
                    if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                        CMOSPinPad.getInstance().solicitarCargaTabelas(saidaApiTefC.getRedeChip());
                    } else {
                        CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                    }
                    if (periferico.getLeitorCartao() != null) {
                        periferico.getLeitorCartao().setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_SOLICITADA);
                        Contexto.getContexto().setSaidaApiTefC(null);
                        Contexto.getContexto().resetCartao();
                    }
                    if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                        ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(2);
                        return LEITURA_AUTTAR_EMV;
                    }
                    return SOLICITA_CARGA_TABELA;
                }
                catch (Exception baixaTecnica) {
                    // empty catch block
                }
            }
            if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(2);
                return LEITURA_AUTTAR_EMV;
            }
            if (saidaApiTefC.isRefazerLeituraCartao()) {
                this.setCodigoTransacaoRetorno(saidaApiTefC.getCodigoTransacao());
                Contexto.getContexto().setNovaLeituraCartao(true);
                Contexto.getContexto().setSaidaApiTefC(null);
                Contexto.getContexto().resetCartao();
                return REFAZER_LEITURA_CARTAO;
            }
        }
        if (saidaApiTefC.getRetorno() == 0) {
            this.logger.info("1F APROVADA");
            ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
            entrada.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            if ((saidaApiTefC.getCodigoVan() == 68 || saidaApiTefC.getCodigoVan() == 90 || saidaApiTefC.getCodigoVan() == 37 || saidaApiTefC.getCodigoVanAlfa() != null && saidaApiTefC.getCodigoVanAlfa().equals("AA")) && connectedPin) {
                SaidaGetInfoRedecardEMV infoRedecardEMV = periferico.getPin().getInfoRedecard();
                entrada.setVersaoBibliotecaCompartilhada(infoRedecardEMV.getInformacaoProprietaria());
                entrada.setVersaoRedeAdquirente(infoRedecardEMV.getVersaoRedeAdquirente());
                entrada.setVersaoKernelEMV(infoRedecardEMV.getVersaoKernelEMV());
            }
            Contexto.getContexto().setDataAutorizadora(saidaApiTefC.getDataAutorizadora());
            Contexto.getContexto().setCodigoVan(saidaApiTefC.getCodigoVan());
            Contexto.getContexto().setCodigoVanAlfa(saidaApiTefC.getCodigoVanAlfa());
            Contexto.getContexto().setNomeVan(saidaApiTefC.getNomeVan());
            Contexto.getContexto().setCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora());
            Contexto.getContexto().setNomeAutorizadora(saidaApiTefC.getNomeAutorizadora());
            Contexto.getContexto().setCodigoInstituicaoFinanceira(saidaApiTefC.getCodigoInstituicaoFinanceira());
            Contexto.getContexto().setNomeInstituicaoFinanceira(saidaApiTefC.getNomeInstituicaoFinanceira());
            Contexto.getContexto().setDataVencimento(saidaApiTefC.getDataVencimento());
            Contexto.getContexto().setNomeCliente(saidaApiTefC.getNomeCliente());
            entrada.setIndiceMasterKey(saidaApiTefC.getIndiceMasterKey());
            if (connectedPin && periferico.getPin().isBibliotecaEMV()) {
                String ksn;
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                PinEMV pinEMV = periferico.getPin();
                TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia(pinEMV, saidaApiTefC);
                CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), tabelaCriptografia);
                if (saidaApiTefC.isCriptografiaCartao()) {
                    this.logger.log("DEBUG", "Criptografar os dados do cart\u00e3o");
                    this.montaCriptografiaDados(dados);
                }
                if (saidaApiTefC.isCapturaKsnDukptDes() && (ksn = this.capturaKsnDukpt(2, tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey(), pinEMV)) != null) {
                    entrada.setKsnDukptDes(ksn);
                }
                if (saidaApiTefC.isCapturaKsnDukpt3Des() && (ksn = this.capturaKsnDukpt(3, tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey(), pinEMV)) != null) {
                    entrada.setKsnDukpt3Des(ksn);
                }
                if (conBaixaTecnica.isBaixaTecnicaSolicitada()) {
                    entrada.setFlagBaixaTecnicaVisanet('1');
                    entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
                    entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
                    conBaixaTecnica.persisteBaixaTecnica();
                }
            }
            return SUCESS;
        }
        if (connectedPin) {
            if ((Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) && Contexto.getContexto().getErrorCode() == -1) {
                Contexto.getContexto().setErrorCode(0);
            }
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(false);
        }
        this.logger.info("1F N\u00c3O APROVADA RETORNO: " + saidaApiTefC.getRetorno() + " CODIGO DETALHE: " + saidaApiTefC.getCodigoErro() + " RESPOSTA AUTORIZADORA: " + saidaApiTefC.getCodigoRespostaAutorizadora());
        String resposta = saidaApiTefC.getCodigoRespostaAutorizadora();
        if ("0ZY".equals(resposta) || "ZY".equals(resposta)) {
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
                Contexto.getContexto().setNovaLeituraCartao(true);
            } else {
                Contexto.getContexto().resetCartao();
            }
            KeyFactory.reset();
            if (periferico.getLeitorCartao() != null) {
                periferico.getLeitorCartao().desabilita();
            }
            return REFAZER_LEITURA_CARTAO;
        }
        if ("0EB".equals(resposta) || "EB".equals(resposta)) {
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
                Contexto.getContexto().setNovaLeituraCartao(true);
            } else {
                Contexto.getContexto().resetCartao();
            }
        } else if (Contexto.getContexto().getCartao() != Cartao.DIGITADO) {
            if (!"0F0".equals(resposta) && !"F0".equals(resposta)) {
                if (this.isResetCartaoAposErroRetornoCTF()) {
                    if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
                        Contexto.getContexto().setNovaLeituraCartao(true);
                    } else {
                        Contexto.getContexto().resetCartao();
                    }
                } else {
                    this.logger.log("INFO", "Os dados do cart\u00e3o ser\u00e3o preservados ap\u00f3s o retorno com erro");
                }
            }
        } else if ("0EM".equals(resposta) || "EM".equals(resposta)) {
            entrada.setDataVencimento(null);
        } else if ("0EH".equals(resposta) || "EH".equals(resposta)) {
            entrada.setDataVencimento(null);
        } else if (!"0F0".equals(resposta) && !"F0".equals(resposta) && this.isResetCartaoAposErroRetornoCTF()) {
            Contexto.getContexto().resetCartao();
        }
        if (Contexto.getContexto().isTransacaoGenerica()) {
            return ERRO_TRANSGENERICA;
        }
        return ERRO;
    }

    private void montaCriptografiaDados(Process dados) throws ExcecaoPerifericos {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            String panEB;
            if (KeyFactory.isChaveLocal()) {
                if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && entradaApiTefC.getPAN().length() > 12) {
                    this.logger.log("DEBUG", "Comunica\u00e7\u00e3o segura: utilizando o PAN 3 DES Reverso do cart\u00e3o digitado");
                    panEB = entradaApiTefC.getPANCripto();
                } else {
                    panEB = entradaApiTefC.getPAN();
                }
            } else if (saidaApiTefC.getPanSeguroCriptDados() != null) {
                panEB = saidaApiTefC.getPanSeguroCriptDados();
                int idx = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(2, 4));
                panEB = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
            } else {
                panEB = entradaApiTefC.getPAN();
            }
            String cartaoDigitadoCripto = this.criptografaBuffer(dados, panEB);
            entradaApiTefC.setCartaoCriptografado(cartaoDigitadoCripto);
        } else {
            String panEB;
            String trilha1Cripto;
            String cript;
            if (KeyFactory.isChaveLocal()) {
                if (entradaApiTefC.getTrilha1() != null && !entradaApiTefC.getTrilha1().trim().equals("")) {
                    String digitos = entradaApiTefC.getTrilha1().substring(3, 11);
                    String digHexa = HexaUtil.toEBCDICHex(digitos);
                    if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                        this.logger.log("DEBUG", "Comunica\u00e7\u00e3o segura: Criptografando d\u00edgito intercalado para a trilha 1");
                        try {
                            digHexa = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(digHexa, false);
                        }
                        catch (Exception e) {
                            this.logger.log("ERROR", "Erro ao descriptografar o PAN da trilha 1 para uso na EncryptBuffer", e);
                        }
                    }
                    cript = this.criptografaDadoEncryptBuffer(dados, digHexa, saidaApiTefC);
                    trilha1Cripto = entradaApiTefC.getTrilha1().substring(0, 3) + cript + entradaApiTefC.getTrilha1().substring(11);
                    entradaApiTefC.setTrilha1Criptografada(trilha1Cripto);
                }
            } else if (saidaApiTefC.getTrilha1SeguraCriptDados() != null) {
                int idx = Integer.parseInt(saidaApiTefC.getTrilha1SeguraCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getTrilha1SeguraCriptDados().substring(2, 4));
                cript = saidaApiTefC.getTrilha1SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
                cript = this.criptografaDadoEncryptBuffer(dados, cript, saidaApiTefC);
                trilha1Cripto = saidaApiTefC.getTrilha1SeguraCriptDados().substring(4, idx + 4) + cript + saidaApiTefC.getTrilha1SeguraCriptDados().substring(idx + tam + 4);
                entradaApiTefC.setTrilha1Criptografada(trilha1Cripto);
            }
            if (KeyFactory.isChaveLocal()) {
                if (entradaApiTefC.getInfo() != null && !entradaApiTefC.getInfo().trim().equals("")) {
                    String panTrilha2;
                    String panTrilha2Substituir = panTrilha2 = entradaApiTefC.getPAN();
                    if (panTrilha2.length() < 16) {
                        panTrilha2Substituir = entradaApiTefC.getInfo().substring(0, 16);
                        panTrilha2 = panTrilha2Substituir.replace('=', 'D');
                    } else if (panTrilha2.length() > 16) {
                        panTrilha2Substituir = panTrilha2 = panTrilha2.substring(0, 16);
                    }
                    if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                        this.logger.log("DEBUG", "Comunica\u00e7\u00e3o segura: Criptografando o PAN para a trilha 2");
                        try {
                            panTrilha2 = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panTrilha2, false);
                        }
                        catch (Exception e) {
                            this.logger.log("ERROR", "Erro ao descriptografar o PAN da trilha 2 para uso na EncryptBuffer", e);
                        }
                    }
                    cript = this.criptografaDadoEncryptBuffer(dados, panTrilha2, saidaApiTefC);
                    entradaApiTefC.setTrilha2Criptografada(LeitorCartaoBibliotecaCompartilhada.atualizaTrilha(entradaApiTefC.getInfo(), panTrilha2Substituir, cript));
                }
            } else if (saidaApiTefC.getTrilha2SeguraCriptDados() != null) {
                int idx = Integer.parseInt(saidaApiTefC.getTrilha2SeguraCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getTrilha2SeguraCriptDados().substring(2, 4));
                cript = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
                cript = this.criptografaDadoEncryptBuffer(dados, cript, saidaApiTefC);
                String trilha2Cripto = saidaApiTefC.getTrilha2SeguraCriptDados().substring(4, idx + 4) + cript + saidaApiTefC.getTrilha2SeguraCriptDados().substring(idx + tam + 4);
                entradaApiTefC.setTrilha2Criptografada(trilha2Cripto);
            }
            if (KeyFactory.isChaveLocal()) {
                if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && entradaApiTefC.getPAN().length() > 12) {
                    this.logger.log("DEBUG", "Comunica\u00e7\u00e3o segura: Criptografando o PAN");
                    panEB = entradaApiTefC.getPANCripto();
                } else {
                    panEB = entradaApiTefC.getPAN();
                }
            } else if (saidaApiTefC.getPanSeguroCriptDados() != null) {
                panEB = saidaApiTefC.getPanSeguroCriptDados();
                int idx = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(2, 4));
                panEB = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
            } else {
                panEB = entradaApiTefC.getPAN();
            }
            if (panEB != null) {
                String cartaoDigitadoCripto = this.criptografaBuffer(dados, panEB);
                entradaApiTefC.setCartaoCriptografado(cartaoDigitadoCripto);
            }
        }
    }

    private String criptografaDadoEncryptBuffer(Process dados, String value, SaidaApiTefC saida) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        if (pin instanceof BibliotecaPinpad) {
            BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pin;
            TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            this.logger.log("DEBUG", "Criptografia: Indice: " + indiceCriptografia + ", Modo: " + modoCriptografia + ", Working Key: " + workingKey);
            if (modoCriptografia == 0) {
                workingKey = StringUtil.completaString(workingKey, 32, '0', 4);
            }
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                // empty if block
            }
            return pinCompartilhado.encryptBuffer(modoCriptografia, indiceCriptografia, workingKey, value);
        }
        throw new ExcecaoPerifericos(null, "Erro na criptografia do cart\u00e3o");
    }

    protected String criptografaBuffer(Process dados, String bufferAberto) throws ExcecaoPerifericos {
        String bufferCriptografado;
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (bufferAberto.length() < 16) {
            bufferCriptografado = StringUtil.completaString(bufferAberto, 16, 'F', 4);
            bufferCriptografado = this.criptografaDadoEncryptBuffer(dados, bufferCriptografado, saidaApiTefC);
        } else {
            bufferCriptografado = this.criptografaDadoEncryptBuffer(dados, bufferAberto.substring(0, 16), saidaApiTefC);
            bufferCriptografado = bufferCriptografado + bufferAberto.substring(16);
        }
        return bufferCriptografado;
    }

    private boolean isTrilha1PermiteComunicacaoSegura(String trilha1) {
        int i = 0;
        int tamanhoPan = 0;
        boolean encontrouDelimitador = false;
        if (trilha1.charAt(0) != '^') {
            ++i;
        }
        while (i < trilha1.length()) {
            if (trilha1.charAt(i) != '^') {
                ++tamanhoPan;
            } else {
                encontrouDelimitador = true;
                break;
            }
            ++i;
        }
        return encontrouDelimitador ? tamanhoPan > 12 : trilha1.length() > 12;
    }

    private boolean isTrilha2PermiteComunicacaoSegura(String trilha2) {
        int tamanhoPan = 0;
        boolean encontrouDelimitador = false;
        for (int i = 0; i < trilha2.length(); ++i) {
            if (trilha2.charAt(i) != '=') {
                ++tamanhoPan;
                continue;
            }
            encontrouDelimitador = true;
            break;
        }
        return encontrouDelimitador ? tamanhoPan > 12 : trilha2.length() > 12;
    }

    private boolean isPanPermiteComunicacaoSegura(String pan) {
        return pan != null && pan.length() > 12;
    }

    private void setCodigoTransacaoRetorno(String codigoTransacaoRetorno) {
        this.codigoTransacaoRetorno = codigoTransacaoRetorno;
    }

    protected String getCodigoTransacaoRetorno() {
        return this.codigoTransacaoRetorno;
    }

    protected int getTimeout1F() {
        if (this.confCTFClient != null && this.confCTFClient.getTimeOutDefault() > 0) {
            return this.confCTFClient.getTimeOutDefault();
        }
        return 15;
    }

    protected boolean isResetCartaoAposErroRetornoCTF() {
        return true;
    }

    private String capturaKsnDukpt(int algoritmo, int indiceMasterKey, PinEMV pinpad) {
        try {
            String ksn = pinpad.getDUKPT(algoritmo, indiceMasterKey);
            return ksn;
        }
        catch (ExcecaoPerifericos e) {
            this.logger.log("WARN", "Erro ao tentar capturar o KSN DUKPT DES/3DES, algoritmo " + algoritmo + ", \u00edndice: " + indiceMasterKey + ". Desc: " + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(HexaUtil.toEBCDICHex("455182"));
        System.out.println(HexaUtil.toEBCDICHex("455182 "));
        System.out.println(HexaUtil.toEBCDICHex("455182F"));
        System.out.println(HexaUtil.toEBCDICHex("455182FF"));
        System.out.println(HexaUtil.toEBCDICHex("99770500001011=3"));
    }
}

