/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public abstract class MicAbstractSolicitacaoTEF {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    protected abstract String getCodigoTransacao(Process var1) throws IllegalStateException;

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        this.initEntradaApiTefC(entradaApiTefC, dados);
        this.montaDisplay(dados);
        SaidaApiTefC saidaApiTefC = this.solicitaTEF(entradaApiTefC, dados);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        return this.testaRetorno(saidaApiTefC, dados);
    }

    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) throws ExcecaoApiAc {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        String operacao = this.getCodigoTransacao(dados);
        entradaApiTefC.setOperacao(operacao);
        this.logger.debug("initEntradaApiTefC:operacao=" + operacao);
        if (saidaApiTefC != null) {
            entradaApiTefC.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            this.logger.debug("initEntradaApiTefC:timeout-ctf=" + saidaApiTefC.getTimeOutCTF());
        }
    }

    private SaidaApiTefC solicitaTEF(EntradaApiTefC entradaApiTefC, Process dados) {
        Apitef apitef = dados.getApitef();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        return apitef.solicitacao(ident, entradaApiTefC);
    }

    private void montaDisplay(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !saidaApiTefC.isReenvioNegadaHost()) {
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutDisplay display = new LayoutDisplay();
            display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            display.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            perifericos.imprimeDisplay(display);
        }
    }

    protected String testaRetorno(SaidaApiTefC saidaApiTefC, Process dados) {
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getRetorno() != 0) {
                this.logger.log("INFO", "Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
                return ERRO;
            }
            VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
            return SUCESS;
        }
        return ERRO;
    }
}

