/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.TrataLegadoUtil;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;

public class MicAlterarValorDocumentoCorBan {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        BigDecimal valorDocumentoAtual = new BigDecimal(0);
        if (saida.getValorTransacao() != null && saida.getValorTransacao().doubleValue() > 0.0) {
            valorDocumentoAtual = saida.getValorTransacao();
            if (saida.isValorTotalJaCalculado()) {
                this.logger.log("INFO", "Calculando o valor do documento a partir do valor do CTF, valorTransacao: " + valorDocumentoAtual);
                if (saida.getValorDesconto() != null) {
                    valorDocumentoAtual = valorDocumentoAtual.add(saida.getValorDesconto());
                    this.logger.log("INFO", "desconto: " + saida.getValorDesconto());
                }
                if (saida.getValorAcrescimo() != null) {
                    valorDocumentoAtual = valorDocumentoAtual.subtract(saida.getValorAcrescimo());
                    this.logger.log("INFO", "acr\u00e9scimo: " + saida.getValorAcrescimo());
                }
            }
            this.logger.log("INFO", "Valor do documento calculado: " + valorDocumentoAtual);
            entrada.setValorDocumento(valorDocumentoAtual);
        } else if (entrada.getValorDocumento() != null && !saida.isDesconsiderarValorDocumentoCodigoBarras()) {
            valorDocumentoAtual = entrada.getValorDocumento();
        }
        if (saida == null || !saida.isPermiteAlteracaoValorCorban()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        BigDecimal novoValor = null;
        try {
            novoValor = this.solicitaValorUsuario(perifericos, valorDocumentoAtual);
        }
        catch (UserCancelException e) {
            return USER_CANCEL;
        }
        catch (invalidNumberException e) {
            return INVALID_NUMBER;
        }
        if (novoValor.equals(valorDocumentoAtual)) {
            this.logger.log("INFO", "Valor do documento n\u00e3o alterado");
        } else {
            this.logger.log("INFO", "Valor do documento alterado de '" + valorDocumentoAtual + "' para '" + novoValor + "'");
            entrada.setValorDocumento(novoValor);
            BigDecimal novoValorTransacao = novoValor;
            if (saida.isValorTotalJaCalculado()) {
                if (saida.getValorDesconto() != null) {
                    novoValorTransacao = novoValorTransacao.subtract(saida.getValorDesconto());
                }
                if (saida.getValorAcrescimo() != null) {
                    novoValorTransacao = novoValorTransacao.add(saida.getValorAcrescimo());
                }
                this.logger.log("INFO", "Novo Valor da transa\u00e7\u00e3o: '" + novoValorTransacao + "'");
            }
            saida.setValorTransacao(novoValorTransacao);
            TrataLegadoUtil.calculaValorTransacao(dados, novoValor);
        }
        return SUCCESS;
    }

    private BigDecimal solicitaValorUsuario(ControladorPerifericos perifericos, BigDecimal valorDefault) throws ExcecaoNaoLocal, UserCancelException, invalidNumberException {
        String valorDefaultString = "0000";
        if (!valorDefault.equals(new BigDecimal(0))) {
            valorDefaultString = valorDefault.multiply(new BigDecimal(100)).toString();
        }
        valorDefaultString = valorDefaultString.substring(0, valorDefaultString.length() - 3);
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALDOC_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DOCUMENTO, false, valorDefaultString, new long[]{1L});
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new UserCancelException();
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            throw new invalidNumberException();
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            throw new invalidNumberException();
        }
        valor = valor.movePointLeft(2);
        return valor;
    }

    class invalidNumberException
    extends Exception {
        private static final long serialVersionUID = 2L;

        invalidNumberException() {
        }
    }

    class userCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        userCancelException() {
        }
    }
}

