/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaBairro {
    public static final String SUCESS = "SUCESS";
    public static final String SUCCESS_BLANK = "SUCCESS_BLANK";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getBairro() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isBairroCtrl()) {
                entradaApiTefC.setBairro(Contexto.getContexto().getEntradaIntegracao().getBairro());
                return SUCESS;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                entradaApiTefC.setBairro("");
                return SUCCESS_BLANK;
            }
        }
        String valor = null;
        ControladorPerifericos periferico = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPBAI_TITLE")), ConstantesApiAc.CAP_BAIRRO_ENDERENCO);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        valor = eventoTeclado.getStringLida().substring(num).trim();
        entradaApiTefC.setBairro(valor);
        return SUCESS;
    }
}

