/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.BombaFusion;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.DadosPistaFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.List;

public class MicCapturaBombaCombustivel {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";

    public String execute(Process dados) throws ExcecaoApiAc {
        ILogger logger = CTFClientLogger.getCTFClient();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
            return UNECESSARY;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        dados.getPerifericos().imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPBOMCOM_TITLE"), true);
        StatusFusion pistaFusion = null;
        try {
            ProdutoConvenioCombustivel produto = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().get(0);
            pistaFusion = fusion.infoPista(produto.getCodigo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pistaFusion == null || pistaFusion.getResultado() != 0) {
            if (pistaFusion != null) {
                logger.log(ERROR, "Erro ao ler os produtos dispon\u00edveis para abastecimento, c\u00f3digo: " + pistaFusion.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        List bombas = ((DadosPistaFusion)pistaFusion).getBombas();
        for (int i = 0; i < bombas.size(); ++i) {
            BombaFusion bomba = (BombaFusion)bombas.get(i);
            layoutMenu.addItem(new ItemMenu("BOMBA " + bomba.getId(), i + 1 + ""));
        }
        boolean continuaCaptura = true;
        while (continuaCaptura) {
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            LayoutDisplay displayConfirmaProduto = new LayoutDisplay(2);
            displayConfirmaProduto.addLinha(new Linha("BOMBA " + ((BombaFusion)bombas.get(opcao - 1)).getId() + " SELECIONADA"));
            displayConfirmaProduto.addLinha(new Linha("CONFIRMA?"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayConfirmaProduto);
            continuaCaptura = !eventoTeclado.getTeclaFinalizadora().equals("ENTRA");
            Contexto.getContexto().getEntradaApiTefC().setBombaCombustivel((BombaFusion)bombas.get(opcao - 1));
        }
        return SUCCESS;
    }
}

