/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCep {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CEP_AC = "INVALID_CEP_AC";
    private static final String MSG_INVALID_CEP = "CEP INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCep() != null) {
            return FILLED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        boolean cepAlfa = false;
        if (saida != null) {
            cepAlfa = saida.isCapturaCepAlfa();
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isCepCtrl()) {
                entradaApiTefC.setCep(Contexto.getContexto().getEntradaIntegracao().getCep());
                return SUCESS;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5399, MSG_INVALID_CEP));
                return INVALID_CEP_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados != 8) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPCEP_TITLE"));
            ConstantesApiAc.TipoCampo mascara = null;
            mascara = cepAlfa ? ConstantesApiAc.CAP_CEP_ENDERENCO_ALFA : ConstantesApiAc.CAP_CEP_ENDERENCO;
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, mascara);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
            if (cepAlfa) continue;
            try {
                Integer.valueOf(valor);
            }
            catch (NumberFormatException e) {
                LayoutDisplay displayModelError = new LayoutDisplay(2);
                displayModelError.addLinha(new Linha(inter.getMessage("CAPCEP_ERROR")));
                periferico.confirmaDado(displayModelError);
                caracteresDigitados = 0;
                valor = "";
            }
        }
        entradaApiTefC.setCep(valor);
        return SUCESS;
    }
}

