/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.DadosConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.Iterator;
import java.util.List;

public class MicCapturaConfirmacaoPositiva {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String FILLED = "FILLED";
    public static final String ERRO = "ERRO";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (entradaApiTefC.getConfirmacaoPositiva() != null && entradaApiTefC.getConfirmacaoPositiva().getPinCriptogravado() != null) {
            return FILLED;
        }
        DadosConfirmacaoPositiva dadosConfirmacaoPositiva = saida.getConfirmacaoPositiva();
        List<ConfirmacaoPositiva> listConfirmacaoPositiva = dadosConfirmacaoPositiva.getListConfirmacaoPositiva();
        Iterator<ConfirmacaoPositiva> iterator = listConfirmacaoPositiva.iterator();
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[listConfirmacaoPositiva.size()];
        int iConfirmacaoPositiva = 0;
        while (iterator.hasNext()) {
            ConfirmacaoPositiva confirmacaoPositiva = iterator.next();
            dadoSolicitaPins[iConfirmacaoPositiva] = new DadoSolicitaPin(confirmacaoPositiva.getTamanhoMinimo(), confirmacaoPositiva.getTamanhoMaximo(), confirmacaoPositiva.getPrompt());
            ++iConfirmacaoPositiva;
        }
        if (listConfirmacaoPositiva.size() > 0) {
            Criptografia criptografia = null;
            TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, registroCriptografia.isIndiceAuttar());
            ProcessManager processManager = ProcessManager.getInstance();
            boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
            PinInfo pinInfoSenha = Contexto.getContexto().getPinInfo();
            if (dadosConfirmacaoPositiva.getVersao() == 1) {
                String numeroSerieChaveDUKPT = null;
                for (int i = 0; i < dadoSolicitaPins.length; ++i) {
                    DadoSolicitaPin dadoSolicitaPin = dadoSolicitaPins[i];
                    DadoSolicitaPin[] solicitaPin = new DadoSolicitaPin[]{dadoSolicitaPin};
                    ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, solicitaPin, false, possuiChaveContingencia);
                    processLeituraPin.setActiveDialogUserCancel(false);
                    processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao().trim());
                    try {
                        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                        if (processLeituraPin.getState() == 3) {
                            return USER_CANCEL;
                        }
                        if (processLeituraPin.getState() == 5) {
                            return USER_CANCEL_INTERNAL;
                        }
                        if (processLeituraPin.getState() == 1) {
                            if (processLeituraPin.isUtilizarChaveContingencia()) {
                                return "RERUN";
                            }
                            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                            return ERRO;
                        }
                        PinInfo pinInfo = Contexto.getContexto().getPinInfo();
                        if (dadosConfirmacaoPositiva.getPinCriptogravado() == null) {
                            dadosConfirmacaoPositiva.setPinCriptogravado(pinInfo.getPinCriptografado());
                        } else {
                            String pinCriptografado = dadosConfirmacaoPositiva.getPinCriptogravado();
                            if (i < listConfirmacaoPositiva.size()) {
                                pinCriptografado = pinCriptografado + "#";
                            }
                            pinCriptografado = pinCriptografado + pinInfo.getPinCriptografado();
                            dadosConfirmacaoPositiva.setPinCriptogravado(pinCriptografado);
                        }
                        numeroSerieChaveDUKPT = pinInfo.getNumeroSerieChaveDUKPT();
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log("ERROR", e.getMessage(), e);
                        if (Contexto.getContexto().getErroIntegracao() == null) {
                            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
                        }
                        return ERRO;
                    }
                }
                dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(numeroSerieChaveDUKPT);
                entradaApiTefC.setConfirmacaoPositiva(dadosConfirmacaoPositiva);
            } else {
                ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, dadoSolicitaPins, false, possuiChaveContingencia);
                processLeituraPin.setActiveDialogUserCancel(false);
                processLeituraPin.setTituloAguardaPin(listConfirmacaoPositiva.get(0).getPrompt().trim());
                try {
                    processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                    if (processLeituraPin.getState() == 3) {
                        return USER_CANCEL;
                    }
                    if (processLeituraPin.getState() == 5) {
                        return USER_CANCEL_INTERNAL;
                    }
                    if (processLeituraPin.getState() == 1) {
                        if (processLeituraPin.isUtilizarChaveContingencia()) {
                            return "RERUN";
                        }
                        Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                        return ERRO;
                    }
                    PinInfo pinInfo = Contexto.getContexto().getPinInfo();
                    dadosConfirmacaoPositiva.setPinCriptogravado(pinInfo.getPinCriptografado());
                    dadosConfirmacaoPositiva.setNumeroSerieChaveDUKPTConfirmacaoPositiva(pinInfo.getNumeroSerieChaveDUKPT());
                    entradaApiTefC.setConfirmacaoPositiva(dadosConfirmacaoPositiva);
                }
                catch (Exception e) {
                    this.logger.log("ERROR", e.getMessage(), e);
                    if (Contexto.getContexto().getErroIntegracao() == null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
                    }
                    return ERRO;
                }
            }
            Contexto.getContexto().setPinInfo(pinInfoSenha);
            return SUCESS;
        }
        return NOT_REQUIRED;
    }
}

