/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.CpfUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCpf {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CPF = "INVALID_CPF";
    public static final String INVALID_CPF_AC = "INVALID_CPF_AC";
    private static final String MSG_INVALID_CPF = "CPF INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !saidaApiTefC.isCapturaCPF()) {
            return UNECESSARY;
        }
        if (entradaApiTefC.getCpf() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isDocumentoCtrl() && entradaIntegracao.isTipoDocumentoCtrl() && entradaIntegracao.getTipoDocumento() == 2) {
                String cpf = entradaIntegracao.getDocumento();
                if (CpfUtil.validaCpf(cpf)) {
                    entradaApiTefC.setCpf(cpf);
                    return SUCCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5318, inter.getMessage("CAPCPF_INVALID_CPF")));
                return INVALID_CPF_AC;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5318, MSG_INVALID_CPF));
                return INVALID_CPF_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados != 11) {
            displayModel = new LayoutDisplay(inter.getMessage("CAPCPF_TITLE"));
            eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_CPF);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
        if (CpfUtil.validaCpf(valor)) {
            entradaApiTefC.setCpf(valor);
            return SUCCESS;
        }
        displayModel = new LayoutDisplay(inter.getMessage("CAPCPF_INVALID_CPF"));
        eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return INVALID_CPF;
        }
        return USER_CANCEL;
    }
}

