/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicCapturaData1Parcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    public static final String INVALID_DATE_AC = "INVALID_DATE_AC";
    public static final String EXCEDE_PRAZO = "EXCEDE_PRAZO";
    public static final String EXCEDE_PRAZO_AC = "EXCEDE_PRAZO_AC";

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (!saidaApiTefC.isData1Parcela()) {
            entradaApiTefC.setDataVencimento(new Date());
            return UNECESSARY;
        }
        if (entradaApiTefC.getDataVencimento() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && this.isValida1ParcelaCancelamento(entradaIntegracao)) {
            if (entradaIntegracao.isDataReferenciaCtrl()) {
                int operacao = entradaIntegracao.getOperacao();
                if (this.isTransacaoComParcAvista(operacao)) {
                    if (!DateUtil.equalsData(entradaIntegracao.getDataReferencia(), dados.getStartProcess())) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDAT1PAR_INVALID_DATE")));
                        return INVALID_DATE_AC;
                    }
                } else if (!this.isTransacaoComParcAvista(operacao) && DateUtil.equalsData(entradaIntegracao.getDataReferencia(), dados.getStartProcess())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5313, inter.getMessage("CAPDAT1PAR_INVALID_DATE")));
                    return INVALID_DATE_AC;
                }
                if (!this.isData1ParcelaValida(dados.getStartProcess(), entradaIntegracao.getDataReferencia())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5314, inter.getMessage("CAPDAT1PAR_EXCEDE_PRAZO")));
                    return EXCEDE_PRAZO_AC;
                }
                entradaApiTefC.setDataVencimento(entradaIntegracao.getDataReferencia());
                return SUCESS;
            }
            if (this.isData1ParcelaObrigarotoria(entradaIntegracao.getOperacao()) && this.isTransacaoComParcAvista(entradaIntegracao.getOperacao())) {
                entradaApiTefC.setDataVencimento(new Date());
                return SUCESS;
            }
        }
        String dataDigitada = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPDAT1PAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_1_PARCELA, 0, true, 10, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            dataDigitada = eventoTeclado.getStringLida().substring(0, num);
            if (dataDigitada.length() == 6) {
                tamanhoInvalido = false;
                continue;
            }
            if (dataDigitada.length() != 0) continue;
            if (Contexto.getContexto().getPlano() == Plano.CREDIARIO || Contexto.getContexto().getPlano() == Plano.CDC && saidaApiTefC != null && saidaApiTefC.isData1ParcelaObrigatoria()) {
                this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE"));
                continue;
            }
            tamanhoInvalido = false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
            df.setLenient(false);
            if (dataDigitada.equals("")) {
                entradaApiTefC.setDataVencimento(new Date());
            } else {
                entradaApiTefC.setDataVencimento(df.parse(dataDigitada));
            }
            if (entradaIntegracao != null && !this.isValida1ParcelaCancelamento(entradaIntegracao) && entradaApiTefC.getDataVencimento().compareTo(entradaApiTefC.getDataTransacao()) == -1) {
                if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE")).equals("ENTRA")) {
                    entradaApiTefC.setDataVencimento(null);
                    return INVALID_DATE;
                }
                return USERCANCEL;
            }
            if (!this.isData1ParcelaValida(dados.getStartProcess())) {
                if (this.exibeMensagemPrazoExcedido(perifericos, inter.getMessage("CAPDAT1PAR_EXCEDE_PRAZO")).equals("ENTRA")) {
                    entradaApiTefC.setDataVencimento(null);
                    return EXCEDE_PRAZO;
                }
                return USERCANCEL;
            }
        }
        catch (Exception e) {
            if (this.exibeMensagemDataInvalida(perifericos, inter.getMessage("CAPDAT1PAR_INVALID_DATE")).equals("ENTRA")) {
                entradaApiTefC.setDataVencimento(null);
                return INVALID_DATE;
            }
            return USERCANCEL;
        }
        return SUCESS;
    }

    private String exibeMensagemPrazoExcedido(ControladorPerifericos perifericos, String msgExcedePrazo) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgExcedePrazo);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private String exibeMensagemDataInvalida(ControladorPerifericos perifericos, String msgInvalidDate) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgInvalidDate);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isData1ParcelaObrigarotoria(int operacao) {
        if (operacao == 222) {
            return false;
        }
        return operacao != 406 && operacao != 405 && operacao != 900 && operacao != 109 && operacao != 111 && operacao != 267;
    }

    private boolean isTransacaoComParcAvista(int operacao) {
        if (operacao == 105 || operacao == 108 || operacao == 110) {
            return true;
        }
        if (operacao == 104 || operacao == 109 || operacao == 111) {
            return false;
        }
        return false;
    }

    private boolean isValida1ParcelaCancelamento(EntradaCTFClientCtrl entradaIntegracao) {
        return entradaIntegracao.getOperacao() != 128 && entradaIntegracao.getOperacao() != 411;
    }

    public boolean isData1ParcelaValida(Date nowDate, Date data1Parcela) {
        try {
            SimpleDateFormat nowFormat = new SimpleDateFormat("ddMMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            data1Parcela = nowFormat.parse(nowFormat.format(data1Parcela));
            if (data1Parcela.before(nowDate)) {
                return false;
            }
            int prazoAgendamentoDia = Contexto.getContexto().getSaidaApiTefC().getMaximoDiasCDC();
            GregorianCalendar calender = new GregorianCalendar();
            calender.setTime(nowDate);
            if (prazoAgendamentoDia >= 0) {
                calender.add(5, prazoAgendamentoDia);
                return !data1Parcela.after(calender.getTime());
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isData1ParcelaValida(Date nowDate) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        Date nowDateSemHora = null;
        try {
            nowDateSemHora = this.removerHora(nowDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (entradaApiTefC.getDataVencimento().before(nowDateSemHora)) {
            return false;
        }
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(nowDate);
        if (saidaApiTefC.getMaximoDiasCDC() >= 0) {
            calender.add(5, saidaApiTefC.getMaximoDiasCDC());
            return !entradaApiTefC.getDataVencimento().after(calender.getTime());
        }
        if (saidaApiTefC.getMaximoMesesAgendamento() >= 0) {
            calender.add(2, saidaApiTefC.getMaximoMesesAgendamento());
            return !entradaApiTefC.getDataVencimento().after(calender.getTime());
        }
        return true;
    }

    private Date removerHora(Date nowDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        df.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        String dayString = null;
        String monthString = null;
        dayString = day < 10 ? "0" + day : String.valueOf(day);
        monthString = month < 10 ? "0" + month : String.valueOf(month);
        return df.parse(dayString + monthString + year);
    }
}

