/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.InformacoesAdicionais;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.util.CpfUtil;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class MicCapturaInformacoesAdicionais {
    public static final String SUCESS = "SUCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String ZERO_LENGTH = "ZERO_LENGTH";
    private static final String TECLA_VOLTA = "TECLA_VOLTA";
    private static ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        String dadoDigitado = "";
        String dadoDigitadoConfirmacao = "";
        ControladorPerifericos perifericos = dados.getPerifericos();
        List listInformacoesAdicionais = this.getListInformacoesAdicionaisSaida();
        int ordemCaptura = Contexto.getContexto().getOrdemCapturaInformacaoAdicional();
        listInformacoesAdicionais = this.filtrarListPorOrdemCaptura(listInformacoesAdicionais, ordemCaptura);
        for (InformacoesAdicionais informacoesAdicionais : listInformacoesAdicionais) {
            if (this.getListInformacoesAdicionaisEntrada() != null && this.getListInformacoesAdicionaisEntrada().size() > 0 && this.getListInformacoesAdicionaisEntrada().contains(informacoesAdicionais)) {
                logger.log("INFO", "Informa\u00e7\u00e3o j\u00e1 capturada: Tabela: " + informacoesAdicionais.getCodigoTabela() + ", grupo: " + informacoesAdicionais.getCodigoGrupo() + ", Informa\u00e7\u00e3o: " + informacoesAdicionais.getCodigoInformacao() + ", Descri\u00e7\u00e3o: " + informacoesAdicionais.getMensagemDisplay());
                continue;
            }
            dadoDigitado = "";
            dadoDigitadoConfirmacao = "";
            boolean continuaLendo = true;
            while (continuaLendo) {
                try {
                    dadoDigitado = this.capturaDadoAdicional(perifericos, informacoesAdicionais, dados);
                    if (dadoDigitado.equals(USER_CANCEL)) {
                        return USER_CANCEL;
                    }
                    if (dadoDigitado.equals(USER_CANCEL_INTERNAL)) {
                        return USER_CANCEL_INTERNAL;
                    }
                    if (informacoesAdicionais.isDuplaDigitacao() && !dadoDigitado.equals(dadoDigitadoConfirmacao = this.capturaDadoAdicional(perifericos, informacoesAdicionais, dados))) {
                        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPINFADI_INVALID_DATA"), 1500L);
                        perifericos.imprimeDisplay(displayModel);
                        continuaLendo = true;
                        continue;
                    }
                    informacoesAdicionais.setTamanhoInformacaoAdicional(dadoDigitado.length());
                    informacoesAdicionais.setMensagemInformacaoAdicional(dadoDigitado);
                    continuaLendo = false;
                }
                catch (InformacaoInvalidaException e) {
                    LayoutDisplay displayModel = new LayoutDisplay(e.getMensagemDisplay(), 1500L);
                    perifericos.imprimeDisplay(displayModel);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().equals(ZERO_LENGTH)) {
                        if (informacoesAdicionais.getTamanhoMinimo() == 0) {
                            informacoesAdicionais.setTamanhoInformacaoAdicional(0);
                            informacoesAdicionais.setMensagemInformacaoAdicional("");
                            continuaLendo = false;
                            continue;
                        }
                    } else if (e.getMessage().equals(TECLA_VOLTA)) {
                        return USER_CANCEL;
                    }
                    continuaLendo = true;
                }
            }
        }
        if (this.getListInformacoesAdicionaisEntrada() != null && this.getListInformacoesAdicionaisEntrada().size() > 0) {
            this.getListInformacoesAdicionaisEntrada().addAll(listInformacoesAdicionais);
        } else {
            this.setListInformacoesAdicionaisEntrada(listInformacoesAdicionais);
        }
        if (listInformacoesAdicionais.size() > 0) {
            return SUCESS;
        }
        return NOT_REQUIRED;
    }

    private String capturaDadoAdicional(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais, Process dados) throws IllegalArgumentException, ExcecaoNaoLocal {
        String mascaraTamanhoMaximo;
        LayoutDisplay displayModel;
        EventoTeclado eventoTeclado = null;
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_BOOLEANO)) {
            LayoutMenu menu = new LayoutMenu(informacoesAdicionais.getMensagemDisplay(), true);
            menu.addItem(new ItemMenu("SIM", "1"));
            menu.addItem(new ItemMenu("NAO", "2"));
            int resultado = perifericos.imprimeMenu(menu);
            switch (resultado) {
                case -1: {
                    return USER_CANCEL;
                }
                case 1: {
                    return "1";
                }
                case 2: {
                    return "0";
                }
            }
            return ERROR;
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_MENU_SELECAO)) {
            try {
                return this.capturaDadoAdicionalMenuSelecao(perifericos, informacoesAdicionais);
            }
            catch (UserCancelException e) {
                return USER_CANCEL;
            }
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_PINPAD)) {
            try {
                return this.capturaDadoAdicionalPinpad(perifericos, informacoesAdicionais, dados);
            }
            catch (UserCancelException e) {
                return USER_CANCEL_INTERNAL;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ERROR;
            }
        }
        ConstantesApiAc.TipoCampo tipoCampo = null;
        String tituloCaptura = "";
        Object opcoesMenu = null;
        if (informacoesAdicionais.getMensagemDisplay().indexOf("#") > 0) {
            String[] linhasSplit;
            ArrayList<Linha> titulosDisplay = new ArrayList<Linha>();
            for (String linhaString : linhasSplit = informacoesAdicionais.getMensagemDisplay().split("#")) {
                titulosDisplay.add(new Linha(linhaString));
            }
            displayModel = new LayoutDisplay(titulosDisplay);
        } else {
            displayModel = new LayoutDisplay(informacoesAdicionais.getMensagemDisplay());
        }
        boolean mascaraSenha = false;
        ConstantesApiAc.TipoCampo mascara = ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS;
        if (informacoesAdicionais.getTamanhoMinimo() == 0 && informacoesAdicionais.getTamanhoMaximo() == 0) {
            mascara = ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS_VAZIA;
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo()));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_INTEIRO) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_KEYBOARD_POS)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("Z", informacoesAdicionais.getTamanhoMaximo(), 'Z', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "99//99//9999");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#D9#D9//#M9#M9//#A9#A9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#D9#D9//#M9#M9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "#M9#M9//#A9#A9");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_ALFA_NUMERICO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("@", informacoesAdicionais.getTamanhoMaximo(), '@', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_ALFA_NUMERICO_SIMBOLO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("&", informacoesAdicionais.getTamanhoMaximo(), '&', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_NUMERICO_TRES_CASAS_DECIMAIS)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), this.getMascaraNumerico(informacoesAdicionais.getTamanhoMaximo(), 3));
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_CPF)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "ZZZ.ZZZ.ZZZ-ZZ");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_TELEFONE)) {
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), "(ZZ)ZZZZ-ZZZZZ");
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_INTEIRO_MASCARADO)) {
            mascaraTamanhoMaximo = "";
            if (informacoesAdicionais.getTamanhoMaximo() > 0) {
                mascaraTamanhoMaximo = StringUtil.completaString("Z", informacoesAdicionais.getTamanhoMaximo(), 'Z', 4);
            }
            tipoCampo = new ConstantesApiAc.TipoCampo(mascara.getCodigo(), mascara.getDescricao(), mascaraTamanhoMaximo);
            mascaraSenha = true;
        }
        eventoTeclado = tipoCampo != null ? (EventoTeclado)perifericos.capturaDado(displayModel, tipoCampo, true, mascaraSenha) : (EventoTeclado)perifericos.capturaDado(displayModel, mascara, informacoesAdicionais.getTamanhoMaximo());
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new IllegalArgumentException(TECLA_VOLTA);
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String dadoDigitado = eventoTeclado.getStringLida().substring(num);
        this.validaInformacoesAdicionais(informacoesAdicionais, dadoDigitado);
        return dadoDigitado;
    }

    private void validaInformacoesAdicionais(InformacoesAdicionais informacoesAdicionais, String dadoDigitado) {
        if (dadoDigitado.equals("")) {
            throw new IllegalArgumentException(ZERO_LENGTH);
        }
        if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM) || informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA)) {
            boolean dataValida = false;
            SimpleDateFormat df = null;
            df = informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM_AA) ? new SimpleDateFormat("ddMMyy") : (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_DD_MM) ? new SimpleDateFormat("ddMM") : (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_DATA_MM_AA) ? new SimpleDateFormat("MMyy") : new SimpleDateFormat("ddMMyyyy")));
            df.setLenient(false);
            try {
                df.parse(dadoDigitado);
                dataValida = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!dataValida) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage("CAPINFADI_INVALID_DATE"));
                throw e;
            }
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_CPF)) {
            if (!CpfUtil.validaCpf(dadoDigitado)) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage("CAPINFADI_INVALID_CPF"));
                throw e;
            }
        } else if (informacoesAdicionais.getTipoCaptura().equals(InformacoesAdicionais.TIPO_TELEFONE)) {
            if (dadoDigitado.length() < 10 || dadoDigitado.length() > 11) {
                InformacaoInvalidaException e = new InformacaoInvalidaException();
                e.setMensagemDisplay(this.inter.getMessage("CAPINFADI_INVALID_TELEPHONE"));
                throw e;
            }
        } else if (dadoDigitado.length() < informacoesAdicionais.getTamanhoMinimo()) {
            InformacaoInvalidaException e = new InformacaoInvalidaException();
            e.setMensagemDisplay(this.inter.getMessage("CAPINFADI_INVALID_SIZE"));
            throw e;
        }
    }

    private String getMascaraNumerico(int tamanho, int precisaoDecimal) {
        if (tamanho == 0) {
            return "Z.ZZZ.ZZZ.ZZ9,99";
        }
        if (precisaoDecimal == 0) {
            precisaoDecimal = 2;
        }
        String mascaraTemp = "";
        for (int i = 0; i < tamanho; ++i) {
            if (i < precisaoDecimal + 1) {
                if (i == precisaoDecimal) {
                    mascaraTemp = "," + mascaraTemp;
                }
                mascaraTemp = "9" + mascaraTemp;
                continue;
            }
            if ((i - precisaoDecimal) % 3 == 0) {
                mascaraTemp = "." + mascaraTemp;
            }
            mascaraTemp = "Z" + mascaraTemp;
        }
        return mascaraTemp.toString();
    }

    private String getMascaraNumerico(int tamanho) {
        return this.getMascaraNumerico(tamanho, 2);
    }

    private List filtrarListPorOrdemCaptura(List listOriginal, int ordemCaptura) {
        if (ordemCaptura == 0) {
            return listOriginal;
        }
        ArrayList<InformacoesAdicionais> listNova = new ArrayList<InformacoesAdicionais>();
        for (InformacoesAdicionais infoAdic : listOriginal) {
            if (infoAdic.getOrdemCaptura() != ordemCaptura) continue;
            listNova.add(infoAdic);
        }
        return listNova;
    }

    protected List getListInformacoesAdicionaisSaida() {
        return Contexto.getContexto().getSaidaApiTefC().getInformacoesAdicionais();
    }

    protected List getListInformacoesAdicionaisEntrada() {
        return Contexto.getContexto().getEntradaApiTefC().getInformacoesAdicionais();
    }

    protected void setListInformacoesAdicionaisEntrada(List listInformacoesAdicionais) {
        Contexto.getContexto().getEntradaApiTefC().setInformacoesAdicionais(listInformacoesAdicionais);
    }

    private String capturaDadoAdicionalMenuSelecao(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais) throws ExcecaoNaoLocal, UserCancelException {
        int posPrimeiroDelimitador = informacoesAdicionais.getMensagemDisplay().indexOf("@");
        String tituloCaptura = "";
        String[] opcoesMenu = null;
        if (posPrimeiroDelimitador > 0) {
            tituloCaptura = informacoesAdicionais.getMensagemDisplay().substring(0, posPrimeiroDelimitador).trim();
            opcoesMenu = informacoesAdicionais.getMensagemDisplay().substring(posPrimeiroDelimitador + 1).split("@");
        }
        if (posPrimeiroDelimitador == 0 || opcoesMenu == null || opcoesMenu.length == 0) {
            logger.log(ERROR, "Erro ao capturar o menu de sele\u00e7\u00e3o nas informa\u00e7\u00f5es adicionais pois o menu \u00e9 inv\u00e1lido ou vazio.");
            throw new IllegalArgumentException("Lista de operadoras nula");
        }
        LayoutMenu layoutMenu = new LayoutMenu(tituloCaptura, true);
        for (int i = 0; i < opcoesMenu.length; ++i) {
            layoutMenu.addItem(new ItemMenu(opcoesMenu[i].substring(2).trim(), String.valueOf(i + 1)));
        }
        int opcaoSelecionada = perifericos.imprimeMenu(layoutMenu);
        if (opcaoSelecionada == -1) {
            throw new UserCancelException();
        }
        return opcoesMenu[opcaoSelecionada - 1].substring(0, 2);
    }

    private String capturaDadoAdicionalPinpad(ControladorPerifericos perifericos, InformacoesAdicionais informacoesAdicionais, Process dados) throws Exception {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[]{new DadoSolicitaPin(informacoesAdicionais.getTamanhoMinimo(), informacoesAdicionais.getTamanhoMaximo(), informacoesAdicionais.getMensagemDisplay())};
        Criptografia criptografia = null;
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey() & 0xF;
        criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey, registroCriptografia.isIndiceAuttar());
        ProcessManager processManager = ProcessManager.getInstance();
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        PinInfo pinInfoAnterior = Contexto.getContexto().getPinInfo();
        Object numeroSerieChaveDUKPT = null;
        DadoSolicitaPin dadoSolicitaPin = dadoSolicitaPins[0];
        DadoSolicitaPin[] solicitaPin = new DadoSolicitaPin[]{dadoSolicitaPin};
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(criptografia, solicitaPin, false, possuiChaveContingencia);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao().trim());
        PinInfo pinInfo = null;
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3) {
                throw new UserCancelException();
            }
            if (processLeituraPin.getState() == 5) {
                throw new UserCancelException();
            }
            if (processLeituraPin.getState() == 1) {
                Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
                return null;
            }
            pinInfo = Contexto.getContexto().getPinInfo();
        }
        catch (UserCancelException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(ERROR, e.getMessage(), e);
            throw e;
        }
        Contexto.getContexto().setPinInfo(pinInfoAnterior);
        return pinInfo.getPinCriptografado();
    }

    public static void main(String[] args) {
        MicCapturaInformacoesAdicionais d = new MicCapturaInformacoesAdicionais();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMM");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse("1312");
            System.out.println("OK");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(d.getMascaraNumerico(12));
        for (int i = 0; i < 100; ++i) {
            System.out.println(d.getMascaraNumerico(i));
        }
    }

    private class InformacaoInvalidaException
    extends IllegalArgumentException {
        private String mensagemDisplay;

        private InformacaoInvalidaException() {
        }

        public String getMensagemDisplay() {
            return this.mensagemDisplay;
        }

        public void setMensagemDisplay(String mensagemDisplay) {
            this.mensagemDisplay = mensagemDisplay;
        }
    }
}

