/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.model.Operadora;
import com.csi.ctfclient.apitef.model.OperadoraValeGas;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.Iterator;
import java.util.List;

public class MicCapturaOperadoraValeGas {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        IdentApiTefC identApiTefC;
        IdentTerminal identTerminal;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCodigoAutorizadora() != null) {
            return FILLED;
        }
        DadosPersistencia dadosPersistencia = null;
        ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
        dadosPersistencia = controladorPersistencia.getDadosPersistencia(identTerminal = new IdentTerminal((identApiTefC = Contexto.getContexto().getIdentApiTefC()).getNumeroEstabelecimento(), identApiTefC.getNumeroLoja(), identApiTefC.getNumeroPdv()));
        List listOperadoras = (List)dadosPersistencia.getListOperadorasValeGas().getDado();
        if (listOperadoras == null || listOperadoras.isEmpty()) {
            this.logger.log("ERROR", "Erro ao capturar as operadoras de vale g\u00e1s, lista de operadoras nula ou vazia.");
            throw new IllegalArgumentException("Lista de operadoras nula");
        }
        if (listOperadoras.size() == 1) {
            entradaApiTefC.setOperadoraValeGas(new OperadoraValeGas((Operadora)listOperadoras.get(0)));
            return SUCCESS;
        }
        Iterator ite = listOperadoras.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPOPEVALGAS_TITLE"), true);
        Operadora[] arrayOperadoraTecla = new Operadora[listOperadoras.size()];
        int iTecla = 0;
        while (ite.hasNext()) {
            Operadora ope;
            arrayOperadoraTecla[iTecla] = ope = (Operadora)ite.next();
            layoutMenu.addItem(new ItemMenu(ope.getNome(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        entradaApiTefC.setOperadoraValeGas(new OperadoraValeGas(arrayOperadoraTecla[opcao - 1]));
        return SUCCESS;
    }
}

