/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.List;

public class MicCapturaQuantidadeAuto {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        List<ProdutoConvenioCombustivel> listProdutoConvenioCombustivel = entrada.getListProdutoConvenioCombustivel();
        ProdutoConvenioCombustivel produtoConvenioCombustivel = listProdutoConvenioCombustivel.get(listProdutoConvenioCombustivel.size() - 1);
        if (!produtoConvenioCombustivel.isCapturaQuantidade()) {
            return UNECESSARY;
        }
        if (produtoConvenioCombustivel.getQuantidade() != null && produtoConvenioCombustivel.getQuantidade().compareTo(new BigDecimal(0)) == 0) {
            return FILLED;
        }
        return this.capturaValor(perifericos, produtoConvenioCombustivel, entrada);
    }

    private String capturaValor(ControladorPerifericos perifericos, ProdutoConvenioCombustivel produtoConvenioCombustivel, EntradaApiTefC entrada) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAP_QUAAUT_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_QUANTIDADE_AUTO, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valorQuantidade = new BigDecimal(digitos);
        valorQuantidade = valorQuantidade.movePointLeft(2);
        produtoConvenioCombustivel.setQuantidade(valorQuantidade);
        int versaoProdutos = 0;
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            versaoProdutos = Contexto.getContexto().getSaidaApiTefC().getVersaoListaProdutosConvenioCombustivel();
        }
        entrada.refreshListProdutoConvenioCombustivel(versaoProdutos);
        return SUCCESS;
    }
}

