/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoImpressao {
    public static final String FILLED = "FILLED";
    public static final String ULTIMO_COMPROVANTE = "ULTIMO_COMPROVANTE";
    public static final String COMPROVANTE_ESPECIFICO = "OUTRO_COMPROVANTE";
    public static final String USERCANCEL = "USERCANCEL";

    public String execute(Process dado) throws ExcecaoNaoLocal, ExcecaoPerifericos {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getTipoImpressao() != 0) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            int operacao = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            if (operacao == 229) {
                return COMPROVANTE_ESPECIFICO;
            }
            return ULTIMO_COMPROVANTE;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPIMP_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPIMP_ULTIMO_COMPROVANTE"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPIMP_OUTRO_COMPROVANTE"), "2"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USERCANCEL;
        }
        Contexto.getContexto().setTipoImpressao(opcao);
        switch (opcao) {
            case 1: {
                return ULTIMO_COMPROVANTE;
            }
            case 2: {
                return COMPROVANTE_ESPECIFICO;
            }
        }
        return USERCANCEL;
    }
}

