/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicCapturaValorDesconto {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        BigDecimal valorDesconto = new BigDecimal(0);
        boolean capturaEncargos = true;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null) {
            if (saida.getValorDesconto() != null) {
                valorDesconto = saida.getValorDesconto();
            }
            if (!saida.isCapturaDesconto()) {
                this.logger.log("INFO", "Assumindo o desconto retornado pela consulta");
                entradaApiTefC.setValorDesconto(valorDesconto);
                return UNECESSARY;
            }
            if (entradaApiTefC.getValorDesconto() != null) {
                return SUCCESS;
            }
        } else {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (!conf.isCapturaEncargosCCB()) {
                capturaEncargos = false;
            }
        }
        if (entradaApiTefC.getValorDesconto() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorDescontoCtrl()) {
            this.logger.log("INFO", "Assumindo o desconto informado pela AC");
            entradaApiTefC.setValorDesconto(Contexto.getContexto().getEntradaIntegracao().getValorDesconto());
            return SUCCESS;
        }
        if (capturaEncargos) {
            return this.capturaValor(valorDesconto, perifericos);
        }
        this.logger.log("INFO", "CTFClient configurado para n\u00e3o capturar engargos para CCB");
        return UNECESSARY;
    }

    private String capturaValor(BigDecimal valorDefault, ControladorPerifericos perifericos) throws ExcecaoApiAc {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        String valor = decimalFormat.format(valorDefault.multiply(new BigDecimal(100)));
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALDES_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DESCONTO, valor, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valorDesconto = new BigDecimal(digitos);
        valorDesconto = valorDesconto.movePointLeft(2);
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        entradaApiTefC.setValorDesconto(valorDesconto);
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null && saida.getValorTransacao() != null && saida.isValorTotalJaCalculado() && !valorDefault.equals(valorDesconto)) {
            BigDecimal valorTransacao = saida.getValorTransacao();
            valorTransacao = valorTransacao.subtract(valorDesconto.subtract(valorDefault));
            if (!saida.getValorTransacao().equals(new BigDecimal(0)) && !valorTransacao.equals(new BigDecimal(0)) && valorTransacao.compareTo(new BigDecimal(0)) <= 0) {
                this.logger.log("ERROR", "Valor do desconto maior que o valor da transa\u00e7\u00e3o. Valor: " + saida.getValorTransacao() + ", desconto: " + valorDesconto);
                entradaApiTefC.setValorDesconto(null);
                return INVALID_NUMBER;
            }
            this.logger.log("INFO", "Novo valor da transa\u00e7\u00e3o: " + valorTransacao);
            saida.setValorTransacao(valorTransacao);
        }
        return SUCCESS;
    }

    public static void main(String[] args) {
        BigDecimal bValor = new BigDecimal("12.00");
        System.out.println(bValor);
        DecimalFormat decimalFormat = new DecimalFormat("#");
        bValor = bValor.multiply(new BigDecimal(100));
        System.out.println(bValor);
        System.out.println(decimalFormat.format(bValor));
    }
}

