/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDs;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class MicCargaTabelaPinpad
implements ConstantesEMV {
    private static ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";

    public int numRegistros(String registros) {
        int tam = 0;
        int numRegistros = 0;
        if (registros == null) {
            return 0;
        }
        while (tam < registros.length()) {
            String strTam = registros.substring(tam, tam + 3);
            int offset = Integer.parseInt(strTam);
            tam = offset == 0 ? (tam += 3) : (tam += offset);
            ++numRegistros;
        }
        return numRegistros;
    }

    public String execute(ICargaTabelasPinpad dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            String[] tabelas = dados.getConteudoTabelas().toArray(new String[0]);
            ILeitorCartaoHandler leitorCartao = perifericos.getLeitorCartao();
            CMOSPinPad cmos = CMOSPinPad.getInstance();
            SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
            int redeAdquirente = saida != null && saida.getTipoBibliotecaPinpad() == 2 ? saida.getTipoBibliotecaPinpad() : 0;
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
            String timeStamp = cmos.getTimeStamp(redeAdquirente);
            ControladorAIDs controladorAIDs = new ControladorAIDs();
            boolean informaAIDGetCard = dadosInicioDia.isInformaAIDGetcard();
            boolean mobile = config.isIntegracaoAndroid();
            ArrayList<String> redesPPNoApplication = new ArrayList<String>();
            if (informaAIDGetCard && mobile) {
                for (int i = 0; i < tabelas.length; ++i) {
                    DadosGetInfoRedeEMV dadosInfoEMV;
                    String rede = ControladorAIDs.getRedeTabela(tabelas[i]);
                    if (rede == null || redesPPNoApplication.contains(rede) || (dadosInfoEMV = perifericos.getPin().getInfoRedeEMV(Integer.parseInt(rede))) != null && dadosInfoEMV.getRetorno() != 22) continue;
                    redesPPNoApplication.add(rede);
                }
                logger.info("redesPPNoApplication: " + redesPPNoApplication);
            }
            DecimalFormat format2Zeros = new DecimalFormat("00");
            int retry = 0;
            boolean ocorreuErro = false;
            do {
                int indice = 1;
                int retorno = leitorCartao.iniciaCargaTabelas(timeStamp);
                if (retorno == 20 || retorno == 0) {
                    for (int i = 0; !ocorreuErro && i < tabelas.length; ++i) {
                        int numRegistros = this.numRegistros(tabelas[i]);
                        if (numRegistros == 0) continue;
                        logger.log("INFO", "Dados tabela: 01" + tabelas[i]);
                        if (informaAIDGetCard) {
                            controladorAIDs.addLinhaCargaTabelas(tabelas[i], redesPPNoApplication);
                        }
                        perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO") + " (" + format2Zeros.format(indice) + "/" + tabelas.length + ")"));
                        ++indice;
                        ocorreuErro = leitorCartao.executaCargaTabelas("01" + tabelas[i]) != 0;
                    }
                    ocorreuErro = leitorCartao.finalizaCargaTabelas() != 0;
                    continue;
                }
                ocorreuErro = true;
            } while (++retry <= 3 && ocorreuErro);
            if (!ocorreuErro) {
                cmos.habilitaCargaTabelas(redeAdquirente);
                if (informaAIDGetCard) {
                    logger.info("Persistindo AIDs que ser\u00e3o utilizados na GetCard...");
                    try {
                        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                        controladorAIDsGetCard.saveMapAid(controladorAIDs.getMapAIDs());
                        leitorCartao.setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_OK);
                        if (config.isIntegracaoAndroid()) {
                            leitorCartao.desabilita();
                        }
                        logger.info("AIDs persistidos com sucesso");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn("Problema ao persistir os AIDs para leitura na GetCard");
                    }
                } else {
                    try {
                        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                        if (controladorAIDsGetCard.getMapAid() != null) {
                            logger.info("Limpando AIDs que ser\u00e3o utilizados na GetCard...");
                            controladorAIDsGetCard.saveMapAid(null);
                            logger.info("Limpeza de AIDs completa");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn("Problema ao limpar os AIDs para leitura na GetCard");
                    }
                }
                logger.log("INFO", "******************************************************************");
                logger.log("INFO", "******** CARGA DE TABELA NO PIN EFETUADA COM SUCESSO *************");
                logger.log("INFO", "******************************************************************");
            } else {
                logger.log("ERROR", "******************************************************************");
                logger.log("ERROR", "*************** ERRO NA CARGA DE TABELA NO PIN *******************");
                logger.log("ERROR", "******************************************************************");
            }
            return SUCESS;
        }
        catch (Exception e) {
            logger.log("ERROR", e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }
}

