/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCargaTabelaForcadaTest;
import com.csi.ctfclient.operacoes.action.ProcessInicioDia;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ControladorDetectaPinpad;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.servico.POSTefServico;
import com.csi.ctfclient.tools.util.CnpjUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;

public class MicConfigurarTerminal {
    public static String OK = "OK";
    public static String ERRO = "ERRO";
    public static String CANCELADO_USUARIO = "CANCELADO_USUARIO";

    public String execute(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
        boolean sair = false;
        String OPCAO_INICIALIZACAO = "INICIALIZACAO";
        String OPCAO_TERMINAL = "TERMINAL";
        String OPCAO_CTF_SERVER = "CTF-SERVER";
        String OPCAO_PINPAD = "PINPAD";
        String OPCAO_CARGA_TABELA = "CARGA DE TABELAS";
        String OPCAO_CLIENT_SERVICO = "CLIENTE SERVICO";
        String OPCAO_POS_MOVEL = "POS-MOVEL";
        String OPCAO_SAIR = "SAIR";
        while (!sair) {
            int item = 1;
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO", true);
            if (!confCTFClient.isMultiEC()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_INICIALIZACAO, String.valueOf(item++)));
            }
            if (!confCTFClient.isSuporteHttps()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_TERMINAL, String.valueOf(item++)));
                layoutMenu.addItem(new ItemMenu(OPCAO_CTF_SERVER, String.valueOf(item++)));
            }
            layoutMenu.addItem(new ItemMenu(OPCAO_PINPAD, String.valueOf(item++)));
            if (!confCTFClient.isMultiEC()) {
                layoutMenu.addItem(new ItemMenu(OPCAO_CARGA_TABELA, String.valueOf(item++)));
            }
            if (confClienteServico != null && confClienteServico.getHost() != null) {
                layoutMenu.addItem(new ItemMenu(OPCAO_POS_MOVEL, String.valueOf(item++)));
                layoutMenu.addItem(new ItemMenu(OPCAO_CLIENT_SERVICO, String.valueOf(item++)));
            }
            layoutMenu.addItem(new ItemMenu(OPCAO_SAIR, String.valueOf(item++)));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                if (perifericos.exibeMenuCancelamento() != 1) continue;
                sair = true;
                continue;
            }
            ItemMenu itemMenu = layoutMenu.getItens().get(opcao - 1);
            if (itemMenu.getTexto().equals(OPCAO_INICIALIZACAO)) {
                this.inicioDia(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_TERMINAL)) {
                this.configurarTerminal(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_CTF_SERVER)) {
                this.configurarCTFServer(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_PINPAD)) {
                this.configurarPinpad(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_CARGA_TABELA)) {
                this.cargaTabelasPinpad(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_POS_MOVEL)) {
                this.configurarPOSMovel(dados);
                continue;
            }
            if (itemMenu.getTexto().equals(OPCAO_CLIENT_SERVICO)) {
                this.configurarClientService(dados);
                continue;
            }
            if (!itemMenu.getTexto().equals(OPCAO_SAIR)) continue;
            sair = true;
        }
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        saidaApiTefC.setRetorno(0);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        Contexto.getContexto().setErroIntegracao(null);
        dados.setErro(null);
        return OK;
    }

    private void configurarTerminal(Process dados) throws Exception {
        EventoTeclado eventoTeclado;
        LayoutDisplay layoutDisplay;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        String empresa = "";
        String loja = "";
        String pdv = "";
        String cnpj = "";
        boolean sair = false;
        while (!sair && empresa.length() < 5) {
            layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("EMPRESA:"));
            eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_EMPRESA, confCTFClient.getEstabelecimento());
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                sair = true;
                continue;
            }
            empresa = eventoTeclado.getStringLida().trim();
        }
        while (!sair && loja.length() < 4) {
            layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("LOJA:"));
            eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_LOJA, confCTFClient.getLoja());
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                sair = true;
                continue;
            }
            loja = eventoTeclado.getStringLida().trim();
        }
        while (!sair && pdv.length() < 3) {
            layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("PDV:"));
            eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, confCTFClient.getTerminal());
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                sair = true;
                continue;
            }
            pdv = eventoTeclado.getStringLida().trim();
        }
        while (!sair && cnpj.length() < 14) {
            layoutDisplay = new LayoutDisplay("CONFIGURACAO -> TERMINAL");
            layoutDisplay.addLinha(new Linha("CNPJ:"));
            eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CNPJ, confCTFClient.getCnpj() != null ? confCTFClient.getCnpj() : "");
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                sair = true;
                continue;
            }
            cnpj = eventoTeclado.getStringLida().trim();
            if (CnpjUtil.validaCnpj(cnpj)) continue;
            layoutDisplay = new LayoutDisplay("CNPJ INVALIDO");
            perifericos.confirmaDado(layoutDisplay);
            cnpj = "";
        }
        if (!sair) {
            confCTFClient.setEstabelecimento(empresa);
            confCTFClient.setLoja(loja);
            confCTFClient.setTerminal(pdv);
            confCTFClient.setCnpj(cnpj);
            ControladorConfCTFClient.getInstance().save(confCTFClient);
            layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("TERMINAL CONFIGURADO"));
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void configurarCTFServer(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean sair = false;
        block2: while (!sair) {
            LayoutDisplay layoutDisplay;
            String ctf;
            Set ips;
            ConfCTFClient confCTFClient;
            int i;
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> CTF-SERVER", true);
            layoutMenu.addItem(new ItemMenu("LISTAR", "1"));
            layoutMenu.addItem(new ItemMenu("ADICIONAR", "2"));
            layoutMenu.addItem(new ItemMenu("REMOVER", "3"));
            layoutMenu.addItem(new ItemMenu("VOLTAR", "4"));
            EventoTeclado eventoTeclado = null;
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                sair = true;
                continue;
            }
            if (opcao == 1) {
                i = 1;
                confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
                ips = confCTFClient.getIps();
                layoutMenu = new LayoutMenu("CTF-SERVER -> LISTAR", true);
                for (ServicoCTF servicoCTF : ips) {
                    ctf = servicoCTF.getHost().getEndereco();
                    ctf = ctf + ":" + servicoCTF.getIdentificadorServico();
                    ctf = ctf + ":" + servicoCTF.getProtocolo();
                    layoutMenu.addItem(new ItemMenu(ctf, "" + i++));
                }
                opcao = perifericos.imprimeMenu(layoutMenu);
                continue;
            }
            if (opcao == 2) {
                boolean addSair = false;
                String endereco = "";
                int porta = 0;
                String protocolo = "";
                boolean hostValido = false;
                while (!addSair && !hostValido) {
                    layoutDisplay = new LayoutDisplay("CTF-SERVER -> ADICIONAR");
                    layoutDisplay.addLinha(new Linha("HOST:"));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CTF_HOST);
                    if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                        addSair = true;
                        continue;
                    }
                    endereco = eventoTeclado.getStringLida().trim();
                    if (endereco.length() == 0) continue;
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha("VALIDANDO HOST"));
                    layoutDisplay.addLinha(new Linha("AGUARDE..."));
                    perifericos.imprimeDisplay(layoutDisplay);
                    try {
                        InetAddress address = InetAddress.getByName(endereco);
                        if (address == null) continue;
                        hostValido = true;
                    }
                    catch (UnknownHostException e) {
                        layoutDisplay = new LayoutDisplay();
                        layoutDisplay.addLinha(new Linha("HOST INVALIDO"));
                        perifericos.confirmaDado(layoutDisplay);
                        hostValido = false;
                    }
                }
                while (!addSair && porta <= 0) {
                    layoutDisplay = new LayoutDisplay("CTF-SERVER -> ADICIONAR");
                    layoutDisplay.addLinha(new Linha("PORTA:"));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CTF_PORTA);
                    if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                        addSair = true;
                        continue;
                    }
                    porta = Integer.parseInt(eventoTeclado.getStringLida().trim());
                }
                opcao = 0;
                while (!addSair && opcao == 0) {
                    String[] msg = new String[]{"CTF-SERVER > ADICIONAR", "PROTOCOLO:"};
                    layoutMenu = new LayoutMenu(msg, true);
                    layoutMenu.addItem(new ItemMenu("TCP", "1"));
                    layoutMenu.addItem(new ItemMenu("UDP", "2"));
                    opcao = perifericos.imprimeMenu(layoutMenu);
                    opcao = Integer.parseInt(eventoTeclado.getStringLida().trim());
                    if (opcao == 1) {
                        protocolo = "TCP";
                        continue;
                    }
                    if (opcao != 2) continue;
                    protocolo = "UDP";
                }
                if (addSair) continue;
                ConfCTFClient confCTFClient2 = ControladorConfCTFClient.getInstance().getConfig();
                Host host = new Host(endereco);
                ServicoCTF servicoCTF = new ServicoCTF(host, porta + "", protocolo);
                if (!confCTFClient2.getIps().contains(servicoCTF)) {
                    confCTFClient2.getIps().add(servicoCTF);
                    ControladorConfCTFClient.getInstance().save(confCTFClient2);
                }
                LayoutDisplay layoutDisplay2 = new LayoutDisplay();
                layoutDisplay2.addLinha(new Linha("CTF-SERVER ADICIONADO"));
                perifericos.confirmaDado(layoutDisplay2);
                continue;
            }
            if (opcao == 3) {
                i = 1;
                confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
                ips = confCTFClient.getIps();
                layoutMenu = new LayoutMenu("CTF-SERVER -> REMOVER", true);
                for (ServicoCTF servicoCTF : ips) {
                    ctf = servicoCTF.getHost().getEndereco();
                    ctf = ctf + ":" + servicoCTF.getIdentificadorServico();
                    ctf = ctf + ":" + servicoCTF.getProtocolo();
                    layoutMenu.addItem(new ItemMenu(ctf, "" + i++));
                }
                opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) continue;
                if (ips.size() == 1) {
                    LayoutDisplay layoutDisplay3 = new LayoutDisplay();
                    layoutDisplay3.addLinha(new Linha("NAO FOI POSSIVEL REMOVER"));
                    layoutDisplay3.addLinha(new Linha("O CTF-SERVER SELECIONADO"));
                    layoutDisplay3.addLinha(new Linha("DETALHE:", 0, 1));
                    layoutDisplay3.addLinha(new Linha("DEVE EXISTIR PELO MENOS"));
                    layoutDisplay3.addLinha(new Linha("UM CTF-SERVER CONFIGURADO"));
                    perifericos.confirmaDado(layoutDisplay3);
                    continue;
                }
                layoutMenu = new LayoutMenu("REMOVER CTF-SERVER?", true);
                layoutMenu.addItem(new ItemMenu("SIM", "1"));
                layoutMenu.addItem(new ItemMenu("NAO", "2"));
                opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao != 1) continue;
                i = 1;
                for (Object obj : ips) {
                    if (i == opcao) {
                        confCTFClient.getIps().remove(obj);
                        ControladorConfCTFClient.getInstance().save(confCTFClient);
                        layoutDisplay = new LayoutDisplay();
                        layoutDisplay.addLinha(new Linha("CTF-SERVER REMOVIDO"));
                        perifericos.confirmaDado(layoutDisplay);
                        continue block2;
                    }
                    ++i;
                }
                continue;
            }
            if (opcao != 4) continue;
            sair = true;
        }
    }

    private void configurarPinpad(Process dados) throws Exception {
        File fileSERCFG;
        ControladorPerifericos perifericos = dados.getPerifericos();
        File fileCSICFG = new File("CSICFG");
        if (fileCSICFG.exists()) {
            fileCSICFG.delete();
        }
        if ((fileSERCFG = new File("SERCFG")).exists()) {
            fileSERCFG.delete();
        }
        String osName = System.getProperty("os.name");
        String portaSerial = "";
        boolean salvarConfig = false;
        String tipoPorta = osName.toUpperCase().indexOf("WIN") != -1 ? "COM" : "/dev/ttyS";
        LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> PINPAD", true);
        layoutMenu.addItem(new ItemMenu("MANUAL", "1"));
        layoutMenu.addItem(new ItemMenu("AUTOMATICA", "2"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        EventoTeclado evTeclado = null;
        if (opcao == -1) {
            return;
        }
        if (opcao == 1) {
            boolean sairPinpad = false;
            while (!sairPinpad) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CONFIGURACAO -> PINPAD"));
                layoutDisplay.addLinha(new Linha("PORTA " + tipoPorta + ":"));
                evTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_PINPAD_PORTA);
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return;
                }
                int num = evTeclado.getStringLida().length() - evTeclado.getNumCaracteresDigitados();
                portaSerial = evTeclado.getStringLida().substring(num);
                if (portaSerial.equals("0") || portaSerial.equals("00") || portaSerial.equals("")) {
                    layoutDisplay = new LayoutDisplay("PORTA SERIAL INVALIDA");
                    perifericos.confirmaDado(layoutDisplay);
                    continue;
                }
                portaSerial = tipoPorta + portaSerial;
                salvarConfig = true;
                sairPinpad = true;
            }
        } else {
            ControladorDetectaPinpad controladorDetectaPinpad = ControladorDetectaPinpad.getInstancia();
            portaSerial = controladorDetectaPinpad.detectaPinpad(perifericos);
            if (portaSerial != null) {
                salvarConfig = true;
            }
        }
        if (salvarConfig) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CONFIGURANDO PINPAD"));
            layoutDisplay.addLinha(new Linha("AGUARDE..."));
            perifericos.imprimeDisplay(layoutDisplay);
            ControladorConfCTFClient.getInstance().configuraPinpad(portaSerial);
            layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("PINPAD CONFIGURADO"));
            layoutDisplay.addLinha(new Linha("NA PORTA: " + portaSerial));
            perifericos.confirmaDado(layoutDisplay);
        } else {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("PINPAD NAO DETECTADO"));
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void inicioDia(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ProcessInicioDia processInicioDia = new ProcessInicioDia(null);
        processInicioDia.setParent(dados);
        ProcessManager.getInstance().subProcess(processInicioDia.getIdProcess(), processInicioDia);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getRetorno() == 0) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CTFCLIENT INICIALIZADO"));
                layoutDisplay.addLinha(new Linha("COM SUCESSO"));
                perifericos.confirmaDado(layoutDisplay);
            } else {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
                layoutDisplay.addLinha(new Linha("A INICIALIZACAO DO CTFCLIENT"));
                layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
                layoutDisplay.addLinha(new Linha("RETORNO: " + saidaApiTefC.getRetorno()));
                if (saidaApiTefC.getCodigoErro() != null) {
                    layoutDisplay.addLinha(new Linha("ERRO: " + saidaApiTefC.getCodigoErro()));
                }
                perifericos.confirmaDado(layoutDisplay);
            }
        }
    }

    private void cargaTabelasPinpad(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ProcessCargaTabelaForcadaTest processCargaTabela = new ProcessCargaTabelaForcadaTest();
        processCargaTabela.setParent(dados);
        ProcessManager.getInstance().subProcess(processCargaTabela.getIdProcess(), processCargaTabela);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        CodigoErroIntegracao erroIntegracao = Contexto.getContexto().getErroIntegracao();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() != 0) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
            layoutDisplay.addLinha(new Linha("A CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
            layoutDisplay.addLinha(new Linha("RETORNO: " + saidaApiTefC.getRetorno()));
            if (saidaApiTefC.getCodigoErro() != null) {
                layoutDisplay.addLinha(new Linha("ERRO: " + saidaApiTefC.getCodigoErro()));
            }
            perifericos.confirmaDado(layoutDisplay);
        } else if (erroIntegracao != null) {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REALIZAR"));
            layoutDisplay.addLinha(new Linha("A CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("DETALHE:", 0, 2));
            layoutDisplay.addLinha(new Linha("RETORNO: " + erroIntegracao.getCodigo()));
            layoutDisplay.addLinha(new Linha("VERIFIQUE SE O PINPAD ESTA"));
            layoutDisplay.addLinha(new Linha("CONECTADO E REALIZE A CONFIGURACAO"));
            perifericos.confirmaDado(layoutDisplay);
        } else {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CARGA DE TABELAS DO PINPAD"));
            layoutDisplay.addLinha(new Linha("REALIZADA COM SUCESSO"));
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void configurarClientService(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean sair = false;
        while (!sair) {
            LayoutDisplay layoutDisplay;
            boolean sairMenu;
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
            String statusClientService = confClienteServico.isHabilitado() ? "DESABILITAR" : "HABILITAR";
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> CLIENTE SERVICO", true);
            layoutMenu.addItem(new ItemMenu(statusClientService, "1"));
            layoutMenu.addItem(new ItemMenu("CODIGO DO PDV", "2"));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            EventoTeclado evTeclado = null;
            if (opcao == -1) {
                sair = true;
                continue;
            }
            POSTef.init(POSTefServico.class);
            POSTef<?> posMovel = POSTef.getInstance();
            if (opcao == 1) {
                sairMenu = false;
                Boolean habilitaClientService = null;
                while (!sairMenu) {
                    layoutMenu = new LayoutMenu(statusClientService + " CLIENTE SERVICO?", true);
                    layoutMenu.addItem(new ItemMenu("SIM", "1"));
                    layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        sairMenu = true;
                    } else if (opcao == 1) {
                        habilitaClientService = confClienteServico.isHabilitado() ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    } else if (opcao == 2) {
                        habilitaClientService = confClienteServico.isHabilitado() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (confClienteServico == null || habilitaClientService == null) continue;
                    confClienteServico.setHabilitado(habilitaClientService);
                    sairMenu = true;
                }
                if (!sairMenu || habilitaClientService == null) continue;
                LayoutDisplay layoutDisplay2 = new LayoutDisplay();
                layoutDisplay2 = new LayoutDisplay();
                layoutDisplay2.addLinha(new Linha("CLIENTE SERVICO"));
                if (habilitaClientService.booleanValue()) {
                    posMovel.conecta();
                    layoutDisplay2.addLinha(new Linha("HABILITADO"));
                } else {
                    layoutDisplay2.addLinha(new Linha("DESABILITADO"));
                    posMovel.desconecta();
                }
                ControladorConfCTFClient.getInstance().save(confCTFClient);
                perifericos.confirmaDado(layoutDisplay2);
                continue;
            }
            if (opcao != 2) continue;
            sairMenu = false;
            while (!sairMenu) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CONFIGURACAO -> CLIENTE SERVICO"));
                layoutDisplay.addLinha(new Linha("CODIGO PDV:"));
                evTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, 0, true, 12, true, confClienteServico.getCodigoPdv());
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return;
                }
                String pdv = evTeclado.getStringLida().trim();
                if (pdv == null || "".equals(pdv)) {
                    layoutDisplay = new LayoutDisplay("CODIGO DO PDV INVALIDO");
                    perifericos.confirmaDado(layoutDisplay);
                    continue;
                }
                if (confClienteServico != null) {
                    confClienteServico.setCodigoPdv(pdv);
                }
                sairMenu = true;
            }
            if (!sairMenu) continue;
            layoutDisplay = new LayoutDisplay();
            ControladorConfCTFClient.getInstance().save(confCTFClient);
            layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("CODIGO DO PDV"));
            layoutDisplay.addLinha(new Linha("CONFIGURADO"));
            if (posMovel.isInicializado()) {
                layoutDisplay.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                layoutDisplay.addLinha(new Linha("CLIENTE SERVICO"));
            } else {
                layoutDisplay.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                layoutDisplay.addLinha(new Linha("CLIENTE SERVICO"));
            }
            perifericos.confirmaDado(layoutDisplay);
        }
    }

    private void configurarPOSMovel(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean sair = false;
        while (!sair) {
            LayoutDisplay layoutDisplay;
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            ConfPOSTef confPOSTef = confCTFClient.getConfPOSTef();
            String statusPOSMovel = confCTFClient.getConfPOSTef().isHabilitado() ? "DESABILITAR" : "HABILITAR";
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> POS-MOVEL", true);
            layoutMenu.addItem(new ItemMenu(statusPOSMovel, "1"));
            layoutMenu.addItem(new ItemMenu("COD. TERMINAL", "2"));
            int opcao = perifericos.imprimeMenu(layoutMenu);
            EventoTeclado evTeclado = null;
            if (opcao == -1) {
                sair = true;
                continue;
            }
            POSTef.init(POSTefServico.class);
            POSTef<?> posMovel = POSTef.getInstance();
            if (opcao == 1) {
                Boolean habilitaPosMovel = null;
                boolean sairMenu = false;
                while (!sairMenu) {
                    layoutMenu = new LayoutMenu(statusPOSMovel + " POS-MOVEL?", true);
                    layoutMenu.addItem(new ItemMenu("SIM", "1"));
                    layoutMenu.addItem(new ItemMenu("NAO", "2"));
                    opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        sair = true;
                    } else if (opcao == 1) {
                        habilitaPosMovel = confPOSTef.isHabilitado() ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    } else if (opcao == 2) {
                        habilitaPosMovel = confPOSTef.isHabilitado() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (confPOSTef == null || habilitaPosMovel == null) continue;
                    confPOSTef.setHabilitado(habilitaPosMovel);
                    sairMenu = true;
                }
                if (!sairMenu || habilitaPosMovel == null) continue;
                layoutDisplay = new LayoutDisplay();
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("POS-MOVEL"));
                if (habilitaPosMovel.booleanValue()) {
                    layoutDisplay.addLinha(new Linha("HABILITADO"));
                } else {
                    layoutDisplay.addLinha(new Linha("DESABILITADO"));
                }
                if (posMovel.isInicializado()) {
                    layoutDisplay.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                    layoutDisplay.addLinha(new Linha("CLIENTE SERVICO"));
                } else {
                    layoutDisplay.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                    layoutDisplay.addLinha(new Linha("CLIENTE SERVICO"));
                }
                ControladorConfCTFClient.getInstance().save(confCTFClient);
                perifericos.confirmaDado(layoutDisplay);
                continue;
            }
            if (opcao != 2) continue;
            boolean sairMenu = false;
            while (!sairMenu) {
                String estab = confCTFClient.getEstabelecimento() + confCTFClient.getLoja();
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CONFIGURACAO -> POS-MOVEL"));
                layoutDisplay.addLinha(new Linha("TERMINAL " + estab + ":"));
                evTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_PDV, 0, true, 19, true, confPOSTef.getTerminalPosMovel());
                if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return;
                }
                int num = evTeclado.getStringLida().length() - evTeclado.getNumCaracteresDigitados();
                String pdv = evTeclado.getStringLida().substring(num);
                if (pdv == null || "".equals(pdv) || pdv.trim().length() < 3) {
                    layoutDisplay = new LayoutDisplay("CODIGO DO TERMINAL INVALIDO");
                    perifericos.confirmaDado(layoutDisplay);
                    continue;
                }
                if (confPOSTef != null) {
                    confPOSTef.setTerminalPosMovel(pdv);
                }
                sairMenu = true;
            }
            if (!sairMenu) continue;
            LayoutDisplay layoutDisplay2 = new LayoutDisplay();
            ControladorConfCTFClient.getInstance().save(confCTFClient);
            layoutDisplay2 = new LayoutDisplay();
            layoutDisplay2.addLinha(new Linha("COD. TERMINAL POS-MOVEL"));
            layoutDisplay2.addLinha(new Linha("CONFIGURADO"));
            if (confPOSTef.isHabilitado()) {
                if (posMovel.isInicializado()) {
                    layoutDisplay2.addLinha(new Linha("NECESSARIO REINICIAR", 0, 1));
                    layoutDisplay2.addLinha(new Linha("CLIENTE SERVICO"));
                } else {
                    layoutDisplay2.addLinha(new Linha("NECESSARIO INICIAR", 0, 1));
                    layoutDisplay2.addLinha(new Linha("CLIENTE SERVICO"));
                }
            } else {
                layoutDisplay2.addLinha(new Linha("NECESSARIO HABILITAR", 0, 1));
                layoutDisplay2.addLinha(new Linha("POS-MOVEL"));
            }
            perifericos.confirmaDado(layoutDisplay2);
        }
    }
}

