/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class MicDesfazimentoOperacao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dado) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        String key = entradaIntegracao != null ? String.valueOf(entradaIntegracao.getNumeroTransacao()) : String.valueOf(entradaApiTefC.getNumeroTransacao());
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        IdentTerminal identTerminal = new IdentTerminal(ident.getNumeroEstabelecimento(), ident.getNumeroLoja(), ident.getNumeroPdv());
        DadosConfirmacaoDesfazimento dadosConfirmacaoDesfazimento = null;
        try {
            dadosConfirmacaoDesfazimento = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal);
            if (dadosConfirmacaoDesfazimento.isPinpadPOSTefRemoto() && (dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 2 || dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 3)) {
                this.logger.info("transacao executa em modo POSTef com confirmacao no POS habilitada. necessario executar cancelamento da transacao");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(20, "ERRO NO DESFAZIMENTO#USE O CANCELAMENTO");
                Contexto.getContexto().setErroIntegracao(erroIntegracao);
                return ERROR;
            }
            if ((conf.isIntegracaoTefIP() || conf.isIntegracaoTefDisc()) && conf.isConfirmarDesfazimento() && entradaIntegracao.getOperacao() == 7 && !this.confirmaDesfazimento(dadosConfirmacaoDesfazimento, dado.getPerifericos())) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(20);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5317, "OPERACAO CANCELADA"));
                return ERROR;
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar o desfazimento no terminal " + identTerminal, e);
        }
        if (dadosConfirmacaoDesfazimento != null) {
            entradaApiTefC.setOperacao(dadosConfirmacaoDesfazimento.getOperacao());
            entradaApiTefC.setNumeroTransacao(dadosConfirmacaoDesfazimento.getNumeroTransacao());
            entradaApiTefC.setDataCliente(dadosConfirmacaoDesfazimento.getDataCliente());
            entradaApiTefC.setNumeroSeriePin(dadosConfirmacaoDesfazimento.getNumeroSeriePin());
            entradaApiTefC.setTimeoutCtf(dadosConfirmacaoDesfazimento.getTimeout());
            entradaApiTefC.setTimestamp(dadosConfirmacaoDesfazimento.getTimestamp());
            if (dadosConfirmacaoDesfazimento.getTipoResposta() != null && !dadosConfirmacaoDesfazimento.getTipoResposta().equals("")) {
                entradaApiTefC.setTipoResposta(dadosConfirmacaoDesfazimento.getTipoResposta().charAt(0));
            }
            entradaApiTefC.setDadosFinaisChip(dadosConfirmacaoDesfazimento.getDadosFinaisChip());
            entradaApiTefC.setIssuerScriptResult(dadosConfirmacaoDesfazimento.getIssuerScriptResult());
            if (dadosConfirmacaoDesfazimento.getApplicationExpirationDate() != null) {
                entradaApiTefC.setApplicationExpirationDate(dadosConfirmacaoDesfazimento.getApplicationExpirationDate());
            }
        }
        entradaApiTefC.setMotivoDesfazimento(1);
        SaidaApiTefC saida = dado.getApitef().desfazimento(ident, entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.error("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o " + dadosConfirmacaoDesfazimento.getNumeroTransacao() + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf.");
            return FAIL;
        }
        return SUCESS;
    }

    private boolean confirmaDesfazimento(DadosConfirmacaoDesfazimento dadosDesfazimento, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay("DESFAZIMENTO DE TRANSACAO");
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("NSU: " + StringUtil.completaString(dadosDesfazimento.getNsu() + "", 6, '0', 3), 0));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        displayModel.addLinha(new Linha("DATA DA VENDA: " + dateFormat.format(dadosDesfazimento.getDataCliente()), 0));
        if (dadosDesfazimento.getValorTransacao() != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
            displayModel.addLinha(new Linha("VALOR DA VENDA: " + decimalFormat.format(dadosDesfazimento.getValorTransacao()), 0));
        }
        displayModel.addLinha(new Linha("DESFAZER TRANSACAO?", 0, 2));
        displayModel.addLinha(new Linha("[1] - SIM"));
        displayModel.addLinha(new Linha("[2] - NAO"));
        boolean valorValido = false;
        while (!valorValido) {
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_TRANS_PENDENTE);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) continue;
            String value = eventoTeclado.getStringLida();
            if (value.equals("1")) {
                LayoutDisplay layoutDisplay = new LayoutDisplay("TRANSACAO DESFEITA", 1500L);
                perifericos.imprimeDisplay(layoutDisplay);
                return true;
            }
            if (!value.equals("2")) continue;
            return false;
        }
        return false;
    }
}

