/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicEnvio1FCorrespondenteBancario
extends MicAbstractEnvio1F {
    public static final String ERROR_CTF = "ERROR_CTF";
    private String codigoTransacao;
    private ILogger logger = CTFClientLogger.getCTFClient();

    @Override
    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().isSubProcessConsulta() || saidaApiTefC != null && saidaApiTefC.getRetorno() == 0 && entradaApiTefC != null && entradaApiTefC.getCodigoTransacao().equals("1F")) {
            return "UNECESSARY";
        }
        int modoEntrada = entradaApiTefC.getModoEntradaCodigoBarras();
        if (entradaApiTefC.getDataVencimentoCorBan() != null) {
            entradaApiTefC.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
        }
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntrada, entradaApiTefC.getCodigoBarras(), Contexto.getContexto().getTipoPagamento());
        if (Contexto.getContexto().getTipoPagamento() == 4 || Contexto.getContexto().getTipoPagamento() == 5) {
            entradaApiTefC.setDadosCorrespondenteBancario(entradaCorrespondenteBancario);
        } else if (Contexto.getContexto().getTipoPagamento() == 1 || Contexto.getContexto().getTipoPagamento() == 2) {
            entradaApiTefC.setInfo(entradaCorrespondenteBancario);
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO")) {
            this.codigoTransacao = "E4";
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            this.codigoTransacao = "E5";
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO")) {
            this.codigoTransacao = Contexto.getContexto().getTipoPagamento() == 4 ? "2T" : (Contexto.getContexto().getTipoPagamento() == 5 ? "EY" : "E6");
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO")) {
            this.codigoTransacao = Contexto.getContexto().getTipoPagamento() == 4 ? "2P" : (Contexto.getContexto().getTipoPagamento() == 5 ? "EZ" : "E7");
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO")) {
            this.codigoTransacao = Contexto.getContexto().getTipoPagamento() == 4 ? "2T" : (Contexto.getContexto().getTipoPagamento() == 5 ? "EY" : "E6");
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO")) {
            this.codigoTransacao = Contexto.getContexto().getTipoPagamento() == 4 ? "2P" : (Contexto.getContexto().getTipoPagamento() == 5 ? "EZ" : "E7");
        } else {
            throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
        }
        String retorno = super.execute(dados);
        saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 10 && saidaApiTefC.getCodigoErro() != null && saidaApiTefC.getCodigoErro().equals("0203")) {
            return ERROR_CTF;
        }
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            if (this.isPagamentoInicial(this.codigoTransacao)) {
                Contexto.getContexto().setConsultaObrigatoria(saidaApiTefC.isConsultaObrigatoria());
                Contexto.getContexto().setCorbanExecutaSubfluxos(saidaApiTefC.isCorbanExecutaSubfluxos());
            } else {
                SaidaApiTefC saidaConsultaCorban = Contexto.getContexto().getSaidaConsulta();
                if (saidaConsultaCorban != null) {
                    this.logger.info("Utilizando valores da Consulta CORBAN anterior");
                    saidaApiTefC.setValorTransacao(saidaConsultaCorban.getValorTransacao());
                    saidaApiTefC.setCapturaAcrescimo(saidaConsultaCorban.isCapturaAcrescimo());
                    saidaApiTefC.setCapturaDesconto(saidaConsultaCorban.isCapturaDesconto());
                    saidaApiTefC.setValorDesconto(saidaConsultaCorban.getValorDesconto());
                    saidaApiTefC.setValorAcrescimo(saidaConsultaCorban.getValorAcrescimo());
                    saidaApiTefC.setValorTotalJaCalculado(saidaConsultaCorban.isValorTotalJaCalculado());
                    saidaApiTefC.setPermiteAlteracaoValorPagamentoCorban(saidaConsultaCorban.isPermiteAlteracaoValorPagamentoCorban());
                } else {
                    this.logger.info("Sem sa\u00edda da consulta corban");
                }
            }
        }
        return retorno;
    }

    private boolean isPagamentoInicial(String codigoTransacao) {
        return codigoTransacao.equals("E4") || codigoTransacao.equals("E5") || codigoTransacao.equals("E6") || codigoTransacao.equals("E7");
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) throws IllegalStateException {
        return this.codigoTransacao;
    }
}

