/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MicEnvio2M {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(ICargaTabelasPinpad dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO"));
        perifericos.imprimeDisplay(displayModel);
        ILeitorCartaoHandler leitorCartao = perifericos.getLeitorCartao();
        try {
            SimpleDateFormat dateFormat;
            Date timestampDate;
            String timestamp;
            List<String> cacheTabelas = CMOSPinPad.getInstance().getCacheCargaTabelas(leitorCartao.getRedeAdquirente());
            if (cacheTabelas != null && (timestamp = CMOSPinPad.getInstance().getTimeStamp(leitorCartao.getRedeAdquirente())) != null && DateUtil.equalsData(timestampDate = (dateFormat = new SimpleDateFormat("ddMMyyyy")).parse(timestamp.substring(0, 8)), new Date())) {
                this.logger.info("cache de tabelas valido.");
                dado.setConteudoTabelas(cacheTabelas);
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                return SUCESS;
            }
        }
        catch (Exception e) {
            this.logger.warn("nao foi possivel validar cache da carga de tabelas. " + e.getMessage());
        }
        PerifericoEventHandler.setActive(false);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(0);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.isIntegracaoAndroid() && conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        GetInfo getInfoEMV = Contexto.getContexto().getDadosGetInfo();
        if (getInfoEMV != null) {
            entrada.setFabricantePinpad(getInfoEMV.getFabricante());
            entrada.setModeloHardware(getInfoEMV.getModeloHardware());
            entrada.setVersaoFirmwarePinpad(getInfoEMV.getVersaoFirmware());
            entrada.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificao());
            entrada.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplicacao());
            entrada.setNumeroSeriePin(getInfoEMV.getNumeroSerie());
        }
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setOperacao("2M");
        int redeChip = leitorCartao.getRedeAdquirente();
        if (leitorCartao != null) {
            entrada.setCodigoRedeAdquirenteChip(redeChip);
        }
        entrada.setCodigoRedeCargaTabelaPin("00");
        entrada.setIndiceCargaTabelaPin(0);
        entrada.setFlagCargaTabela(true);
        entrada.setTipoBibliotecaPinpad(ProtocoloBibliotecaCompartilhada.getTipoBibliotecaPinpad());
        if (perifericos.getPin() != null) {
            entrada.setVersaoEspecificacao(perifericos.getPin().getInfo().getVersaoEspecificacao());
        }
        if (conf.isMultiEC()) {
            entrada.setMultiEC(conf.isMultiEC());
            entrada.setCodigoGrupoMultiEC(conf.getCodigoGrupoMultiEC());
        }
        int retorno = 49;
        ArrayList<String> tabelas = new ArrayList<String>();
        int retries = 0;
        int maxRetries = 3;
        int indiceCarga = 1;
        do {
            perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO") + " (" + indiceCarga + ")"));
            SaidaApiTefC saida = dado.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                if (retries < maxRetries) {
                    this.logger.warn("Erro na tentativa de carga de tabelas. Efetuando tentativa " + ++retries + " de " + maxRetries + ".");
                    continue;
                }
                CMOSPinPad.getInstance().refazerCargaTabelas(redeChip);
                ILeitorCartaoHandler cartaoHandler = null;
                if (perifericos.getLeitorCartao() != null) {
                    cartaoHandler = perifericos.getLeitorCartao();
                    cartaoHandler.setSolicitaCargaTabelas(LeitorCartaoEMV.ERRO_SOLICITA_CARGA_TABELA);
                }
                Contexto.getContexto().atualizaEntradaApiTefC(entrada);
                return ERRO;
            }
            retries = 0;
            retorno = saida.getFlagCargaTabela();
            if (!saida.getTabela1Pin().trim().equals("")) {
                tabelas.addAll(this.converteDadosTabelaPin(saida.getTabela1Pin()));
            }
            if (!saida.getTabela2Pin().trim().equals("")) {
                tabelas.addAll(this.converteDadosTabelaPin(saida.getTabela2Pin()));
            }
            if (!saida.getTabela3Pin().trim().equals("")) {
                tabelas.addAll(this.converteDadosTabelaPin(saida.getTabela3Pin()));
            }
            entrada.setIndiceCargaTabelaPin(saida.getIndiceTabelaPin());
            entrada.setCodigoRedeCargaTabelaPin("00");
            ++indiceCarga;
        } while (retorno != 48);
        if (conf.isIntegracaoAndroid()) {
            CMOSPinPad.getInstance().setCacheCargaTabelas(leitorCartao.getRedeAdquirente(), tabelas);
        }
        dado.setConteudoTabelas(tabelas);
        return SUCESS;
    }

    public List<String> converteDadosTabelaPin(String registros) {
        int offset;
        ArrayList<String> vector = new ArrayList<String>();
        if (registros == null) {
            return vector;
        }
        for (int tam = 0; tam < registros.length(); tam += offset) {
            String strTam = registros.substring(tam, tam + 4);
            String strPin = registros.substring(tam + 4, tam + 7);
            offset = Integer.parseInt(strTam);
            int offsetPin = Integer.parseInt(strPin);
            vector.add(registros.substring(tam += 4, offsetPin + tam));
        }
        return vector;
    }
}

