/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicEnvioPreConsultaCartao {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        if (config.isIntegracaoWeb()) {
            return UNECESSARY;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        boolean multiEC = config.isMultiEC();
        IdentTerminal identTerminal = null;
        identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
        DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
        if (!dadosInicioDia.isHabilitaPreConsutaCartao()) {
            this.logger.log("DEBUG", "Pr\u00e9-consulta leitura cart\u00e3o desabilitada no inicio de dia");
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        entrada.setDataTransacao(Contexto.getContexto().getEntradaApiTefC().getDataTransacao());
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1G_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(15);
        entrada.setOperacao(this.getOperacao());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            this.logger.info(this.getOperacao() + " APROVADA");
            if (saidaApiTefC.isHabilitaContactless() != dadosInicioDia.isHabilitaContactless()) {
                this.logger.log("INFO", "Flag de uso de contactless alterado (" + (saidaApiTefC.isHabilitaContactless() ? "habilitado" : "desabilitado") + ")");
                dadosInicioDia.setHabilitaContactless(saidaApiTefC.isHabilitaContactless());
                controladorInicioDia.persistirDadosInicioDia(identTerminal, dadosInicioDia);
            }
            return SUCCESS;
        }
        this.logger.info(this.getOperacao() + " N\u00c3O APROVADA RETORNO :" + saidaApiTefC.getRetorno() + " CODIGO DETALHE " + saidaApiTefC.getCodigoErro());
        return ERROR;
    }

    protected String getOperacao() throws IllegalStateException {
        return "5S";
    }
}

