/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.SimpleDateFormat;

public class MicEnvioTransacaoConfirmacaoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_TRANS_JA_EFETUADA = "ERROR_TRANS_JA_EFETUADA";
    private static String PLANO_A_VISTA_DIGITADO = "A0";
    private static String PLANO_ADMINISTRADORA_DIGITADO = "1K";
    private static String PLANO_LOJISTA_DIGITADO = "1J";
    private static String PLANO_A_VISTA = "9F";
    private static String PLANO_ADMINISTRADORA = "1I";
    private static String PLANO_LOJISTA = "1H";
    private ILogger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if ("OPERACAO CONFIRMACAO PRE AUTORIZACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return PLANO_A_VISTA_DIGITADO;
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                    if (entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA_DIGITADO;
                    }
                    return PLANO_ADMINISTRADORA_DIGITADO;
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    if (entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA_DIGITADO;
                    }
                    return PLANO_LOJISTA_DIGITADO;
                }
            } else if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return PLANO_A_VISTA;
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                    if (entradaApiTefC.getNumeroParcelas() == 0 || entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA;
                    }
                    return PLANO_ADMINISTRADORA;
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    if (entradaApiTefC.getNumeroParcelas() == 0 || entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA;
                    }
                    return PLANO_LOJISTA;
                }
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost() && !conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        if (entrada.getNumeroParcelas() == -1) {
            entrada.setNumeroParcelas(0);
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && conf.isIntegracaoWeb()) {
            entrada.setNsuCtf(Contexto.getContexto().getEntradaIntegracao().getNsuCTF());
        }
        String bit62 = "";
        if (entrada.getDataTransacao() != null) {
            bit62 = new SimpleDateFormat("ddMM").format(entrada.getDataTransacao());
        }
        if (entrada.getCodigoAutorizacao() != null) {
            bit62 = bit62 + StringUtil.completaString(entrada.getCodigoAutorizacao(), 6, '0', 3);
        }
        String bit62Formatado = StringUtil.completaString(bit62, 10, '0', 3);
        entrada.setAdicionais(bit62Formatado);
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            if (saidaApiTefC.getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
                return SUCESS;
            }
            this.logger.log("INFO", "Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERROR_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        return SUCESS;
    }
}

