/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicEnvioTransacaoCreditoPrivateLabel {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    private ILogger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if ("OPERACAO CREDITO PRIVATE LABEL".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "DA";
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return "D9";
            }
        }
        if ("OPERACAO CONSULTA CREDITO PRIVATE LABEL".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "DC";
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return "DB";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encontrada");
    }

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!saidaApiTefC.isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        String numeroPlano = "";
        if (entrada.getNumeroPlano() != null) {
            numeroPlano = entrada.getNumeroPlano();
        }
        String bit62 = StringUtil.completaString(numeroPlano, 2, '0', 3);
        String ciclos = "";
        if (entrada.getNumeroCiclos() != -1) {
            ciclos = entrada.getNumeroCiclos() + "";
        }
        bit62 = bit62 + StringUtil.completaString(ciclos, 2, '0', 3);
        String numeroItem = "";
        if (entrada.getNumeroItem() != null) {
            numeroItem = entrada.getNumeroItem();
        }
        bit62 = bit62 + StringUtil.completaString(numeroItem, 11, '0', 3);
        String bit62Formatado = StringUtil.completaString(bit62, 15, '0', 3);
        entrada.setAdicionais(bit62Formatado);
        if (Contexto.getContexto().getPlano() == Plano.PRIVATELABEL_AVISTA) {
            Contexto.getContexto().getEntradaApiTefC().setNumeroParcelas(0);
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isCodigoTabelaCtrl()) {
            entrada.setCodigoTabela(Contexto.getContexto().getEntradaIntegracao().getCodigoTabela());
        } else if (conf.getCodigoTabela() > 0) {
            entrada.setCodigoTabela(conf.getCodigoTabela());
        }
        saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            if (saidaApiTefC.getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
                return SUCESS;
            }
            this.logger.log("INFO", "Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERRO;
        }
        return SUCESS;
    }
}

