/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;

public class MicEnvioTransacaoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_TRANS_JA_EFETUADA = "ERROR_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if ("OPERACAO PRE AUTORIZACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "7D";
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.MAGNETICO || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return "5F";
            }
        } else if ("OPERACAO ALTERACAO PRE AUTORIZACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getEntradaApiTefC().getValorTransacao() == null || Contexto.getContexto().getEntradaApiTefC().getValorTransacao().equals(new BigDecimal(0))) {
                return "GJ";
            }
            return "GI";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        String bit62Formatado = "";
        if (entrada.getValorParcela() != null) {
            bit62Formatado = entrada.getValorParcela().toString();
        }
        bit62Formatado = StringUtil.completaString(bit62Formatado, 20, '0', 3);
        entrada.setAdicionais(bit62Formatado);
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!saidaApiTefC.isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            if (saidaApiTefC.getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
                return SUCESS;
            }
            this.logger.log("INFO", "Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERROR_TRANS_JA_EFETUADA;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("077") && saidaApiTefC.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            return ERROR;
        }
        return SUCESS;
    }
}

