/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessAtualizacaoChip;
import com.csi.ctfclient.operacoes.action.ProcessAuto;
import com.csi.ctfclient.operacoes.action.ProcessConsultaAvs;
import com.csi.ctfclient.operacoes.action.ProcessConsultaCDC;
import com.csi.ctfclient.operacoes.action.ProcessConvenioCombustivel;
import com.csi.ctfclient.operacoes.action.ProcessCrediario;
import com.csi.ctfclient.operacoes.action.ProcessCredito;
import com.csi.ctfclient.operacoes.action.ProcessCreditoPrivateLabel;
import com.csi.ctfclient.operacoes.action.ProcessDebito;
import com.csi.ctfclient.operacoes.action.ProcessFuelControl;
import com.csi.ctfclient.operacoes.action.ProcessPagamentoContas;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessResgatePremio;
import com.csi.ctfclient.operacoes.action.ProcessVoucher;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicExecutaProcessTransacoesGenericas {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String REDIRECT = "REDIRECT";
    public static final String FLUXO_NOT_FOUND = "FLUXO_NOT_FOUND";
    public static final String FLUXO_NOT_FOUND_AC = "FLUXO_NOT_FOUND_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws Exception {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        int keyFluxo = 0;
        Integer produtoDinamico = null;
        int qtdProdutos = 0;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (entradaApiTefC.getCodigoProduto() != null) {
            keyFluxo = entradaApiTefC.getFluxoTef();
            produtoDinamico = entradaApiTefC.getCodigoProduto();
            qtdProdutos = saida.getProdutos().length;
        }
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(saida.getRedeMenuDinamico());
        String tipoOperacaoCrediario = null;
        String tipoOperacaoConsultaCDC = "OPERACAO CONSULTA CDC COM PARCELA A VISTA";
        if (qtdProdutos == 0 && produtoDinamico == null) {
            if (Contexto.getContexto().getTipoOperacao().equals("DEBITO GENERICO")) {
                keyFluxo = transacoesGenericas.KEY_FLUXO_DEBITO;
            } else if (Contexto.getContexto().getTipoOperacao().equals("CREDITO GENERICO")) {
                keyFluxo = transacoesGenericas.KEY_FLUXO_CREDITO;
            } else if (Contexto.getContexto().getTipoOperacao().equals("VOUCHER GENERICO")) {
                keyFluxo = transacoesGenericas.KEY_FLUXO_VOUCHER;
            } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CONSULTA CDC COM PARCELA A VISTA") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CONSULTA CDC COM PARCELA A VISTA")) {
                keyFluxo = transacoesGenericas.KEY_FLUXO_CONSULTA_CDC;
            } else if (Contexto.getContexto().equals("OPE_CREDITO_CREDIARIO") || Contexto.getContexto().equals("OPE_DEBITO_CREDIARIO")) {
                if (Contexto.getContexto().equals("OPE_CREDITO_CREDIARIO")) {
                    tipoOperacaoCrediario = "OPE_CREDITO_CREDIARIO";
                } else if (Contexto.getContexto().equals("OPE_DEBITO_CREDIARIO")) {
                    tipoOperacaoCrediario = "OPE_DEBITO_CREDIARIO";
                }
                keyFluxo = transacoesGenericas.KEY_FLUXO_CREDIARIO;
            } else if (Contexto.getContexto().equals("OPE_SIMULACAO_CREDIARIO_CREDITO")) {
                keyFluxo = transacoesGenericas.KEY_FLUXO_CONSULTA_CDC;
                tipoOperacaoConsultaCDC = "OPE_SIMULACAO_CREDIARIO_CREDITO";
            }
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO && saida.getTipoAutorizadora() == 1) {
            keyFluxo = transacoesGenericas.KEY_FLUXO_VOUCHER;
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        if (conf.isRotearPrivateLabel() && keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO && saida.getTipoAutorizadora() == 2) {
            keyFluxo = transacoesGenericas.KEY_FLUXO_CREDITO_PRIVATE_LABEL;
        }
        if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDIARIO) {
            if (Contexto.getContexto().getTipoOperacao().equals("OPE_CREDITO_CREDIARIO")) {
                tipoOperacaoCrediario = "OPE_CREDITO_CREDIARIO";
            } else if (Contexto.getContexto().getTipoOperacao().equals("OPE_DEBITO_CREDIARIO")) {
                tipoOperacaoCrediario = "OPE_DEBITO_CREDIARIO";
            } else if (Contexto.getContexto().getTipoOperacao().equals("CREDITO GENERICO")) {
                tipoOperacaoCrediario = "OPE_CREDITO_CREDIARIO";
            } else if (Contexto.getContexto().getTipoOperacao().equals("DEBITO GENERICO")) {
                tipoOperacaoCrediario = "OPE_DEBITO_CREDIARIO";
            }
        }
        if ((keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO || keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO) && saida.getTipoAutorizadora() == 5) {
            if (saida.getTipoProduto() == 3) {
                String retorno = this.executaProcessConvenioCombustivel(dados, qtdProdutos, null);
                if (retorno != null) {
                    return retorno;
                }
            } else {
                String retorno = this.executaProcessFuelControl(dados, qtdProdutos, null);
                if (retorno != null) {
                    return retorno;
                }
            }
        } else {
            String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
            if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO) {
                ProcessCredito processCredito = new ProcessCredito();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processCredito.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processCredito);
                dados.setErro(processCredito.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processCredito.getState() == 1) {
                    return ERRO;
                }
                if (processCredito.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_DEBITO) {
                ProcessDebito processDebito = new ProcessDebito();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processDebito.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processDebito);
                dados.setErro(processDebito.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processDebito.getState() == 1) {
                    return ERRO;
                }
                if (processDebito.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_VOUCHER) {
                ProcessVoucher processVoucher = new ProcessVoucher();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processVoucher.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processVoucher);
                dados.setErro(processVoucher.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processVoucher.getState() == 1) {
                    return ERRO;
                }
                if (processVoucher.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_CONSULTA_CDC) {
                ProcessConsultaCDC processConsultaCDC = new ProcessConsultaCDC(tipoOperacaoConsultaCDC);
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                Contexto.getContexto().setTipoOperacao(tipoOperacaoConsultaCDC);
                processConsultaCDC.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processConsultaCDC);
                dados.setErro(processConsultaCDC.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processConsultaCDC.getState() == 1) {
                    return ERRO;
                }
                if (processConsultaCDC.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO) {
                ProcessPreAutorizacao processPreAutorizacao = new ProcessPreAutorizacao();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processPreAutorizacao.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processPreAutorizacao);
                dados.setErro(processPreAutorizacao.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processPreAutorizacao.getState() == 1) {
                    return ERRO;
                }
                if (processPreAutorizacao.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_PGTO_CONTAS) {
                ProcessPagamentoContas processPagamentoContas = new ProcessPagamentoContas();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processPagamentoContas.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processPagamentoContas);
                dados.setErro(processPagamentoContas.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processPagamentoContas.getState() == 1) {
                    return ERRO;
                }
                if (processPagamentoContas.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_AVS) {
                ProcessConsultaAvs processConsultaAvs = new ProcessConsultaAvs();
                Contexto.getContexto().setSaidaApiTefC(null);
                processConsultaAvs.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processConsultaAvs);
                Contexto.getContexto().setOperacao(139);
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processConsultaAvs.getState() == 1) {
                    return ERRO;
                }
                if (processConsultaAvs.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDITO_PRIVATE_LABEL) {
                ProcessCreditoPrivateLabel processCreditoPrivateLabel = new ProcessCreditoPrivateLabel();
                Contexto.getContexto().setTipoOperacao("OPERACAO CREDITO PRIVATE LABEL");
                Contexto.getContexto().setSaidaApiTefC(null);
                Contexto.getContexto().setTransacaoGenerica(true);
                processCreditoPrivateLabel.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processCreditoPrivateLabel);
                dados.setErro(processCreditoPrivateLabel.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processCreditoPrivateLabel.getState() == 1) {
                    return ERRO;
                }
                if (processCreditoPrivateLabel.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_PLATAFORMA_PROMOCIONAL) {
                ProcessResgatePremio processResgatePremio = new ProcessResgatePremio();
                Contexto.getContexto().setSaidaApiTefC(null);
                processResgatePremio.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processResgatePremio);
                dados.setErro(processResgatePremio.getErro());
                Contexto.getContexto().setOperacao(254);
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processResgatePremio.getState() == 1) {
                    return ERRO;
                }
                if (processResgatePremio.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_VOUCHER_FROTA) {
                String retorno = this.executaProcessFuelControl(dados, qtdProdutos, null);
                if (retorno != null) {
                    return retorno;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_CREDIARIO) {
                ProcessCrediario processCrediario = new ProcessCrediario();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                Contexto.getContexto().setTipoOperacao(tipoOperacaoCrediario);
                processCrediario.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processCrediario);
                dados.setErro(processCrediario.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processCrediario.getState() == 1) {
                    return ERRO;
                }
                if (processCrediario.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_ATUALIZACAO_CHIP) {
                ProcessAtualizacaoChip processAtualizacaoChip = new ProcessAtualizacaoChip();
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processAtualizacaoChip.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processAtualizacaoChip);
                dados.setErro(processAtualizacaoChip.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processAtualizacaoChip.getState() == 1) {
                    return ERRO;
                }
                if (processAtualizacaoChip.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO || keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO_CONSULTA_SALDO) {
                String tipoOperacao = null;
                if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO) {
                    tipoOperacao = "OPERACAO AUTO";
                } else if (keyFluxo == transacoesGenericas.KEY_FLUXO_AUTO_CONSULTA_SALDO) {
                    tipoOperacao = "OPERACAO AUTO CONSULTA SALDO";
                }
                ProcessAuto processAuto = new ProcessAuto(tipoOperacao);
                if (qtdProdutos > 1) {
                    Contexto.getContexto().setSaidaApiTefC(null);
                }
                Contexto.getContexto().setTransacaoGenerica(true);
                processAuto.setParent(dados);
                ProcessManager.getInstance().subProcess(dados.getIdProcess(), processAuto);
                dados.setErro(processAuto.getErro());
                this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
                if (processAuto.getState() == 1) {
                    return ERRO;
                }
                if (processAuto.getState() == 4) {
                    Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
                    return REDIRECT;
                }
            } else {
                this.logger.log("ERROR", "Keyfluxo n\u00e3o encontrado: " + keyFluxo);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5330, this.inter.getMessage("EXEPROTRAGEN_FLUXO_NOT_FOUND")));
                return FLUXO_NOT_FOUND_AC;
            }
        }
        return SUCESS;
    }

    private void preencheDadosRetorno1F(SaidaApiTefC saidaApiTefC) {
        if (saidaApiTefC != null) {
            if (Contexto.getContexto().getDataAutorizadora() == null) {
                Contexto.getContexto().setDataAutorizadora(saidaApiTefC.getDataAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getCodigoVan())) {
                Contexto.getContexto().setCodigoVan(saidaApiTefC.getCodigoVan());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeVan())) {
                Contexto.getContexto().setNomeVan(saidaApiTefC.getNomeVan());
            }
            if (!VerifyContentUtil.verificaConteudoVazioCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora())) {
                Contexto.getContexto().setCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeAutorizadora())) {
                Contexto.getContexto().setNomeAutorizadora(saidaApiTefC.getNomeAutorizadora());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getCodigoInstituicaoFinanceira())) {
                Contexto.getContexto().setCodigoInstituicaoFinanceira(saidaApiTefC.getCodigoInstituicaoFinanceira());
            }
            if (!VerifyContentUtil.verificaConteudoVazio(saidaApiTefC.getNomeInstituicaoFinanceira())) {
                Contexto.getContexto().setNomeInstituicaoFinanceira(saidaApiTefC.getNomeInstituicaoFinanceira());
            }
        }
    }

    private String executaProcessFuelControl(Process dados, int qtdProdutos, Produto produtoDinamico) throws Exception {
        String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
        ProcessFuelControl processFuelControl = new ProcessFuelControl();
        Contexto.getContexto().setTipoOperacao("OPERACAO FUEL CONTROL");
        if (qtdProdutos > 1) {
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        Contexto.getContexto().setTransacaoGenerica(true);
        processFuelControl.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processFuelControl);
        dados.setErro(processFuelControl.getErro());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processFuelControl.getState() == 1) {
            return ERRO;
        }
        if (processFuelControl.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return null;
    }

    private String executaProcessConvenioCombustivel(Process dados, int qtdProdutos, Produto produtoDinamico) throws Exception {
        String tipoOperacaoOriginalRedirect = Contexto.getContexto().getTipoOperacao();
        ProcessConvenioCombustivel processConvenioCombustivel = new ProcessConvenioCombustivel(Contexto.getContexto().getEntradaIntegracao(), "OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO");
        processConvenioCombustivel.setPerifericos(dados.getPerifericos());
        processConvenioCombustivel.setParent(dados);
        ProcessManager.getInstance().subProcess(dados.getIdProcess(), processConvenioCombustivel);
        dados.setErro(processConvenioCombustivel.getErro());
        this.preencheDadosRetorno1F(Contexto.getContexto().getSaidaApiTefC());
        if (processConvenioCombustivel.getState() == 1) {
            return ERRO;
        }
        if (processConvenioCombustivel.getState() == 4) {
            Contexto.getContexto().setTipoOperacao(tipoOperacaoOriginalRedirect);
            return REDIRECT;
        }
        return null;
    }
}

