/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MicExibeMenuDinamico {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_PRODUCT_AC = "INVALID_PRODUCT_AC";
    public static final String MSG_INVALID_PRODUCT = "OPERACAO NAO PERMITIDA";
    private static Map mapProdutosFluxo;

    private static Map getMapProdutosFluxo(int redeMenuDinamico) {
        if (mapProdutosFluxo == null) {
            mapProdutosFluxo = MicExibeMenuDinamico.createMapProdutosFluxo(redeMenuDinamico);
        }
        return mapProdutosFluxo;
    }

    private static Map createMapProdutosFluxo(int redeMenuDinamico) {
        HashMap<Integer, Integer> mapaProdutosFluxo = new HashMap<Integer, Integer>();
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(redeMenuDinamico);
        mapaProdutosFluxo.put(new Integer(120), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(122), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(121), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(113), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(114), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(112), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(new Integer(110), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(new Integer(111), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(new Integer(405), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(new Integer(108), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(108), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(109), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(105), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(104), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(103), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(101), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(406), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(new Integer(106), new Integer(transacoesGenericas.KEY_FLUXO_VOUCHER));
        mapaProdutosFluxo.put(new Integer(119), new Integer(transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO));
        mapaProdutosFluxo.put(new Integer(127), new Integer(transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO));
        mapaProdutosFluxo.put(new Integer(267), new Integer(transacoesGenericas.KEY_FLUXO_CREDIARIO));
        return mapaProdutosFluxo;
    }

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        Produto[] produtosDisponiveis = saida.getProdutos();
        if (produtosDisponiveis.length == 0) {
            return UNECESSARY;
        }
        if (entradaIntegracao != null && entradaIntegracao.isOperacaoCtrl() && entradaIntegracao.getOperacao() != 223 && entradaIntegracao.getOperacao() != 224 && entradaIntegracao.getOperacao() != 101 && entradaIntegracao.getOperacao() != 222 && entradaIntegracao.getOperacao() != 128 && entradaIntegracao.getOperacao() != 411 && entradaIntegracao.getOperacao() != 900 && entradaIntegracao.getOperacao() != 902 && entradaIntegracao.getOperacao() != 903 && entradaIntegracao.getOperacao() != 901) {
            int keyFluxoSelecionadoOperacao = (Integer)MicExibeMenuDinamico.getMapProdutosFluxo(saida.getRedeMenuDinamico()).get(new Integer(entradaIntegracao.getOperacao()));
            ArrayList<Produto> listProdutosDisponiveis = new ArrayList<Produto>();
            for (int i = 0; i < produtosDisponiveis.length; ++i) {
                Produto produto = produtosDisponiveis[i];
                if (produto.getKeyFluxo() != keyFluxoSelecionadoOperacao) continue;
                listProdutosDisponiveis.add(produto);
            }
            Object[] objects = listProdutosDisponiveis.toArray();
            produtosDisponiveis = new Produto[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                produtosDisponiveis[i] = (Produto)objects[i];
            }
            if (produtosDisponiveis.length < 1) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, inter.getMessage("EXIMENDIN_INVALID_PRODUCT")));
                return INVALID_PRODUCT_AC;
            }
        }
        if (produtosDisponiveis.length > 10) {
            throw new IllegalArgumentException("N\u00e3o existem mais teclas para a sele\u00e7\u00e3o do produto");
        }
        if (produtosDisponiveis.length == 1) {
            Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtosDisponiveis[0].getCodigo());
            Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtosDisponiveis[0].getKeyFluxo());
            Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtosDisponiveis[0].getCodigoBandeira());
            return SUCESS;
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("EXIMENDIN_TITLE"), true);
        int iTecla = 1;
        for (int i = 0; i < produtosDisponiveis.length; ++i) {
            Produto produto = produtosDisponiveis[i];
            layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(iTecla++)));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtosDisponiveis[opcao - 1].getCodigo());
        Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtosDisponiveis[opcao - 1].getKeyFluxo());
        Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtosDisponiveis[opcao - 1].getCodigoBandeira());
        return SUCESS;
    }
}

