/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Premio;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.List;

public class MicExibeMenuResgatePremios {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String REWARD_UNAVAILABLE = "REWARD_UNAVAILABLE";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        List<Premio> listaPremios = saida.getListaPremios();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (listaPremios.size() == 0) {
            this.logger.log("INFO", "Nenhum pr\u00eamio dispon\u00edvel");
            LayoutDisplay displayModel = new LayoutDisplay(2);
            displayModel.addLinha(new Linha(inter.getMessage("EXIMENRESPRE_NAO_HA_PREMIACAO_1")));
            displayModel.addLinha(new Linha(inter.getMessage("EXIMENRESPRE_NAO_HA_PREMIACAO_2")));
            displayModel.addLinha(new Linha(inter.getMessage("EXIMENRESPRE_NAO_HA_PREMIACAO_3")));
            perifericos.imprimeDisplay(displayModel);
            if (perifericos.getPin() != null) {
                perifericos.getPin().setMsgDisplay("     NAO HA         PREMIACAO   ");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return REWARD_UNAVAILABLE;
        }
        LayoutMenu layoutMenu = new LayoutMenu(true);
        for (int i = 0; i < listaPremios.size(); ++i) {
            Premio premio = listaPremios.get(i);
            layoutMenu.addItem(new ItemMenu(premio.getDescricao(), String.valueOf(i + 1)));
        }
        if (perifericos.getPin() != null) {
            perifericos.getPin().setMsgDisplay("   RESGATE DE        PREMIOS    ");
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        perifericos.limpaDisplay();
        if (opcao == -1) {
            LayoutDisplay displayModel = new LayoutDisplay(2);
            String mensagemResgateNaoEfetuado = inter.getMessage("EXIMENRESPRE_RESGATE_NAO_EFETUADO");
            displayModel.addLinha(new Linha(mensagemResgateNaoEfetuado));
            perifericos.imprimeDisplay(displayModel);
            if (perifericos.getPin() != null) {
                perifericos.getPin().setMsgDisplay("  RESGATE NAO      EFETUADO     ");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ContextoCTFClient contexto = Contexto.getContexto();
            contexto.setSaidaApiTefC(null);
            contexto.setErroIntegracao(new CodigoErroIntegracao(5317, mensagemResgateNaoEfetuado));
            return USER_CANCEL;
        }
        entradaApiTefC.setPremio(listaPremios.get(opcao - 1));
        return SUCCESS;
    }
}

