/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.DadosListaPreset;
import com.csi.ctfclient.tools.devices.fusion.Preset;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;

public class MicExibeStatusBombasCombustivel {
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";
    private String[] statusPreset = new String[]{"AUTORIZADO", "ABASTECENDO", "BLOQUEADO", "PRONTO"};

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ILogger logger = CTFClientLogger.getCTFClient();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        dados.getPerifericos().imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        ControladorPerifericos perifericos = dados.getPerifericos();
        DadosListaPreset dadosListaPreset = null;
        try {
            dadosListaPreset = fusion.listarPresets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dadosListaPreset == null || dadosListaPreset.getResultado() != 0) {
            if (dadosListaPreset != null) {
                logger.log("ERROR", "Erro ao ler o status das bombas, c\u00f3digo: " + dadosListaPreset.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay(2);
        layoutDisplay.addLinha(new Linha("ANDAMENTO DO ABASTECIMENTO"));
        List listPreset = dadosListaPreset.getListPreset();
        Iterator itePreset = listPreset.iterator();
        DecimalFormat format2Zeros = new DecimalFormat("00");
        DecimalFormat formatVolume = new DecimalFormat("#,##0.000");
        if (listPreset.size() > 0) {
            while (itePreset.hasNext()) {
                Preset preset = (Preset)itePreset.next();
                String status = "";
                if (preset.getStatusPreset() >= 1 && preset.getStatusPreset() <= 4) {
                    status = StringUtil.completaString(this.statusPreset[preset.getStatusPreset() - 1], 11, ' ', 4);
                }
                String volumeAbastecimento = "";
                if (preset.getVolumeAbastecido() != null && preset.getVolumeAbastecido().compareTo(new BigDecimal(0)) == 1) {
                    volumeAbastecimento = formatVolume.format(preset.getVolumeAbastecido()) + " L";
                }
                String linha = format2Zeros.format(preset.getProduto().getBomba().getId()) + " - " + status + " " + volumeAbastecimento;
                layoutDisplay.addLinha(new ItemMenu(linha));
            }
        } else {
            layoutDisplay.addLinha(new Linha("SEM INFORMACOES DISPONIVEIS"));
        }
        perifericos.confirmaDado(layoutDisplay);
        return SUCCESS;
    }
}

