/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.SubComercio;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicFormataCamposIntegracao {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
            if (entradaIntegracao.isSoftDescriptorCtrl()) {
                this.logger.info("Software descriptor enviado pela AC: (" + entradaIntegracao.getSoftDescriptor() + ")");
                entrada.setSoftDescriptor(entradaIntegracao.getSoftDescriptor());
            }
            if (entradaIntegracao.isMccCtrl()) {
                this.logger.info("MCC enviado pela AC: (" + entradaIntegracao.getMcc() + ")");
                entrada.setMcc(entradaIntegracao.getMcc());
            }
            if (entradaIntegracao.isWalletUtilizadoCtrl()) {
                this.logger.info("Wallet utilizado enviado pela AC: (" + entradaIntegracao.getWalletUtilizado() + ")");
                entrada.setWalletUtilizado(entradaIntegracao.getWalletUtilizado());
            }
            if (entradaIntegracao.isIdentificadorWalletCtrl()) {
                this.logger.info("Identificador Wallet enviado pela AC: (" + entradaIntegracao.getIdentificadorWallet() + ")");
                entrada.setIdentificadorWallet(entradaIntegracao.getIdentificadorWallet());
            }
            if (entradaIntegracao.isConfigSubComercioCtrl()) {
                try {
                    String buffer = entradaIntegracao.getConfigSubComercio();
                    int offSet = 0;
                    SubComercio subComercio = new SubComercio();
                    subComercio.setId(buffer.substring(offSet, offSet + 15).trim());
                    subComercio.setCnpj(buffer.substring(offSet += 15, offSet + 14));
                    int tam = Integer.parseInt(buffer.substring(offSet += 14, offSet + 2));
                    subComercio.setLogradouro(buffer.substring(offSet += 2, offSet + tam));
                    subComercio.setCidade(buffer.substring(offSet += tam, offSet + 13).trim());
                    subComercio.setEstado(buffer.substring(offSet += 13, offSet + 2));
                    subComercio.setCep(buffer.substring(offSet += 2, offSet + 8));
                    entrada.setSubComercio(subComercio);
                }
                catch (Exception e) {
                    this.logger.error("nao foi possivel recuperar dados do subcomercio. " + e.getMessage());
                }
            }
            return SUCCESS;
        }
        return NOT_REQUIRED;
    }
}

