/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Vector;

public class MicLeituraTipoFinanciamentoIATA {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        boolean habilitadoFinanciadoLojista = saidaApiTefC.isPedePlanoLojista();
        boolean habilitadoAdministradora = saidaApiTefC.isPedePlanoAdministradora();
        if (Contexto.getContexto().getPlano() != null) {
            return FILLED;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isOperacaoCtrl() && entradaIntegracao.getOperacao() != 401 && entradaIntegracao.getOperacao() != 402) {
            int operacao = entradaIntegracao.getOperacao();
            if (operacao == 115 || operacao == 123 || operacao == 146 || operacao == 149) {
                if (!habilitadoAVista) return ERROR;
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (operacao == 116 || operacao == 124 || operacao == 147 || operacao == 150) {
                if (!habilitadoFinanciadoLojista) return ERROR;
                Contexto.getContexto().setPlano(Plano.LOJISTA_IATA);
                return SUCESS_APRAZOLOJISTA;
            }
            if (operacao == 117 || operacao == 125) {
                if (!habilitadoAdministradora) return ERROR;
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA_IATA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("LEITIPFINIAT_OPERATION_NOT_ALLOWED")));
            return ERROR_AC;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_AVISTA"));
        }
        if (habilitadoAdministradora) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_ADMINISTRADORA"));
        }
        if (habilitadoFinanciadoLojista) {
            vtTitleMenu.add(inter.getMessage("LEITIPFINIAT_MENU_FINANCIADO_LOJISTA"));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            Contexto.getContexto().setPlano(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (habilitadoAdministradora) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA_IATA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (!habilitadoFinanciadoLojista) return ERROR;
            Contexto.getContexto().setPlano(Plano.LOJISTA_IATA);
            return SUCESS_APRAZOLOJISTA;
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("LEITIPFINIAT_TITLE"), true);
        int iTecla = 1;
        for (int i = 0; i < vtTitleMenu.size(); ++i) {
            layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
            ++iTecla;
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
        if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_AVISTA"))) {
            Contexto.getContexto().setPlano(Plano.AVISTA);
            return SUCESS_AVISTA;
        }
        if (itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_FINANCIADO_LOJISTA"))) {
            Contexto.getContexto().setPlano(Plano.LOJISTA_IATA);
            return SUCESS_APRAZOLOJISTA;
        }
        if (!itemSelecionado.getTexto().equals(inter.getMessage("LEITIPFINIAT_MENU_ADMINISTRADORA"))) return ERROR;
        Contexto.getContexto().setPlano(Plano.ADMINISTRADORA_IATA);
        return SUCESS_APRAZOADMINISTRADO;
    }
}

