/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;

public class MicQuestionaVoucherSaldoParcial {
    public static final String SUCCESS = "SUCCESS";
    public static final String DENIED = "DENIED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        this.logger.log("DEBUG", "Pagamento com saldo do voucher permitido pela automa\u00e7\u00e3o e pelo TEF");
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        String valorTransacaoFormatado = format.format(entradaApiTefC.getValorTransacao().doubleValue());
        String valorSaldoFormatado = format.format(saidaApiTefC.getValorTransacao().doubleValue());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("SALDO INSUFIC. PARA PAGAMENTO TOTAL"));
        displayModel.addLinha(new Linha("VALOR VENDA:  " + valorTransacaoFormatado, 0, 1));
        displayModel.addLinha(new Linha("SALDO CARTAO: " + valorSaldoFormatado));
        displayModel.addLinha(new Linha(inter.getMessage("QUEVOUSALPAR_TITLE"), 0, 2));
        displayModel.addLinha(new Linha(inter.getMessage("QUEVOUSALPAR_PERMITE")));
        displayModel.addLinha(new Linha(inter.getMessage("QUEVOUSALPAR_NEGA")));
        int valor = 0;
        do {
            EventoTeclado eventoTeclado;
            if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_SALDO_VOUCHER)).getTeclaFinalizadora().equals("VOLTA")) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5377, "PAGAMENTO COM SALDO DO VOUCHER NAO AUTORIZADO"));
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String stringLida = eventoTeclado.getStringLida().substring(num);
            if (stringLida.length() <= 0) continue;
            valor = Integer.parseInt(stringLida.substring(num));
        } while (valor != 1 && valor != 2);
        switch (valor) {
            case 1: {
                return SUCCESS;
            }
            case 2: {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5377, "PAGAMENTO COM SALDO DO VOUCHER NAO AUTORIZADO"));
                entradaApiTefC.setMotivoDesfazimento(3);
                return DENIED;
            }
        }
        return DENIED;
    }
}

