/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoDotz;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicSelecionaProdutoDotz {
    public static String SUCCESS = "SUCCESS";
    public static String FILLED = "FILLED";
    public static String USER_CANCEL = "USER_CANCEL";
    public static String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getCodigoProduto() != null) {
            return FILLED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida.getListProdutosDotz().size() == 0) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5389, "NENHUM PRODUTO PARA RESGATE COM DOTZ"));
            return ERROR_AC;
        }
        List listProdutosDisponiveis = this.filtraProdutosDotz(saida.getListProdutosDotz(), entrada.getValorTransacao(), saida.getSaldoDotz());
        if (listProdutosDisponiveis.size() == 0) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5389, "NENHUM PRODUTO PARA RESGATE COM DOTZ"));
            return ERROR_AC;
        }
        DecimalFormat formatDotz = new DecimalFormat("#,##0.00");
        DecimalFormat formatValor = new DecimalFormat("#,##0.00");
        String[] titulo = new String[]{"SALDO DZ " + formatDotz.format(saida.getSaldoDotz()), "SELECIONE O VALE:"};
        LayoutMenu layoutMenu = new LayoutMenu(titulo, true);
        int iTecla = 1;
        for (ProdutoDotz produto : listProdutosDisponiveis) {
            String descricao = "VALE R$ " + formatValor.format(produto.getValor()) + " - DZ " + formatDotz.format(produto.getQuantidadePontos());
            layoutMenu.addItem(new ItemMenu(descricao, String.valueOf(iTecla++), 1));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        ProdutoDotz produto = (ProdutoDotz)listProdutosDisponiveis.get(opcao - 1);
        entrada.setProdutoSelecionadoDotz(produto.getCodigo());
        return SUCCESS;
    }

    private List filtraProdutosDotz(List listOriginal, BigDecimal valorTransacao, BigDecimal saldoDotz) {
        Iterator iteListaProdutos = listOriginal.iterator();
        ArrayList<ProdutoDotz> listFiltrada = new ArrayList<ProdutoDotz>();
        while (iteListaProdutos.hasNext()) {
            ProdutoDotz produto = (ProdutoDotz)iteListaProdutos.next();
            if (produto.getValor().compareTo(valorTransacao) > 0 || produto.getQuantidadePontos().compareTo(saldoDotz) > 0) continue;
            listFiltrada.add(produto);
        }
        return listFiltrada;
    }
}

