/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoConsultaTelefoneCreditoDigital {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        boolean multiTerminal;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        boolean bl = multiTerminal = Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
        if (entrada.getDdd() != null && entrada.getTelefone() != null) {
            DadosTelefone creditoDigital = new DadosTelefone();
            creditoDigital.setCodigoAutorizadora("");
            creditoDigital.setDdd(entrada.getDdd());
            creditoDigital.setTelefone(entrada.getTelefone());
            creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
            creditoDigital.setDigitoVerificadortelefone(0);
            creditoDigital.setCodigoUsuarioPdv("");
            creditoDigital.setVersaoLayout(conf.getVersaoLayoutCD());
            entrada.setDadosCreditoDigital(creditoDigital);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            entrada.setDataCliente(Contexto.getContexto().getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (!multiTerminal) {
            String msg1 = "SOLCREDIG_SOLICITACAO_CONSULTA1";
            String msg2 = "SOLCREDIG_SOLICITACAO_CONSULTA2";
            String msg3 = "SOLCREDIG_SOLICITACAO_CONSULTA3";
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        IdentApiTefC ident = new IdentApiTefC();
        SaidaApiTefC saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        saida.setDDD(entrada.getDdd());
        saida.setTelefone(entrada.getTelefone());
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if ("CONSULTA TELEFONE CREDITO DIGITAL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "FH";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

