/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicSolicitacaoConvenioCombustivel {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String REFAZER_PERGUNTAS = "REFAZER_PERGUNTAS";
    public static final String REFAZER_TRANSACAO = "REFAZER_TRANSACAO";
    public static final String CAPTURAR_SENHA = "CAPTURAR_SENHA";
    private ILogger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoApiAc {
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if ("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            entrada.setNumeroTransacao(0);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            entrada.setDataCliente(Contexto.getContexto().getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel() != null && !Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().isEmpty()) {
            Iterator<ProdutoConvenioCombustivel> iteLista = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().iterator();
            String codigos = "";
            while (iteLista.hasNext()) {
                ProdutoConvenioCombustivel produto = iteLista.next();
                codigos = codigos + produto.getCodigo();
            }
            this.logger.log("INFO", "C\u00f3digos dos produtos/servi\u00e7os selecionados: (" + codigos + ")");
            Contexto.getContexto().getEntradaApiTefC().setListProdutoConvenioCombustivel(Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel());
        }
        if (saida != null && saida.getCodigoPreAutorizacao() != null && saida.getCodigoPreAutorizacao().length() > 0) {
            entrada.setCodigoPreAutorizacao(saida.getCodigoPreAutorizacao());
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        Iterator iteMensagens = this.getListMensagensSolicitacao().iterator();
        while (iteMensagens.hasNext()) {
            layoutDisplay.addLinha(new Linha((String)iteMensagens.next()));
        }
        periferico.imprimeDisplay(layoutDisplay);
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCCESS;
        }
        if (saida.getCodigoRespostaAutorizadora().equals("001")) {
            Contexto.getContexto().getEntradaApiTefC().setInformacoesAdicionais(null);
            entrada.setFlagPerguntasAdicionais('1');
            return REFAZER_PERGUNTAS;
        }
        if (saida.getCodigoRespostaAutorizadora().equals("0XA")) {
            entrada.setFlagPerguntasAdicionais('2');
            if (saida.getValorTransacao() != null) {
                entrada.setValorTransacao(saida.getValorTransacao());
            }
            if (entrada.isSenhaCapturada()) {
                return REFAZER_TRANSACAO;
            }
            return CAPTURAR_SENHA;
        }
        this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
        return ERROR;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if ("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6N";
        }
        if ("OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
                return "6P";
            }
            return "6O";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    protected List getListMensagensSolicitacao() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO1"));
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO2"));
        list.add(this.inter.getMessage("ENVTRA_SOLICITACAO3"));
        return list;
    }
}

