/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.TrataLegadoUtil;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;

public class MicSolicitacaoCorrespondenteBancario {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        int modoEntrada = entrada.getModoEntradaCodigoBarras();
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntrada, entrada.getCodigoBarras(), Contexto.getContexto().getTipoPagamento());
        if (entrada.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimento(entrada.getDataVencimentoCorBan());
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            entrada.setInfo(entradaCorrespondenteBancario);
        } else {
            boolean corbanExecutaSubfluxos = Contexto.getContexto().isCorbanExecutaSubfluxos();
            if (corbanExecutaSubfluxos) {
                if (Contexto.getContexto().getTipoPagamento() == 1 || Contexto.getContexto().getTipoPagamento() == 2 || Contexto.getContexto().getTipoPagamento() == 3 || Contexto.getContexto().getTipoPagamento() == 6) {
                    entrada.setInfo(entradaCorrespondenteBancario);
                } else if (Contexto.getContexto().getTipoPagamento() == 5 || Contexto.getContexto().getTipoPagamento() == 4) {
                    entrada.setDadosCorrespondenteBancario(entradaCorrespondenteBancario);
                } else {
                    this.logger.log(ERROR, "Tipo de pagamento n\u00e3o identificado, c\u00f3digo de barras n\u00e3o ser\u00e1 enviado");
                }
            } else {
                entrada.setInfo(entradaCorrespondenteBancario);
            }
        }
        int timeout = saida != null ? saida.getTimeOutCTF() : 15;
        entrada.setTimeoutCtf(timeout);
        if (entrada.getCmc7() != null) {
            entrada.setAdicionais(entrada.getCmc7());
        }
        this.ecoarCamposConsultaCIP(saida, entrada);
        boolean limpaAcrescimo = false;
        if (entrada.getValorAcrescimo() == null) {
            entrada.setValorAcrescimo(new BigDecimal(0));
            limpaAcrescimo = true;
        }
        boolean limpaDesconto = false;
        if (entrada.getValorDesconto() == null) {
            entrada.setValorDesconto(new BigDecimal(0));
            limpaDesconto = true;
        }
        entrada.setValorTransacao(TrataLegadoUtil.calculaValorTransacao(dados));
        entrada.setOperacao(codigoTransacao);
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        String msg1 = null;
        String msg2 = null;
        String msg3 = null;
        if ("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO".equals(Contexto.getContexto().getTipoOperacao()) || "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO".equals(Contexto.getContexto().getTipoOperacao())) {
            msg1 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA1");
            msg2 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA2");
            msg3 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA3");
        } else {
            msg1 = inter.getMessage("ENVTRA_SOLICITACAO1");
            msg2 = inter.getMessage("ENVTRA_SOLICITACAO2");
            msg3 = inter.getMessage("ENVTRA_SOLICITACAO3");
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        displayModel.addLinha(new Linha(msg3));
        periferico.imprimeDisplay(displayModel);
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            Contexto.getContexto().setSaidaConsulta(saida);
        }
        if (limpaAcrescimo) {
            entrada.setValorAcrescimo(null);
        }
        if (limpaDesconto) {
            entrada.setValorDesconto(null);
        }
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("077") && saida.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        Contexto.getContexto().setCorrespondenteBancario(CorrespondenteBancario.createCorrespondenteBancario(saida.getAdicionais()));
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            String dataAntiga = null;
            String dataConsulta = null;
            if (entrada.getDataVencimentoCorBan() != null) {
                dataAntiga = dateFormat.format(entrada.getDataVencimentoCorBan());
            }
            if (saida.getDataVencimentoCorBan() != null) {
                dataConsulta = dateFormat.format(saida.getDataVencimentoCorBan());
            }
            if (saida.getDataVencimentoCorBan() != null) {
                this.logger.info("Data de vencimento do boleto retornada pela consulta, substituindo " + dataAntiga + " por " + dataConsulta);
                entrada.setDataVencimentoCorBan(saida.getDataVencimentoCorBan());
            }
        }
        return SUCESS;
    }

    private void ecoarCamposConsultaCIP(SaidaApiTefC saida, EntradaApiTefC entrada) {
        if (saida.getInstituicaoEmissora() != null && entrada.getInstituicaoEmissora() == null) {
            entrada.setInstituicaoEmissora(saida.getInstituicaoEmissora());
        }
        if (saida.getBeneficiarioNomeFantasia() != null && entrada.getBeneficiarioNomeFantasia() == null) {
            entrada.setBeneficiarioNomeFantasia(saida.getBeneficiarioNomeFantasia());
        }
        if (saida.getBeneficiarioRazaoSocial() != null && entrada.getBeneficiarioRazaoSocial() == null) {
            entrada.setBeneficiarioRazaoSocial(saida.getBeneficiarioRazaoSocial());
        }
        if (saida.getBeneficiarioCpfCnpj() != null && entrada.getBeneficiarioCpfCnpj() == null) {
            entrada.setBeneficiarioCpfCnpj(saida.getBeneficiarioCpfCnpj());
        }
        if (saida.getSacadorRazaoSocial() != null && entrada.getSacadorRazaoSocial() == null) {
            entrada.setSacadorRazaoSocial(saida.getSacadorRazaoSocial());
        }
        if (saida.getSacadorCpfCnpj() != null && entrada.getSacadorCpfCnpj() == null) {
            entrada.setSacadorCpfCnpj(saida.getSacadorCpfCnpj());
        }
        if (saida.getPagadorRazaoSocial() != null && entrada.getPagadorRazaoSocial() == null) {
            entrada.setPagadorRazaoSocial(saida.getPagadorRazaoSocial());
        }
        if (saida.getPagadorCpfCnpj() != null && entrada.getPagadorCpfCnpj() == null) {
            entrada.setPagadorCpfCnpj(saida.getPagadorCpfCnpj());
        }
    }

    private String getCodigoTransacao(Process dados) {
        boolean corbanExecutaSubfluxos = Contexto.getContexto().isCorbanExecutaSubfluxos();
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO")) {
            return "E4";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            return "E5";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO")) {
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 4) {
                return "2T";
            }
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 5) {
                return "EY";
            }
            return "E6";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO")) {
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 4) {
                return "2P";
            }
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 5) {
                return "EZ";
            }
            return "E7";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO")) {
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 4) {
                return "2T";
            }
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 5) {
                return "EY";
            }
            return "E6";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO")) {
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 4) {
                return "2P";
            }
            if (corbanExecutaSubfluxos && Contexto.getContexto().getTipoPagamento() == 5) {
                return "EZ";
            }
            return "E7";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

