/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoCreditoDebito4All {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        PinEMV pinEMV = periferico.getPin();
        boolean bl = connectedPin = pinEMV != null;
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_autorizacao);
            periferico.imprimeDisplay(displayModel);
        }
        if (connectedPin && !Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            pinEMV.setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCCESS;
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if ("OPERACAO CREDITO 4ALL".equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return "4W";
            }
            if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                return "4Z";
            }
            if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                return "4Y";
            }
        } else if ("OPERACAO DEBITO 4ALL".equals(Contexto.getContexto().getTipoOperacao())) {
            return "4X";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

