/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoResgateFidelidadeMilhas {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (!multiTerminal) {
            entrada.setTimeoutCtf(saida.getTimeOutCTF());
            String msg1 = null;
            String msg2 = null;
            String msg3 = null;
            if ("OPE_CONSULTA_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = "SOLICITACAO_CONSULTA1";
                msg2 = "SOLICITACAO_CONSULTA2";
                msg3 = "SOLICITACAO_CONSULTA3";
            } else if ("OPE_RESGATE_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
                msg1 = "ENVTRA_SOLICITACAO1";
                msg2 = "ENVTRA_SOLICITACAO2";
                msg3 = "ENVTRA_SOLICITACAO3";
            }
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(msg1)));
            displayModel.addLinha(new Linha(inter.getMessage(msg2)));
            displayModel.addLinha(new Linha(inter.getMessage(msg3)));
            periferico.imprimeDisplay(displayModel);
        }
        saida = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        if ("OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
            this.logger.log("INFO", "Quantidade de milhas a utilizar: " + saida.getValorMilhas());
            entrada.setValorMilhas(saida.getValorMilhas());
            Contexto.getContexto().setTipoOperacao("OPE_RESGATE_FIDELIDADE_EM_MILHAS");
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if ("OPE_CONSULTA_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6Y";
        }
        if ("OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6W";
        }
        if ("OPE_RESGATE_FIDELIDADE_EM_MILHAS".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6X";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

