/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractSolicitacaoCartaoTEF;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class MicSolicitacaoSaque
extends MicAbstractSolicitacaoCartaoTEF {
    @Override
    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pinEMV = null;
        try {
            pinEMV = periferico.getPin();
        }
        catch (ExcecaoPerifericos e) {
            e.printStackTrace();
        }
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(pinEMV, ControladorCriptografia.getTabelaCriptografia());
        if ("OPE_SAQUE_CARTAO_CREDITO".equals(tipoOperacao)) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return "3J";
            }
            if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                return "3P";
            }
            throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrado. Verificar o tipo de financiamento de saque com cart\u00e3o de cr\u00e9dito");
        }
        if ("OPE_SAQUE_CARTAO_DEBITO".equals(tipoOperacao)) {
            return "15";
        }
        if ("OPE_SIMULACAO_SAQUE_CREDITO".equals(tipoOperacao)) {
            return "3L";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

