/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;

public class MicSolicitacaoTrocaSenha {
    private ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setValorTransacao(new BigDecimal(0));
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            entrada.setDataCliente(Contexto.getContexto().getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        PinEMV pinEMV = periferico.getPin();
        boolean connectedPin = pinEMV != null;
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        if (tabelaCriptografia != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        if (connectedPin) {
            pinEMV.setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        VerifyContentUtil.preencheDadosSaida(saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        if (Contexto.getContexto().getTipoOperacao().equals("OPE_TROCA_SENHA") && Contexto.getContexto().getCartao() == Cartao.CHIP) {
            if (Contexto.getContexto().getEntradaApiTefC().getTipoAplicacaoChip() == Integer.parseInt("01")) {
                return "3V";
            }
            if (Contexto.getContexto().getEntradaApiTefC().getTipoAplicacaoChip() == Integer.parseInt("02")) {
                return "3W";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

