/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolicitacaoVoucher {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(periferico.getPin(), ControladorCriptografia.getTabelaCriptografia());
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        boolean pagarSaldoVoucher = false;
        if (entradaIntegracao != null && entradaIntegracao.getOperacao() != 107 || entradaIntegracao == null) {
            if (entradaIntegracao != null && entradaIntegracao.isPermiteAprovacaoValorParcial()) {
                this.logger.log("INFO", "Pagamento com saldo do voucher (AC - permite aprova\u00e7\u00e3o do valor parcial): " + entradaIntegracao.isPermiteAprovacaoValorParcial());
                pagarSaldoVoucher = entradaIntegracao.isPermiteAprovacaoValorParcial();
            } else {
                this.logger.log("INFO", "Pagamento com saldo do voucher (Config Client): " + conf.isPermitePagarSaldoVoucher());
                pagarSaldoVoucher = conf.isPermitePagarSaldoVoucher();
            }
        }
        if (pagarSaldoVoucher && saida.isPagamentoComSaldoVoucher()) {
            entrada.setPermiteAprovacaoValorParcial(true);
        } else {
            entrada.setPermiteAprovacaoValorParcial(false);
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        saida = dados.getApitef().solicitacao(ident, entrada);
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
                if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                    return ERRO_TRANS_JA_EFETUADA;
                }
                if (saida.getCodigoRespostaAutorizadora().equals("0F5")) {
                    return ERRO_NAO_AUT_CARTAO;
                }
                return ERRO;
            }
            if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
                conBaixaTecnica.persisteBaixaTecnica();
            }
            VerifyContentUtil.preencheDadosSaida(saida);
            return SUCESS;
        }
        return SUCESS;
    }

    protected String getCodigoTransacao(Process dado) throws IllegalStateException {
        if (Contexto.getContexto().getEntradaIntegracao() != null && 107 == Contexto.getContexto().getEntradaIntegracao().getOperacao()) {
            return "6B";
        }
        if ("OPERACAO VOUCHER".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6A";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

