/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCelular;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class MicSubProcessCreditoCelular {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws Exception {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCreditoCelular processCelular = null;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getOperacao() == 112) {
                entradaIntegracao.setOperacao(232);
            } else if (entradaIntegracao.getOperacao() == 113) {
                entradaIntegracao.setOperacao(233);
            } else if (entradaIntegracao.getOperacao() == 114) {
                entradaIntegracao.setOperacao(234);
            }
            processCelular = new ProcessCreditoCelular(entradaIntegracao, entradaApiTefC.getNumeroTransacao());
        } else {
            processCelular = new ProcessCreditoCelular(entradaApiTefC.getNumeroTransacao(), entradaApiTefC.getValorTransacao());
        }
        boolean comunicacaoSeguraOld = ProtocoloBibliotecaCompartilhada.isComunicacaoSeguraHabilitada();
        ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(false);
        processManager.subProcess(dados.getIdProcess(), processCelular);
        ProtocoloBibliotecaCompartilhada.setComunicacaoSeguraHabilitada(comunicacaoSeguraOld);
        Contexto.getContexto().setSubProcess(processCelular);
        switch (processCelular.getState()) {
            case 1: {
                return ERROR;
            }
            case 3: {
                return USER_CANCEL;
            }
            case 0: {
                return SUCCESS;
            }
            case 2: {
                return SUCCESS;
            }
        }
        return SUCCESS;
    }
}

