/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MicVencimentoCartao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_INVALID_DATA = "ERRO_INVALID_DATA";
    public static final String ERRO_INVALID_DATA_AC = "ERRO_INVALID_DATA_AC";
    public static final String ERRO_INVALID_DATA_21YEAR = "ERRO_INVALID_DATA_21YEAR";
    public static final String ERRO_INVALID_DATA_21YEAR_AC = "ERRO_INVALID_DATA_21YEAR_AC";

    public String execute(Process dadoCartao) throws ExcecaoNaoLocal, IllegalArgumentException {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !saidaApiTefC.isSolicitarDataVencimentoCartao()) {
            return UNECESSARY;
        }
        if (entradaApiTefC.getDataVencimento() != null) {
            return UNECESSARY;
        }
        if (Contexto.getContexto().getCartao() != Cartao.DIGITADO) {
            throw new IllegalArgumentException("Argumento do parametro getCartao() n\u00e3o \u00e9 uma instancia de CartaoDigitado");
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isDataVencimentoCartaoCtrl()) {
                String dataVencimento = entradaIntegracao.getDataVencimentoCartao();
                if (!MicVencimentoCartao.isValidaVencimento(dataVencimento)) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5302, inter.getMessage("VENCAR_CARTAO_VENCIDO")));
                    return ERRO_INVALID_DATA_AC;
                }
                if (!MicVencimentoCartao.isValidaVencimento21Anos(dataVencimento)) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("VENCAR_NOT_VALID")));
                    return ERRO_INVALID_DATA_21YEAR_AC;
                }
                Contexto.getContexto().getEntradaApiTefC().setDataVencimento(this.formataVencimento(dataVencimento));
                return SUCESS;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5303, inter.getMessage("VENCAR_NOT_VALID")));
                return ERRO_INVALID_DATA_AC;
            }
        }
        ControladorPerifericos perifericos = dadoCartao.getPerifericos();
        String digitos = null;
        int qtdDigitado = 0;
        while (qtdDigitado < 4) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("VENCAR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_DATA_VENCIMENTO_CARTAO, 0, false, 9, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            qtdDigitado = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(0, num);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMyy");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(digitos);
        }
        catch (ParseException e) {
            this.exibeMensagem(perifericos, inter.getMessage("VENCAR_NOT_VALID_DATE"));
            return ERRO_INVALID_DATA;
        }
        Contexto.getContexto().getEntradaApiTefC().setDataVencimento(this.formataVencimento(digitos));
        return SUCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }

    private Date formataVencimento(String vencimento) {
        try {
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            int day = 1;
            String dataString = StringUtil.completaString("" + day, 2, '0', 3);
            dataString = dataString + StringUtil.completaString("" + month, 2, '0', 3);
            dataString = dataString + year;
            Date date = new SimpleDateFormat("ddMMyyyy").parse(dataString);
            return date;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Vencimento Invalido " + vencimento);
        }
    }

    public static boolean isValidaVencimento21Anos(String vencimento) {
        try {
            Date dataVencimento;
            Date nowDate = new Date();
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(nowDate);
            calender.add(1, 20);
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMyy");
            dateFormat.setLenient(false);
            String monthStr = String.valueOf(month);
            if (month < 10) {
                monthStr = "0" + month;
            }
            return !(dataVencimento = dateFormat.parse(monthStr + year)).after(calender.getTime());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidaVencimento(String vencimento) {
        if (vencimento.length() != 4) {
            return false;
        }
        try {
            Date dataVencimento;
            Date nowDate = new Date();
            SimpleDateFormat nowFormat = new SimpleDateFormat("MMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
            dateFormat.setLenient(false);
            String monthStr = String.valueOf(month);
            if (month < 10) {
                monthStr = "0" + month;
            }
            return !(dataVencimento = dateFormat.parse(monthStr + year)).before(nowDate);
        }
        catch (ParseException e) {
            return false;
        }
    }
}

