/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.Formatter;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicVerificaComunicacaoCTF {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_RETURN_AC = "ERRO_RETURN_AC";
    public static final String USER_CANCEL_1F = "USER_CANCEL_1F";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(Process dado) throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dado.getPerifericos();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        int key = saida.getRetorno();
        String msg = "";
        if (key <= 0) return SUCESS;
        switch (key) {
            case 1: {
                msg = "TENTE DE NOVO-TO";
                break;
            }
            case 2: {
                msg = "TEF NAO INICIALIZADO";
                break;
            }
            case 3: {
                msg = "TRANSACAO EXCEDE LIMITE";
                break;
            }
            case 4: {
                msg = "ERRO NOS PARAMETROS: " + Contexto.getContexto().getSaidaApiTefC().getCodigoErro();
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                msg = "AUTORIZADORA OFF-LINE";
                break;
            }
            case 10: {
                msg = "ERRO DE COMUNICACAO: " + saida.getCodigoErro();
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                msg = "ERRO NO INTERTEF: " + saida.getCodigoErro();
                break;
            }
            case 13: {
                return SUCESS;
            }
        }
        if (!msg.trim().equals("") && (Contexto.getContexto().getEntradaIntegracao() == null || Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isMultiTerminal())) {
            periferico.limpaDisplay();
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (msg != null && msg.length() > 0) {
                if (Contexto.getContexto().getEntradaApiTefC() != null && (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2N") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F"))) {
                    if (this.isTransacaoRetornaAC()) {
                        this.montaMsgDisplay(saida, msg);
                        return ERRO_RETURN_AC;
                    }
                    if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                        return ERRO;
                    }
                    this.exibeMensagemDisplay(periferico, msg);
                } else {
                    this.montaMsgDisplay(saida, msg);
                }
            } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F")) {
                String resposta;
                if (this.isTransacaoRetornaAC()) return ERRO_RETURN_AC;
                if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                    return ERRO;
                }
                this.montaMsgDisplay(periferico, saida);
                if (this.exibeMensagemDisplay(periferico, saida.getDisplayCTF()).equals("VOLTA") && ((resposta = saida.getCodigoRespostaAutorizadora()).equals("0F0") || resposta.equals("F0"))) {
                    return USER_CANCEL_1F;
                }
            }
        } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2M")) {
            if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                return ERRO;
            }
            if (msg.trim().equals("")) {
                this.montaMsgDisplay(periferico, saida);
            } else {
                this.exibeMensagemDisplay(periferico, msg);
            }
        } else {
            this.montaMsgDisplay(saida, msg);
        }
        if (confCTFClient.isIntegracaoWeb() || periferico.getPin() == null) return ERRO;
        this.montaMsgPinpad(periferico, saida);
        return ERRO;
    }

    public void montaMsgPinpad(ControladorPerifericos perifericos, SaidaApiTefC saida) throws ExcecaoApiAc {
        String[] mensagens = saida.getMensagemDisplayPin().split("#");
        String msgPinPad = "";
        for (int i = 0; i < mensagens.length; ++i) {
            msgPinPad = msgPinPad + StringUtil.completaString(mensagens[i], 16, ' ', false);
        }
        if (msgPinPad.trim().length() > 0) {
            this.exibePinpadComDelay(perifericos, msgPinPad);
        }
    }

    private void exibePinpadComDelay(ControladorPerifericos perifericos, String msg) throws ExcecaoApiAc {
        BibliotecaPinpad pinPad = (BibliotecaPinpad)perifericos.getPin();
        pinPad.setMsgDisplay(msg);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pinPad.setMsgDisplay(pinPad.getMsgPrompt());
    }

    public void montaMsgDisplay(ControladorPerifericos periferico, SaidaApiTefC saida) throws ExcecaoApiAc {
        boolean display = false;
        if (this.exibeGrupoMensagens(periferico, saida.getDisplayCTF())) {
            display = true;
        }
        if (!display && !saida.getCodigoAutorizadora().equals("00") && saida.getCodigoRespostaAutorizadora() != null) {
            this.exibeMensagemDisplay(periferico, "ERRO: " + saida.getCodigoRespostaAutorizadora());
        }
    }

    public void montaMsgDisplay(SaidaApiTefC saida, String msg) {
        if (msg != null && msg.length() > 0) {
            String tam = String.valueOf(msg.length());
            tam = StringUtil.completaString(tam, 4, '0', 3);
            msg = tam + msg;
            saida.setDisplayCTF(msg);
        }
    }

    private boolean exibeGrupoMensagens(ControladorPerifericos periferico, String[] mensagens) throws ExcecaoApiAc {
        boolean retorno = false;
        if (mensagens != null && mensagens.length > 0) {
            for (int i = 0; i < mensagens.length; ++i) {
                String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(mensagens[i]) : mensagens[i].split("#");
                this.exibeMensagemComDelay(periferico, msgs);
            }
            retorno = true;
        }
        return retorno;
    }

    private void exibeMensagemComDelay(ControladorPerifericos periferico, String[] msg) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setDelay(1500L);
        for (int i = 0; i < msg.length; ++i) {
            displayModel.addLinha(new Linha(msg[i]));
        }
        periferico.imprimeDisplay(displayModel);
    }

    private String exibeMensagemDisplay(ControladorPerifericos periferico, String msg) throws ExcecaoApiAc {
        String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(msg) : new String[]{msg};
        return this.exibeMensagemDisplay(periferico, msgs);
    }

    private String exibeMensagemDisplay(ControladorPerifericos periferico, String[] msgs) throws ExcecaoApiAc {
        EventoTeclado evt = null;
        LayoutDisplay displayModel = new LayoutDisplay();
        if (msgs.length > 0) {
            for (int x = 0; x < msgs.length; ++x) {
                String[] msgLinha = msgs[x].split("#");
                for (int i = 0; i < msgLinha.length; ++i) {
                    displayModel.addLinha(new Linha(msgLinha[i]));
                }
            }
        }
        evt = (EventoTeclado)periferico.confirmaDado(displayModel);
        return evt.getTeclaFinalizadora();
    }

    public boolean isTransacaoRetornaAC() {
        int operacao = Contexto.getContexto().getEntradaIntegracao().getOperacao();
        if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
            return true;
        }
        if (operacao == 120 || operacao == 123 || operacao == 125 || operacao == 124 || operacao == 122 || operacao == 121 || operacao == 143 || operacao == 149 || operacao == 150 || operacao == 133 || operacao == 170 || operacao == 169 || operacao == 126 || operacao == 145 || operacao == 155 || operacao == 153) {
            return true;
        }
        if (Contexto.getContexto().getEntradaIntegracao().isNumeroCartaoCtrl()) {
            if (operacao == 112) {
                return true;
            }
            if (operacao == 300) {
                return true;
            }
            return operacao == 262;
        }
        return false;
    }

    public boolean validaFallBack(SaidaApiTefC saida) {
        String operacao;
        return saida != null && saida.getCodigoRespostaAutorizadora() != null && ((operacao = saida.getCodigoRespostaAutorizadora()).equals("F3") || operacao.equals("0F3"));
    }
}

